/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.graph.api.Node;
import org.gephi.tools.spi.NodePressingEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.gephi.ui.tools.plugin.PainterPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class Painter
implements Tool {
    private ToolEventListener[] listeners;
    private PainterPanel painterPanel;
    private float[] color = new float[]{1.0f, 0.0f, 0.0f};
    private float intensity = 0.3f;

    public void select() {
    }

    public void unselect() {
        this.listeners = null;
        this.painterPanel = null;
    }

    public ToolEventListener[] getListeners() {
        this.listeners = new ToolEventListener[1];
        this.listeners[0] = new NodePressingEventListener(){

            public boolean pressingNodes(Node[] nodes) {
                if (nodes == null || nodes.length == 0) {
                    return false;
                }
                Painter.this.color = Painter.this.painterPanel.getColor().getColorComponents(Painter.this.color);
                for (Node node : nodes) {
                    float r = node.r();
                    float g = node.g();
                    float b = node.b();
                    r = Painter.this.intensity * Painter.this.color[0] + (1.0f - Painter.this.intensity) * r;
                    g = Painter.this.intensity * Painter.this.color[1] + (1.0f - Painter.this.intensity) * g;
                    b = Painter.this.intensity * Painter.this.color[2] + (1.0f - Painter.this.intensity) * b;
                    node.setR(r);
                    node.setG(g);
                    node.setB(b);
                }
                return true;
            }

            public boolean released() {
                return false;
            }
        };
        return this.listeners;
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                Painter.this.painterPanel = new PainterPanel();
                Painter.this.painterPanel.setColor(new Color(Painter.this.color[0], Painter.this.color[1], Painter.this.color[2]));
                return Painter.this.painterPanel;
            }

            public String getName() {
                return NbBundle.getMessage(Painter.class, (String)"Painter.name");
            }

            public Icon getIcon() {
                return ImageUtilities.loadImageIcon((String)"ToolsPlugin/painter.svg", (boolean)false);
            }

            public String getDescription() {
                return NbBundle.getMessage(Painter.class, (String)"Painter.description");
            }

            public int getPosition() {
                return 100;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.SELECTION;
    }
}

