/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.graph.api.Node;
import org.gephi.tools.spi.NodePressAndDraggingEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class NodesDragger
implements Tool {
    private ToolEventListener[] listeners;
    private Node[] nodes;
    private float[] initialX;
    private float[] initialY;

    public void select() {
    }

    public void unselect() {
        this.listeners = null;
        this.nodes = null;
    }

    public ToolEventListener[] getListeners() {
        this.listeners = new ToolEventListener[1];
        this.listeners[0] = new NodePressAndDraggingEventListener(){

            public boolean pressNodes(Node[] nodes) {
                NodesDragger.this.nodes = nodes;
                NodesDragger.this.initialX = new float[nodes.length];
                NodesDragger.this.initialY = new float[nodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    Node n = nodes[i];
                    NodesDragger.this.initialX[i] = n.x();
                    NodesDragger.this.initialY[i] = n.y();
                }
                return true;
            }

            public void released() {
                NodesDragger.this.nodes = null;
            }

            public boolean drag(float displacementXScreen, float displacementYScreen, float displacementXWorld, float displacementYWorld) {
                if (NodesDragger.this.nodes != null && NodesDragger.this.nodes.length > 0) {
                    for (int i = 0; i < NodesDragger.this.nodes.length; ++i) {
                        Node n = NodesDragger.this.nodes[i];
                        n.setX(NodesDragger.this.initialX[i] + displacementXWorld);
                        n.setY(NodesDragger.this.initialY[i] + displacementYWorld);
                    }
                    return false;
                }
                return false;
            }
        };
        return this.listeners;
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                return null;
            }

            public String getName() {
                return NbBundle.getMessage(NodesDragger.class, (String)"NodesDragger.name");
            }

            public Icon getIcon() {
                return ImageUtilities.loadImageIcon((String)"ToolsPlugin/drag.svg", (boolean)false);
            }

            public String getDescription() {
                return NbBundle.getMessage(NodesDragger.class, (String)"NodesDragger.description");
            }

            public int getPosition() {
                return 0;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.SELECTION;
    }
}

