/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.graph.api.Node;
import org.gephi.tools.api.EditWindowController;
import org.gephi.tools.spi.NodeClickEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Edit
implements Tool {
    private EditWindowController edc;

    public void select() {
        this.edc = (EditWindowController)Lookup.getDefault().lookup(EditWindowController.class);
        this.edc.openEditWindow();
    }

    public void unselect() {
        this.edc.disableEdit();
        this.edc.closeEditWindow();
    }

    public ToolEventListener[] getListeners() {
        return new ToolEventListener[]{new NodeClickEventListener(){

            public boolean clickNodes(Node[] nodes) {
                if (nodes != null && nodes.length > 0) {
                    Edit.this.edc.editNode(nodes[0]);
                } else {
                    Edit.this.edc.disableEdit();
                }
                return true;
            }
        }};
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                return new JPanel();
            }

            public Icon getIcon() {
                return ImageUtilities.loadImageIcon((String)"ToolsPlugin/edit.svg", (boolean)false);
            }

            public String getName() {
                return NbBundle.getMessage(Edit.class, (String)"Edit.name");
            }

            public String getDescription() {
                return NbBundle.getMessage(Edit.class, (String)"Edit.description");
            }

            public int getPosition() {
                return 10;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.SELECTION;
    }
}

