/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Partition;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.partition.PartitionUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PartitionBuilder
implements CategoryBuilder {
    private static final Category PARTITION = new Category(NbBundle.getMessage(PartitionBuilder.class, (String)"PartitionBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return PARTITION;
    }

    public FilterBuilder[] getBuilders(Workspace workspace) {
        PartitionFilterBuilder builder;
        Partition partition;
        ArrayList<PartitionFilterBuilder> builders = new ArrayList<PartitionFilterBuilder>();
        GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        AppearanceModel am = ((AppearanceController)Lookup.getDefault().lookup(AppearanceController.class)).getModel(workspace);
        am.getNodeFunctions();
        am.getEdgeFunctions();
        for (Column nodeCol : gm.getNodeTable()) {
            if (nodeCol.isProperty() || (partition = am.getNodePartition(nodeCol)) == null) continue;
            builder = new PartitionFilterBuilder(partition);
            builders.add(builder);
        }
        for (Column edgeCol : gm.getEdgeTable()) {
            if (edgeCol.isProperty() || (partition = am.getEdgePartition(edgeCol)) == null) continue;
            builder = new PartitionFilterBuilder(partition);
            builders.add(builder);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    private static class PartitionFilterBuilder
    implements FilterBuilder {
        private final Partition partition;

        public PartitionFilterBuilder(Partition partition) {
            this.partition = partition;
        }

        public Category getCategory() {
            return PARTITION;
        }

        public String getName() {
            return this.partition.getColumn().getTitle() + " (" + (AttributeUtils.isNodeColumn((Column)this.partition.getColumn()) ? NbBundle.getMessage(PartitionFilterBuilder.class, (String)"PartitionFilterBuilder.name.node") : NbBundle.getMessage(PartitionFilterBuilder.class, (String)"PartitionFilterBuilder.name.edge")) + ")";
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(PartitionBuilder.class, (String)"PartitionBuilder.description");
        }

        public PartitionFilter getFilter(Workspace workspace) {
            AppearanceModel am = ((AppearanceController)Lookup.getDefault().lookup(AppearanceController.class)).getModel(workspace);
            if (AttributeUtils.isNodeColumn((Column)this.partition.getColumn())) {
                return new NodePartitionFilter(am, this.partition);
            }
            return new EdgePartitionFilter(am, this.partition);
        }

        public JPanel getPanel(Filter filter) {
            PartitionUI ui = (PartitionUI)Lookup.getDefault().lookup(PartitionUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionFilter)filter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }

    public static abstract class PartitionFilter
    implements Filter {
        protected static final Object NULL = new Object();
        protected Partition partition;
        protected final AppearanceModel appearanceModel;
        protected FilterProperty[] filterProperties;
        protected Set<Object> parts;
        protected Graph graph;
        protected boolean flattenList;

        public PartitionFilter(Partition partition) {
            this(null, partition);
        }

        public PartitionFilter(AppearanceModel appearanceModel, Partition partition) {
            this.partition = partition;
            this.appearanceModel = appearanceModel;
            this.parts = new HashSet<Object>();
        }

        public String getName() {
            return NbBundle.getMessage(PartitionBuilder.class, (String)"PartitionBuilder.name") + " (" + this.partition.getColumn().getTitle() + ")";
        }

        public boolean evaluate(Graph graph, Node node) {
            Object value = this.partition.getValue((Element)node, graph);
            if (value == null) {
                return this.parts.contains(NULL);
            }
            if (this.flattenList && this.partition.getColumn().isArray()) {
                return this.listContains(value);
            }
            return this.parts.contains(value);
        }

        private boolean listContains(Object value) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object val = Array.get(value, i);
                if (!this.parts.contains(val)) continue;
                return true;
            }
            return false;
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Object value = this.partition.getValue((Element)edge, graph);
            if (value == null) {
                return this.parts.contains(NULL);
            }
            if (this.flattenList && this.partition.getColumn().isArray()) {
                return this.listContains(value);
            }
            return this.parts.contains(value);
        }

        public void finish() {
        }

        public void addPart(Object value) {
            if (value == null) {
                if (this.parts.add(NULL)) {
                    this.getProperties()[1].setValue(this.parts);
                }
            } else if (this.parts.add(value)) {
                this.getProperties()[1].setValue(this.parts);
            }
        }

        public void removePart(Object value) {
            if (value == null) {
                if (this.parts.remove(NULL)) {
                    this.getProperties()[1].setValue(this.parts);
                }
            } else if (this.parts.remove(value)) {
                this.getProperties()[1].setValue(this.parts);
            }
        }

        public void unselectAll() {
            this.getProperties()[1].setValue(new HashSet());
        }

        public Set getFlattenParts() {
            HashSet allParts = new HashSet();
            this.partition.getValues(this.graph).stream().filter(Objects::nonNull).forEach(value -> {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    allParts.add(Array.get(value, i));
                }
            });
            return allParts;
        }

        public void selectAll() {
            if (this.flattenList && this.partition.getColumn().isArray()) {
                this.getProperties()[1].setValue((Object)this.getFlattenParts());
            } else {
                this.getProperties()[1].setValue(new HashSet(this.partition.getValues(this.graph)));
            }
        }

        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty((Filter)this, Column.class, (String)"column"), FilterProperty.createProperty((Filter)this, Set.class, (String)"parts"), FilterProperty.createProperty((Filter)this, Boolean.class, (String)"flattenList")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.filterProperties;
        }

        public boolean isFlattenList() {
            return this.flattenList;
        }

        public void setFlattenList(boolean flattenList) {
            this.flattenList = flattenList;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Set<Object> getParts() {
            return this.parts;
        }

        public Graph getGraph() {
            return this.graph;
        }

        public void setParts(Set<Object> parts) {
            this.parts = parts;
        }

        public Column getColumn() {
            return this.partition.getColumn();
        }

        public void setColumn(Column column) {
        }
    }

    public static class EdgePartitionFilter
    extends PartitionFilter
    implements EdgeFilter {
        public EdgePartitionFilter(AppearanceModel appearanceModel, Partition partition) {
            super(appearanceModel, partition);
        }

        public boolean init(Graph graph) {
            this.graph = graph.getModel().getGraph();
            return this.partition != null && this.partition.getColumn() != null;
        }

        @Override
        public void setColumn(Column column) {
            if (this.partition == null || this.partition.getColumn() != column) {
                this.appearanceModel.getEdgeFunctions();
                this.partition = this.appearanceModel.getEdgePartition(column);
            }
        }
    }

    public static class NodePartitionFilter
    extends PartitionFilter
    implements NodeFilter {
        public NodePartitionFilter(AppearanceModel appearanceModel, Partition partition) {
            super(appearanceModel, partition);
        }

        public boolean init(Graph graph) {
            this.graph = graph.getModel().getGraph();
            return this.partition != null && this.partition.getColumn() != null;
        }

        @Override
        public void setColumn(Column column) {
            if (this.partition == null || this.partition.getColumn() != column) {
                this.appearanceModel.getNodeFunctions();
                this.partition = this.appearanceModel.getNodePartition(column);
            }
        }
    }
}

