/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Partition;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.partition.IntraEdgesBuilder;
import org.gephi.filters.plugin.partition.PartitionBuilder;
import org.gephi.filters.plugin.partition.PartitionUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class InterEdgesBuilder
implements CategoryBuilder {
    public static final Category INTER_EDGES = new Category(NbBundle.getMessage(InterEdgesBuilder.class, (String)"InterEdgesBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return INTER_EDGES;
    }

    public FilterBuilder[] getBuilders(Workspace workspace) {
        ArrayList<InterEdgesFilterBuilder> builders = new ArrayList<InterEdgesFilterBuilder>();
        GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        AppearanceModel am = ((AppearanceController)Lookup.getDefault().lookup(AppearanceController.class)).getModel(workspace);
        am.getNodeFunctions();
        for (Column nodeCol : gm.getNodeTable()) {
            Partition partition;
            if (nodeCol.isProperty() || (partition = am.getNodePartition(nodeCol)) == null) continue;
            InterEdgesFilterBuilder builder = new InterEdgesFilterBuilder(partition);
            builders.add(builder);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    private static class InterEdgesFilterBuilder
    implements FilterBuilder {
        private final Partition partition;

        public InterEdgesFilterBuilder(Partition partition) {
            this.partition = partition;
        }

        public Category getCategory() {
            return INTER_EDGES;
        }

        public String getName() {
            return this.partition.getColumn().getTitle();
        }

        public Icon getIcon() {
            return null;
        }

        public String getDescription() {
            return NbBundle.getMessage(InterEdgesBuilder.class, (String)"InterEdgesBuilder.description");
        }

        public InterEdgesFilter getFilter(Workspace workspace) {
            return new InterEdgesFilter(this.partition);
        }

        public JPanel getPanel(Filter filter) {
            PartitionUI ui = (PartitionUI)Lookup.getDefault().lookup(PartitionUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionBuilder.PartitionFilter)filter);
            }
            return null;
        }

        public void destroy(Filter filter) {
        }
    }

    public static class InterEdgesFilter
    extends PartitionBuilder.PartitionFilter
    implements EdgeFilter {
        public InterEdgesFilter(Partition partition) {
            super(partition);
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(IntraEdgesBuilder.class, (String)"InterEdgesBuilder.name") + " (" + this.partition.getColumn().getTitle() + ")";
        }

        public boolean init(Graph graph) {
            this.graph = graph.getModel().getGraph();
            return this.partition != null && this.partition.getColumn() != null;
        }

        @Override
        public boolean evaluate(Graph graph, Edge edge) {
            Object srcValue = this.partition.getValue((Element)edge.getSource(), graph);
            Object destValue = this.partition.getValue((Element)edge.getTarget(), graph);
            srcValue = srcValue == null ? NULL : srcValue;
            destValue = destValue == null ? NULL : destValue;
            return this.parts.contains(srcValue) && this.parts.contains(destValue) && srcValue.equals(destValue);
        }

        @Override
        public void finish() {
        }
    }
}

