/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.attribute;

import java.util.ArrayList;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.AbstractAttributeFilter;
import org.gephi.filters.plugin.AbstractAttributeFilterBuilder;
import org.gephi.filters.plugin.attribute.AttributeEqualBuilder;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AttributeNonNullBuilder
implements CategoryBuilder {
    private static final Category NONNULL = new Category(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeNonNullBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return NONNULL;
    }

    public FilterBuilder[] getBuilders(Workspace workspace) {
        AttributeNonNullFilterBuilder b;
        ArrayList<AttributeNonNullFilterBuilder> builders = new ArrayList<AttributeNonNullFilterBuilder>();
        GraphModel am = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        for (Column col : am.getNodeTable()) {
            if (col.isProperty()) continue;
            b = new AttributeNonNullFilterBuilder(col);
            builders.add(b);
        }
        for (Column col : am.getEdgeTable()) {
            if (col.isProperty()) continue;
            b = new AttributeNonNullFilterBuilder(col);
            builders.add(b);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    private static class AttributeNonNullFilterBuilder
    extends AbstractAttributeFilterBuilder {
        public AttributeNonNullFilterBuilder(Column column) {
            super(column, NONNULL, NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeNonNullBuilder.description"), null);
        }

        public AttributeNonNullFilter getFilter(Workspace workspace) {
            return AttributeUtils.isNodeColumn((Column)this.column) ? new AttributeNonNullFilter.Node(this.column) : new AttributeNonNullFilter.Edge(this.column);
        }

        public JPanel getPanel(Filter filter) {
            return null;
        }
    }

    public static abstract class AttributeNonNullFilter<K extends Element>
    extends AbstractAttributeFilter<K> {
        public AttributeNonNullFilter(Column column) {
            super(NbBundle.getMessage(AttributeEqualBuilder.class, (String)"AttributeNonNullBuilder.name"), column);
        }

        public boolean init(Graph graph) {
            if (AttributeUtils.isNodeColumn((Column)this.column)) {
                return graph.getNodeCount() != 0;
            }
            if (AttributeUtils.isEdgeColumn((Column)this.column)) {
                return graph.getEdgeCount() != 0;
            }
            return true;
        }

        public boolean evaluate(Graph graph, Element element) {
            return element.getAttribute(this.column) != null;
        }

        public void finish() {
        }

        public static class Edge
        extends AttributeNonNullFilter<org.gephi.graph.api.Edge>
        implements EdgeFilter {
            public Edge(Column column) {
                super(column);
            }
        }

        public static class Node
        extends AttributeNonNullFilter<org.gephi.graph.api.Node>
        implements NodeFilter {
            public Node(Column column) {
                super(column);
            }
        }
    }
}

