/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.util.structure;

import java.util.Arrays;
import java.util.BitSet;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Rect2D;
import org.gephi.viz.engine.spi.ElementsCallback;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.status.GraphSelectionImpl;
import org.gephi.viz.engine.structure.GraphIndex;
import org.gephi.viz.engine.util.ArrayUtils;
import org.gephi.viz.engine.util.text.TextLabelBuilder;

public class NodesCallback
implements ElementsCallback<Node> {
    private Node[] nodesArray = new Node[0];
    private GraphView graphView;
    private Column[] nodeLabelColumns;
    private String[] nodesLabelsArray = new String[0];
    private BitSet selectedBitSet = new BitSet();
    private BitSet selectedWithNeighborsBitSet = new BitSet();
    private boolean hasSelection = false;
    private int maxIndex = 0;
    private float maxNodeSize = 0.0f;
    private int nodeCount = 0;
    private boolean hasLabels = false;
    private boolean hideNonSelectedLabels = false;
    private float minX = Float.POSITIVE_INFINITY;
    private float minY = Float.POSITIVE_INFINITY;
    private float maxX = Float.NEGATIVE_INFINITY;
    private float maxY = Float.NEGATIVE_INFINITY;

    @Override
    public void run(GraphIndex graphIndex, GraphRenderingOptions renderingOptions, Rect2D viewBoundaries) {
        if (!renderingOptions.isShowNodes()) {
            return;
        }
        graphIndex.getVisibleNodes(this, renderingOptions, viewBoundaries);
    }

    @Override
    public void start(Graph graph, GraphRenderingOptions graphRenderingOptions, GraphSelection graphSelection) {
        Arrays.fill(this.nodesArray, null);
        this.nodesArray = this.ensureNodesArraySize(this.nodesArray, graph.getModel().getMaxNodeStoreId() + 1);
        this.maxIndex = 0;
        this.maxNodeSize = 0.0f;
        this.nodeCount = 0;
        this.minX = Float.POSITIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this.hasSelection = graphSelection.someNodesOrEdgesSelection();
        if (this.hasSelection) {
            this.selectedBitSet.clear();
            this.selectedBitSet.or(((GraphSelectionImpl)graphSelection).getNodes());
            this.selectedWithNeighborsBitSet.clear();
            this.selectedWithNeighborsBitSet.or(((GraphSelectionImpl)graphSelection).getNodesWithNeighbours());
        }
        this.hideNonSelectedLabels = graphRenderingOptions.isHideNonSelectedNodeLabels();
        boolean bl = this.hasLabels = graphRenderingOptions.isShowNodeLabels() && (!this.hideNonSelectedLabels || this.hasSelection);
        if (this.hasLabels) {
            this.nodesLabelsArray = this.ensureNodesLabelsArraySize(this.nodesLabelsArray, graph.getModel().getMaxNodeStoreId() + 1);
            this.graphView = graph.getView();
            this.nodeLabelColumns = graphRenderingOptions.getNodeLabelColumns();
        }
    }

    @Override
    public void accept(Node node) {
        float size;
        int storeId = node.getStoreId();
        if (storeId > this.maxIndex) {
            this.maxIndex = storeId;
        }
        if ((size = node.size()) > this.maxNodeSize) {
            this.maxNodeSize = size;
        }
        this.nodesArray[storeId] = node;
        if (this.hasLabels && node.getTextProperties().isVisible() && (!this.hideNonSelectedLabels || this.isSelected(storeId))) {
            this.nodesLabelsArray[storeId] = TextLabelBuilder.buildText((Element)node, this.graphView, this.nodeLabelColumns);
        } else if (this.hasLabels) {
            this.nodesLabelsArray[storeId] = null;
        }
    }

    @Override
    public void end(Graph graph) {
        this.nodeCount = 0;
        for (int i = 0; i <= this.maxIndex; ++i) {
            Node node = this.nodesArray[i];
            if (node == null) continue;
            ++this.nodeCount;
            float x = node.x();
            float y = node.y();
            if (x < this.minX) {
                this.minX = x;
            }
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y < this.minY) {
                this.minY = y;
            }
            if (!(y > this.maxY)) continue;
            this.maxY = y;
        }
    }

    @Override
    public void reset() {
        this.nodesArray = new Node[0];
        this.maxIndex = 0;
        this.maxNodeSize = 0.0f;
        this.nodeCount = 0;
        this.selectedBitSet = new BitSet();
        this.selectedWithNeighborsBitSet = new BitSet();
        this.hasSelection = false;
        this.nodeLabelColumns = null;
        this.nodesLabelsArray = new String[0];
        this.hasLabels = false;
        this.hideNonSelectedLabels = false;
        this.minX = Float.POSITIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
    }

    public Node[] getNodesArray() {
        return this.nodesArray;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public float getMaxNodeSize() {
        return this.maxNodeSize;
    }

    public int getCount() {
        return this.nodeCount;
    }

    public boolean isSelected(int nodeStoreId) {
        return this.isSelected(nodeStoreId, false);
    }

    public boolean isSelected(int nodeStoreId, boolean withNeighbours) {
        return this.hasSelection && withNeighbours ? this.selectedWithNeighborsBitSet.get(nodeStoreId) : this.selectedBitSet.get(nodeStoreId);
    }

    public boolean hasSelection() {
        return this.hasSelection;
    }

    public String[] getNodesLabelsArray() {
        return this.nodesLabelsArray;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    protected Node[] ensureNodesArraySize(Node[] array, int size) {
        if (size > array.length) {
            int newSize = ArrayUtils.getNextPowerOf2(size);
            Node[] newVector = new Node[newSize];
            System.arraycopy(array, 0, newVector, 0, array.length);
            return newVector;
        }
        return array;
    }

    protected String[] ensureNodesLabelsArraySize(String[] array, int size) {
        if (size > array.length) {
            int newSize = ArrayUtils.getNextPowerOf2(size);
            String[] newVector = new String[newSize];
            System.arraycopy(array, 0, newVector, 0, array.length);
            return newVector;
        }
        return array;
    }
}

