/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.util.structure;

import java.util.Arrays;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnIndex;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Rect2D;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.spi.ElementsCallback;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.status.GraphSelectionImpl;
import org.gephi.viz.engine.structure.GraphIndex;
import org.gephi.viz.engine.util.ArrayUtils;
import org.gephi.viz.engine.util.text.TextLabelBuilder;

public class EdgesCallback
implements ElementsCallback<Edge> {
    private int edgeWeightVersion = -1;
    private float minWeight = 0.0f;
    private float maxWeight = 1.0f;
    private Edge[] edgesArray = new Edge[0];
    private float[] edgeWeightsArray = new float[0];
    private GraphView graphView;
    private Column[] edgeLabelColumns;
    private String[] edgeLabelsArray = new String[0];
    private boolean hasSelection = false;
    private BitSet selectedBitSet = new BitSet();
    private boolean hasLabels = false;
    private boolean hideNonSelectedLabels = false;
    private int maxIndex = 0;
    private int edgeCount = 0;
    private boolean directed = false;
    private boolean undirected = false;
    private boolean hasSelfLoop = false;

    @Override
    public void run(GraphIndex graphIndex, GraphRenderingOptions renderingOptions, Rect2D viewBoundaries) {
        if (!renderingOptions.isShowEdges()) {
            return;
        }
        graphIndex.getVisibleEdges(this, renderingOptions, viewBoundaries);
    }

    @Override
    public void start(Graph graph, GraphRenderingOptions graphRenderingOptions, GraphSelection graphSelection) {
        this.directed = graph.isDirected();
        this.undirected = graph.isUndirected();
        Arrays.fill(this.edgesArray, null);
        this.edgesArray = this.ensureEdgesArraySize(this.edgesArray, graph.getModel().getMaxEdgeStoreId() + 1);
        this.edgeWeightsArray = this.ensureEdgeWeightArraySize(this.edgeWeightsArray, graph.getModel().getMaxEdgeStoreId() + 1);
        this.maxIndex = 0;
        this.edgeCount = 0;
        this.hasSelfLoop = false;
        this.hasSelection = graphSelection.someNodesOrEdgesSelection();
        if (this.hasSelection) {
            BitSet sourceBitSet = ((GraphSelectionImpl)graphSelection).getEdges();
            this.selectedBitSet.clear();
            this.selectedBitSet.or(sourceBitSet);
        }
        this.hideNonSelectedLabels = graphRenderingOptions.isHideNonSelectedEdgeLabels();
        boolean bl = this.hasLabels = graphRenderingOptions.isShowEdgeLabels() && (!this.hideNonSelectedLabels || this.hasSelection);
        if (this.hasLabels) {
            this.edgeLabelsArray = this.ensureEdgesLabelsArraySize(this.edgeLabelsArray, graph.getModel().getMaxEdgeStoreId() + 1);
            this.graphView = graph.getView();
            this.edgeLabelColumns = graphRenderingOptions.getEdgeLabelColumns();
        }
    }

    @Override
    public void accept(Edge edge) {
        int storeId = edge.getStoreId();
        if (storeId > this.maxIndex) {
            this.maxIndex = storeId;
        }
        this.edgesArray[storeId] = edge;
        if (!this.hasSelfLoop && edge.isSelfLoop()) {
            this.hasSelfLoop = true;
        }
        if (this.hasLabels && edge.getTextProperties().isVisible() && (!this.hideNonSelectedLabels || this.isSelected(storeId))) {
            this.edgeLabelsArray[storeId] = TextLabelBuilder.buildText((Element)edge, this.graphView, this.edgeLabelColumns);
        } else if (this.hasLabels) {
            this.edgeLabelsArray[storeId] = null;
        }
    }

    @Override
    public void end(Graph graph) {
        Column weightCol = graph.getModel().getEdgeTable().getColumn(3);
        ColumnIndex edgeWeightIndex = graph.getModel().getEdgeIndex().getColumnIndex(weightCol);
        if (edgeWeightIndex.getVersion() != this.edgeWeightVersion) {
            this.edgeWeightVersion = edgeWeightIndex.getVersion();
            Number minValue = edgeWeightIndex.getMinValue();
            Number maxValue = edgeWeightIndex.getMaxValue();
            this.minWeight = minValue != null ? minValue.floatValue() : 0.0f;
            this.maxWeight = maxValue != null ? maxValue.floatValue() : 1.0f;
        }
        for (int i = 0; i <= this.maxIndex; ++i) {
            Edge edge = this.edgesArray[i];
            if (edge == null) continue;
            ++this.edgeCount;
            double weight = edge.getWeight(graph.getView());
            this.edgeWeightsArray[i] = (float)weight;
        }
    }

    @Override
    public void reset() {
        this.edgesArray = new Edge[0];
        this.edgeWeightsArray = new float[0];
        this.maxIndex = 0;
        this.edgeCount = 0;
        this.directed = false;
        this.undirected = false;
        this.hasSelfLoop = false;
        this.hasSelection = false;
        this.hideNonSelectedLabels = false;
        this.selectedBitSet = new BitSet();
        this.edgeLabelColumns = null;
        this.edgeLabelsArray = new String[0];
        this.hasLabels = false;
    }

    public Edge[] getEdgesArray() {
        return this.edgesArray;
    }

    public float[] getEdgeWeightsArray() {
        return this.edgeWeightsArray;
    }

    public String[] getEdgeLabelsArray() {
        return this.edgeLabelsArray;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getCount() {
        return this.edgeCount;
    }

    public float getMinWeight() {
        return this.minWeight;
    }

    public float getMaxWeight() {
        return this.maxWeight;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isUndirected() {
        return this.undirected;
    }

    public boolean hasSelfLoop() {
        return this.hasSelfLoop;
    }

    public boolean isSelected(int edgeStoreId) {
        return this.hasSelection && this.selectedBitSet.get(edgeStoreId);
    }

    public boolean hasSelection() {
        return this.hasSelection;
    }

    protected Edge[] ensureEdgesArraySize(Edge[] array, int size) {
        if (size > array.length) {
            int newSize = ArrayUtils.getNextPowerOf2(size);
            Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "Growing edge vector from " + array.length + " to " + newSize + " elements");
            Edge[] newVector = new Edge[newSize];
            System.arraycopy(array, 0, newVector, 0, array.length);
            return newVector;
        }
        return array;
    }

    protected float[] ensureEdgeWeightArraySize(float[] array, int size) {
        if (size > array.length) {
            int newSize = ArrayUtils.getNextPowerOf2(size);
            float[] newVector = new float[newSize];
            System.arraycopy(array, 0, newVector, 0, array.length);
            return newVector;
        }
        return array;
    }

    protected String[] ensureEdgesLabelsArraySize(String[] array, int size) {
        if (size > array.length) {
            int newSize = ArrayUtils.getNextPowerOf2(size);
            String[] newVector = new String[newSize];
            System.arraycopy(array, 0, newVector, 0, array.length);
            return newVector;
        }
        return array;
    }
}

