/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.util.actions;

import org.gephi.graph.api.Graph;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Rect2D;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.status.GraphRenderingOptionsImpl;
import org.gephi.viz.engine.status.GraphSelectionImpl;
import org.joml.Vector2f;

public class InputActionsProcessor {
    private final VizEngine<?, ?> engine;

    public InputActionsProcessor(VizEngine<?, ?> engine) {
        this.engine = engine;
    }

    public void selectNodesWithinRadius(VizEngineModel model, float x, float y, float radius) {
        NodeIterable iterable = model.getGraphIndex().getNodesInsideCircle(x, y, radius);
        this.selectNodes(model, iterable);
    }

    public void selectNodesAndEdgesOnRectangle(VizEngineModel model, Rect2D rectangle) {
        NodeIterable iterable = model.getGraphIndex().getNodesInsideRectangle(rectangle);
        this.selectNodes(model, iterable);
    }

    public void selectNodesAndEdgesUnderPosition(VizEngineModel model, Vector2f worldCoords) {
        NodeIterable iterable = model.getGraphIndex().getNodesUnderPosition(worldCoords.x, worldCoords.y);
        this.selectNodes(model, iterable);
    }

    public void clearSelection(VizEngineModel model) {
        model.getGraphSelection().clearSelectedNodes();
        model.getGraphSelection().clearSelectedEdges();
    }

    private void selectNodes(VizEngineModel model, NodeIterable nodesIterable) {
        GraphRenderingOptionsImpl renderingOptions = model.getRenderingOptions();
        Graph graph = model.getGraphModel().getGraphVisible();
        GraphSelectionImpl selection = model.getGraphSelection();
        selection.setSelectedNodes(graph, nodesIterable, renderingOptions.isAutoSelectNeighbours(), renderingOptions.isShowEdges());
    }

    public void processCameraMoveEvent(int xDiff, int yDiff) {
        float zoom = this.engine.getZoom();
        this.engine.translate((float)xDiff / zoom, (float)(-yDiff) / zoom);
    }

    public void processZoomEvent(double zoomQuantity, int x, int y) {
        float currentZoom;
        float newZoom = currentZoom = this.engine.getZoom();
        if ((newZoom *= (float)Math.pow(1.1, zoomQuantity)) < 0.001f) {
            newZoom = 0.001f;
        }
        if (newZoom > 1000.0f) {
            newZoom = 1000.0f;
        }
        Rect2D viewRect = this.engine.getViewBoundaries();
        Vector2f center = new Vector2f((viewRect.maxX + viewRect.minX) / 2.0f, (viewRect.maxY + viewRect.minY) / 2.0f);
        Vector2f diff = this.engine.screenCoordinatesToWorldCoordinates(x, y).sub(center);
        Vector2f directionalZoomTranslation = new Vector2f(diff).mul(currentZoom / newZoom).sub(diff);
        this.engine.translate(directionalZoomTranslation);
        this.engine.setZoom(newZoom);
    }

    public void processCenterOnGraphEvent() {
        this.engine.centerOnGraph();
    }
}

