/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.viz.engine.VizEngine;

public class ArrayUtils {
    public static int repeat(Object arr, int offset, int elementsCount, int times) {
        int newLength = times * elementsCount;
        for (long last = (long)elementsCount; last != 0L && last < (long)newLength; last <<= 1) {
            System.arraycopy(arr, offset, arr, offset + (int)last, (int)(Math.min(last << 1, (long)newLength) - last));
        }
        return offset + elementsCount * times;
    }

    public static float[] ensureCapacity(float[] buffer, int elements) {
        int capacity = buffer.length;
        if (capacity < elements) {
            int newElementsCapacity = ArrayUtils.getNextPowerOf2(elements);
            Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "Growing float buffer from " + capacity + " to " + newElementsCapacity + " elements");
            float[] newBuffer = new float[newElementsCapacity];
            System.arraycopy(buffer, 0, newBuffer, 0, capacity);
            return newBuffer;
        }
        return buffer;
    }

    public static float[] ensureCapacityNoCopy(float[] buffer, int elements) {
        int capacity = buffer.length;
        if (capacity < elements) {
            int newElementsCapacity = ArrayUtils.getNextPowerOf2(elements);
            Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "Growing float buffer from " + capacity + " to " + newElementsCapacity + " elements");
            return new float[newElementsCapacity];
        }
        return buffer;
    }

    public static int getNextPowerOf2(int number) {
        if ((number - 1 & number) == 0) {
            return number;
        }
        int power = 0;
        while (number > 0) {
            number >>= 1;
            ++power;
        }
        return 1 << power;
    }

    public static long getNextPowerOf2(long number) {
        if ((number - 1L & number) == 0L) {
            return number;
        }
        int power = 0;
        while (number > 0L) {
            number >>= 1;
            ++power;
        }
        return 1L << power;
    }
}

