/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.structure;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Rect2D;
import org.gephi.graph.api.SpatialIndex;
import org.gephi.viz.engine.spi.ElementsCallback;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphSelectionImpl;
import org.gephi.viz.engine.structure.GraphIndex;
import org.joml.Intersectionf;

public class GraphIndexImpl
implements GraphIndex {
    private final GraphModel graphModel;
    private final GraphSelectionImpl graphSelection;

    public GraphIndexImpl(GraphModel graphModel, GraphSelectionImpl graphSelection) {
        this.graphModel = graphModel;
        this.graphSelection = graphSelection;
    }

    @Override
    public Graph getVisibleGraph() {
        return this.graphModel.getGraphVisible();
    }

    @Override
    public int getNodeCount() {
        return this.getVisibleGraph().getNodeCount();
    }

    @Override
    public int getEdgeCount() {
        return this.getVisibleGraph().getEdgeCount();
    }

    @Override
    public void getVisibleNodes(ElementsCallback<Node> callback, GraphRenderingOptions graphRenderingOptions, Rect2D viewBoundaries) {
        this.graphModel.getGraph().readLock();
        Graph visibleGraph = this.getVisibleGraph();
        callback.start(visibleGraph, graphRenderingOptions, this.graphSelection);
        SpatialIndex spatialIndex = visibleGraph.getSpatialIndex();
        spatialIndex.spatialIndexReadLock();
        spatialIndex.getApproximateNodesInArea(viewBoundaries).parallelStream().forEach(callback);
        spatialIndex.spatialIndexReadUnlock();
        callback.end(visibleGraph);
        this.graphModel.getGraph().readUnlock();
    }

    @Override
    public void getVisibleEdges(ElementsCallback<Edge> callback, GraphRenderingOptions graphRenderingOptions, Rect2D viewBoundaries) {
        this.graphModel.getGraph().readLock();
        Graph visibleGraph = this.getVisibleGraph();
        callback.start(visibleGraph, graphRenderingOptions, this.graphSelection);
        SpatialIndex spatialIndex = visibleGraph.getSpatialIndex();
        spatialIndex.spatialIndexReadLock();
        spatialIndex.getApproximateEdgesInArea(viewBoundaries).parallelStream().forEach(callback);
        spatialIndex.spatialIndexReadUnlock();
        callback.end(visibleGraph);
        this.graphModel.getGraph().readUnlock();
    }

    @Override
    public NodeIterable getNodesUnderPosition(float x, float y) {
        return this.getVisibleGraph().getSpatialIndex().getNodesInArea(this.getCircleRect2D(x, y, 0.0f), node -> {
            float size = node.size();
            return Intersectionf.testPointCircle(x, y, node.x(), node.y(), size * size);
        });
    }

    @Override
    public NodeIterable getNodesInsideCircle(float centerX, float centerY, float radius) {
        return this.getVisibleGraph().getSpatialIndex().getNodesInArea(this.getCircleRect2D(centerX, centerY, radius), node -> Intersectionf.testCircleCircle(centerX, centerY, radius, node.x(), node.y(), node.size()));
    }

    @Override
    public NodeIterable getNodesInsideRectangle(Rect2D rect) {
        return this.getVisibleGraph().getSpatialIndex().getNodesInArea(rect, node -> {
            float size = node.size();
            return Intersectionf.testAarCircle(rect.minX, rect.minY, rect.maxX, rect.maxY, node.x(), node.y(), size * size);
        });
    }

    @Override
    public EdgeIterable getEdgesInsideRectangle(Rect2D rect) {
        return this.getVisibleGraph().getSpatialIndex().getEdgesInArea(rect, edge -> {
            Node source = edge.getSource();
            Node target = edge.getTarget();
            return Intersectionf.testAarLine(rect.minX, rect.minY, rect.maxX, rect.maxY, source.x(), source.y(), target.x(), target.y());
        });
    }

    @Override
    public EdgeIterable getEdgesInsideCircle(float centerX, float centerY, float radius) {
        return this.getVisibleGraph().getSpatialIndex().getEdgesInArea(this.getCircleRect2D(centerX, centerY, radius), edge -> {
            Node source = edge.getSource();
            Node target = edge.getTarget();
            float x0 = source.x();
            float y0 = source.y();
            float x1 = target.x();
            float y1 = target.y();
            return Intersectionf.testLineCircle(y0 - y1, x1 - x0, (x0 - x1) * y0 + (y1 - y0) * x0, centerX, centerY, radius);
        });
    }

    @Override
    public Rect2D getGraphBoundaries() {
        return this.getVisibleGraph().getSpatialIndex().getBoundaries();
    }

    private Rect2D getCircleRect2D(float x, float y, float radius) {
        return new Rect2D(x - radius, y - radius, x + radius, y + radius);
    }
}

