/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.status;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.viz.engine.status.GraphSelection;
import org.joml.Vector2f;

public class GraphSelectionImpl
implements GraphSelection {
    private final BitSet nodes = new BitSet();
    private final BitSet nodesWithNeighbours = new BitSet();
    private final BitSet edges = new BitSet();
    private final Collection<Node> nodesList = new ConcurrentLinkedQueue<Node>();
    private GraphSelection.GraphSelectionMode selectionMode;
    private float simpleMouseSelectionDiameter = 1.0f;
    private float simpleMouseSelectionMVPScale = 1.0f;
    private boolean mouseSelectionDiameterZoomProportional = false;
    private Vector2f rectangleSelectionInitialPosition;
    private Vector2f rectangleSelectionCurrentPosition;
    private Vector2f mousePosition;

    public GraphSelectionImpl() {
        this.selectionMode = GraphSelection.GraphSelectionMode.SIMPLE_MOUSE_SELECTION;
        this.nodes.clear();
    }

    public GraphSelectionImpl(GraphSelection other) {
        if (other != null) {
            this.selectionMode = other.getMode();
            this.simpleMouseSelectionDiameter = other.getMouseSelectionDiameter();
            this.simpleMouseSelectionMVPScale = other.getSimpleMouseSelectionMVPScale();
            this.mouseSelectionDiameterZoomProportional = other.getMouseSelectionDiameterZoomProportional();
        }
    }

    public BitSet getNodesWithNeighbours() {
        return this.nodesWithNeighbours;
    }

    public BitSet getNodes() {
        return this.nodes;
    }

    public BitSet getEdges() {
        return this.edges;
    }

    @Override
    public void setMouseSelectionDiameter(float diameter) {
        this.simpleMouseSelectionDiameter = diameter >= 1.0f ? diameter : 1.0f;
    }

    @Override
    public float getMouseSelectionDiameter() {
        return this.simpleMouseSelectionDiameter;
    }

    @Override
    public void setSimpleMouseSelectionMVPScale(float scale) {
        this.simpleMouseSelectionMVPScale = scale;
    }

    @Override
    public float getSimpleMouseSelectionMVPScale() {
        return this.simpleMouseSelectionMVPScale;
    }

    @Override
    public void setMouseSelectionDiameterZoomProportional(boolean isZoomProportional) {
        this.mouseSelectionDiameterZoomProportional = isZoomProportional;
    }

    @Override
    public float getMouseSelectionEffectiveDiameter() {
        if (this.mouseSelectionDiameterZoomProportional) {
            return this.simpleMouseSelectionDiameter;
        }
        return (float)((double)(this.simpleMouseSelectionDiameter / this.simpleMouseSelectionMVPScale) * 0.001);
    }

    @Override
    public boolean getMouseSelectionDiameterZoomProportional() {
        return this.mouseSelectionDiameterZoomProportional;
    }

    @Override
    public boolean someNodesOrEdgesSelection() {
        return !this.nodes.isEmpty() || !this.edges.isEmpty();
    }

    @Override
    public boolean isNodeSelected(Node node) {
        return this.nodes.get(node.getStoreId());
    }

    @Override
    public boolean isNodeOrNeighbourSelected(Node node) {
        return this.nodesWithNeighbours.get(node.getStoreId());
    }

    @Override
    public Collection<Node> getSelectedNodes() {
        return Collections.unmodifiableCollection(this.nodesList);
    }

    @Override
    public void setSelectedNodes(Graph graph, NodeIterable nodesIterable, boolean autoSelectNeighbours, boolean selectEdges) {
        this.nodes.clear();
        this.nodesWithNeighbours.clear();
        this.edges.clear();
        this.nodesList.clear();
        boolean selectNeighbours = autoSelectNeighbours && this.getMode() != GraphSelection.GraphSelectionMode.SINGLE_NODE_SELECTION;
        graph.readLock();
        graph.getSpatialIndex().spatialIndexReadLock();
        nodesIterable.parallelStream().forEach(node -> {
            int storeId = node.getStoreId();
            this.nodes.set(storeId);
            this.nodesList.add((Node)node);
            this.nodesWithNeighbours.set(storeId);
            if (selectEdges || selectNeighbours) {
                EdgeIterable edgeIterable = graph.getEdges(node);
                for (Edge edge : edgeIterable) {
                    Node oppositeNode;
                    this.edges.set(edge.getStoreId());
                    if (!selectNeighbours || (oppositeNode = graph.getOpposite(node, edge)) == null || oppositeNode == node) continue;
                    this.nodesWithNeighbours.set(oppositeNode.getStoreId());
                }
            }
        });
        graph.getSpatialIndex().spatialIndexReadUnlock();
        graph.readUnlock();
    }

    @Override
    public void setSelectedNodes(Node[] nodes) {
        this.nodes.clear();
        this.nodesWithNeighbours.clear();
        if (nodes != null) {
            for (Node node : nodes) {
                this.nodes.set(node.getStoreId());
                this.nodesWithNeighbours.set(node.getStoreId());
            }
        }
    }

    @Override
    public void clearSelectedNodes() {
        this.nodes.clear();
        this.nodesWithNeighbours.clear();
    }

    @Override
    public boolean isEdgeSelected(Edge edge) {
        return this.edges.get(edge.getStoreId());
    }

    @Override
    public void setSelectedEdges(Edge[] edges) {
        this.edges.clear();
        if (edges != null) {
            for (Edge edge : edges) {
                this.edges.set(edge.getStoreId());
            }
        }
    }

    @Override
    public void clearSelectedEdges() {
        this.edges.clear();
    }

    @Override
    public void clearSelection() {
        this.clearSelectedEdges();
        this.clearSelectedNodes();
    }

    @Override
    public GraphSelection.GraphSelectionMode getMode() {
        return this.selectionMode;
    }

    @Override
    public void setMode(GraphSelection.GraphSelectionMode mode) {
        if (mode != null) {
            this.selectionMode = mode;
            this.clearSelection();
        }
    }

    @Override
    public void startRectangleSelection(Vector2f initialPosition) {
        this.rectangleSelectionInitialPosition = initialPosition;
        this.rectangleSelectionCurrentPosition = initialPosition;
    }

    @Override
    public void stopRectangleSelection(Vector2f endPosition) {
        this.rectangleSelectionInitialPosition = null;
        this.rectangleSelectionCurrentPosition = null;
    }

    @Override
    public void updateRectangleSelection(Vector2f updatedPosition) {
        this.rectangleSelectionCurrentPosition = updatedPosition;
    }

    @Override
    public Vector2f getRectangleInitialPosition() {
        return this.rectangleSelectionInitialPosition;
    }

    @Override
    public Vector2f getRectangleCurrentPosition() {
        return this.rectangleSelectionCurrentPosition;
    }

    @Override
    public void updateMousePosition(Vector2f mousePosition) {
        this.mousePosition = mousePosition;
    }

    @Override
    public Vector2f getMousePosition() {
        return this.mousePosition;
    }
}

