/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.status;

import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import org.gephi.graph.api.Column;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.util.ColorUtils;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class GraphRenderingOptionsImpl
implements GraphRenderingOptions {
    private boolean showNodes = true;
    private boolean showEdges = true;
    private boolean showNodeLabels = false;
    private boolean showEdgeLabels = false;
    private float[] backgroundColor = DEFAULT_BACKGROUND_COLOR;
    private float zoom = 0.3f;
    private final Vector2f pan = new Vector2f(0.0f, 0.0f);
    private float edgeScale = 2.0f;
    private boolean edgeSelectionColor = false;
    private Color edgeBothSelectionColor = DEFAULT_EDGE_BOTH_SELECTION_COLOR;
    private Color edgeInSelectionColor = DEFAULT_EDGE_IN_SELECTION_COLOR;
    private Color edgeOutSelectionColor = DEFAULT_EDGE_OUT_SELECTION_COLOR;
    private GraphRenderingOptions.EdgeColorMode edgeColorMode = DEFAULT_EDGE_COLOR_MODE;
    private boolean edgeWeightEnabled = true;
    private boolean edgeRescaleWeightEnabled = true;
    private float edgeRescaleMin = 0.4f;
    private float edgeRescaleMax = 8.0f;
    private float nodeScale = 1.0f;
    private boolean nodeLabelFitToNodeSize = false;
    private float nodeLabelScale = 1.0f;
    private GraphRenderingOptions.LabelColorMode nodeLabelColorMode = DEFAULT_NODE_LABEL_COLOR_MODE;
    private GraphRenderingOptions.LabelSizeMode nodeLabelSizeMode = DEFAULT_NODE_LABEL_SIZE_MODE;
    private Font nodeLabelFont = DEFAULT_NODE_LABEL_FONT;
    private boolean hideNonSelectedNodeLabels = false;
    private float nodeLabelFitToNodeSizeFactor = 0.05f;
    private boolean avoidNodeLabelOverlap = false;
    private Column[] nodeLabelColumns = new Column[0];
    private GraphRenderingOptions.LabelColorMode edgeLabelColorMode = DEFAULT_NODE_LABEL_COLOR_MODE;
    private GraphRenderingOptions.LabelSizeMode edgeLabelSizeMode = DEFAULT_NODE_LABEL_SIZE_MODE;
    private Font edgeLabelFont = DEFAULT_NODE_LABEL_FONT;
    private float edgeLabelScale = 1.0f;
    private boolean hideNonSelectedEdgeLabels = false;
    private Column[] edgeLabelColumns = new Column[0];
    private boolean autoSelectNeighbours = true;
    private boolean hideNonSelectedEdges = false;
    private boolean lightenNonSelected = true;
    private float lightenNonSelectedFactor = 0.9f;

    public GraphRenderingOptionsImpl() {
        this(false);
    }

    public GraphRenderingOptionsImpl(boolean darkLaf) {
        if (darkLaf) {
            this.backgroundColor = DEFAULT_DARK_BACKGROUND_COLOR;
        }
    }

    public GraphRenderingOptionsImpl(GraphRenderingOptions other) {
        Objects.requireNonNull(other, "other");
        this.showNodes = other.isShowNodes();
        this.showEdges = other.isShowEdges();
        this.showNodeLabels = other.isShowNodeLabels();
        this.showEdgeLabels = other.isShowEdgeLabels();
        float[] otherBg = other.getBackgroundColor();
        this.backgroundColor = (float[])otherBg.clone();
        this.zoom = other.getZoom();
        this.pan.set(other.getPan());
        this.edgeScale = other.getEdgeScale();
        this.edgeSelectionColor = other.isEdgeSelectionColor();
        this.edgeBothSelectionColor = other.getEdgeBothSelectionColor();
        this.edgeInSelectionColor = other.getEdgeInSelectionColor();
        this.edgeOutSelectionColor = other.getEdgeOutSelectionColor();
        this.edgeColorMode = other.getEdgeColorMode();
        this.edgeWeightEnabled = other.isEdgeWeightEnabled();
        this.edgeRescaleWeightEnabled = other.isEdgeRescaleWeightEnabled();
        this.edgeRescaleMin = other.getEdgeRescaleMin();
        this.edgeRescaleMax = other.getEdgeRescaleMax();
        this.nodeScale = other.getNodeScale();
        this.nodeLabelFitToNodeSize = other.isNodeLabelFitToNodeSize();
        this.nodeLabelScale = other.getNodeLabelScale();
        this.nodeLabelColorMode = other.getNodeLabelColorMode();
        this.nodeLabelSizeMode = other.getNodeLabelSizeMode();
        this.nodeLabelFont = other.getNodeLabelFont();
        this.hideNonSelectedNodeLabels = other.isHideNonSelectedNodeLabels();
        this.nodeLabelFitToNodeSizeFactor = other.getNodeLabelFitToNodeSizeFactor();
        this.nodeLabelColumns = other.getNodeLabelColumns();
        this.avoidNodeLabelOverlap = other.isAvoidNodeLabelOverlap();
        this.edgeLabelColorMode = other.getEdgeLabelColorMode();
        this.edgeLabelSizeMode = other.getEdgeLabelSizeMode();
        this.edgeLabelFont = other.getEdgeLabelFont();
        this.edgeLabelScale = other.getEdgeLabelScale();
        this.hideNonSelectedEdgeLabels = other.isHideNonSelectedEdgeLabels();
        this.edgeLabelColumns = other.getEdgeLabelColumns();
        this.autoSelectNeighbours = other.isAutoSelectNeighbours();
        this.hideNonSelectedEdges = other.isHideNonSelectedEdges();
        this.lightenNonSelected = other.isLightenNonSelected();
        this.lightenNonSelectedFactor = other.getLightenNonSelectedFactor();
    }

    @Override
    public float[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        Objects.requireNonNull(color, "backgroundColor can't be null");
        float[] backgroundColorComponents = new float[4];
        color.getRGBComponents(backgroundColorComponents);
        this.backgroundColor = backgroundColorComponents;
    }

    @Override
    public void setBackgroundColor(float[] backgroundColor) {
        Objects.requireNonNull(backgroundColor, "backgroundColor can't be null");
        this.backgroundColor = backgroundColor;
    }

    @Override
    public boolean isBackgroundColorDark() {
        return ColorUtils.isColorDark(this.backgroundColor);
    }

    @Override
    public float getZoom() {
        return this.zoom;
    }

    @Override
    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    @Override
    public Vector2fc getPan() {
        return this.pan;
    }

    @Override
    public void setPan(Vector2fc value) {
        this.pan.set(value);
    }

    @Override
    public boolean isLightenNonSelected() {
        return this.lightenNonSelected;
    }

    @Override
    public void setLightenNonSelected(boolean lightenNonSelected) {
        this.lightenNonSelected = lightenNonSelected;
    }

    @Override
    public float getLightenNonSelectedFactor() {
        return this.lightenNonSelectedFactor;
    }

    @Override
    public void setLightenNonSelectedFactor(float lightenNonSelectedFactor) {
        if (lightenNonSelectedFactor < 0.0f) {
            lightenNonSelectedFactor = 0.0f;
        }
        if (lightenNonSelectedFactor > 1.0f) {
            lightenNonSelectedFactor = 1.0f;
        }
        this.lightenNonSelectedFactor = lightenNonSelectedFactor;
    }

    @Override
    public boolean isAutoSelectNeighbours() {
        return this.autoSelectNeighbours;
    }

    @Override
    public void setAutoSelectNeighbours(boolean autoSelectNeighbours) {
        this.autoSelectNeighbours = autoSelectNeighbours;
    }

    @Override
    public float getNodeScale() {
        return this.nodeScale;
    }

    @Override
    public void setNodeScale(float nodeScale) {
        if (Float.isNaN(nodeScale) || Float.isInfinite(nodeScale)) {
            nodeScale = 1.0f;
        }
        if (nodeScale <= 0.0f) {
            throw new IllegalArgumentException("nodeScale should be > 0");
        }
        this.nodeScale = nodeScale;
    }

    @Override
    public boolean isShowNodes() {
        return this.showNodes;
    }

    @Override
    public void setShowNodes(boolean showNodes) {
        this.showNodes = showNodes;
    }

    @Override
    public boolean isShowEdges() {
        return this.showEdges;
    }

    @Override
    public void setShowEdges(boolean showEdges) {
        this.showEdges = showEdges;
    }

    @Override
    public float getEdgeScale() {
        return this.edgeScale;
    }

    @Override
    public void setEdgeScale(float edgeScale) {
        if (Float.isNaN(edgeScale) || Float.isInfinite(edgeScale)) {
            this.nodeScale = 1.0f;
        }
        if (edgeScale <= 0.0f) {
            throw new IllegalArgumentException("edgeScale should be > 0");
        }
        this.edgeScale = edgeScale;
    }

    @Override
    public boolean isHideNonSelectedEdges() {
        return this.hideNonSelectedEdges;
    }

    @Override
    public void setHideNonSelectedEdges(boolean hideNonSelected) {
        this.hideNonSelectedEdges = hideNonSelected;
    }

    @Override
    public boolean isEdgeSelectionColor() {
        return this.edgeSelectionColor;
    }

    @Override
    public void setEdgeSelectionColor(boolean edgeSelectionColor) {
        this.edgeSelectionColor = edgeSelectionColor;
    }

    @Override
    public Color getEdgeBothSelectionColor() {
        return this.edgeBothSelectionColor;
    }

    @Override
    public void setEdgeBothSelectionColor(Color color) {
        Objects.requireNonNull(color, "edge both selection color can't be null");
        this.edgeBothSelectionColor = color;
    }

    @Override
    public Color getEdgeOutSelectionColor() {
        return this.edgeOutSelectionColor;
    }

    @Override
    public void setEdgeOutSelectionColor(Color color) {
        Objects.requireNonNull(color, "edge out selection color can't be null");
        this.edgeOutSelectionColor = color;
    }

    @Override
    public Color getEdgeInSelectionColor() {
        return this.edgeInSelectionColor;
    }

    @Override
    public void setEdgeInSelectionColor(Color color) {
        Objects.requireNonNull(color, "edge in selection color can't be null");
        this.edgeInSelectionColor = color;
    }

    @Override
    public GraphRenderingOptions.EdgeColorMode getEdgeColorMode() {
        return this.edgeColorMode;
    }

    @Override
    public void setEdgeColorMode(GraphRenderingOptions.EdgeColorMode mode) {
        this.edgeColorMode = Objects.requireNonNull(mode, "mode can't be null");
    }

    @Override
    public boolean isEdgeWeightEnabled() {
        return this.edgeWeightEnabled;
    }

    @Override
    public void setEdgeWeightEnabled(boolean enabled) {
        this.edgeWeightEnabled = enabled;
    }

    @Override
    public boolean isEdgeRescaleWeightEnabled() {
        return this.edgeRescaleWeightEnabled;
    }

    @Override
    public void setEdgeRescaleWeightEnabled(boolean edgeRescaleWeightEnabled) {
        this.edgeRescaleWeightEnabled = edgeRescaleWeightEnabled;
    }

    @Override
    public float getEdgeRescaleMax() {
        return this.edgeRescaleMax;
    }

    @Override
    public void setEdgeRescaleMax(float edgeRescaleMax) {
        this.edgeRescaleMax = edgeRescaleMax;
    }

    @Override
    public float getEdgeRescaleMin() {
        return this.edgeRescaleMin;
    }

    @Override
    public void setEdgeRescaleMin(float edgeRescaleMin) {
        this.edgeRescaleMin = edgeRescaleMin;
    }

    @Override
    public boolean isShowNodeLabels() {
        return this.showNodeLabels;
    }

    @Override
    public void setShowNodeLabels(boolean showNodeLabels) {
        this.showNodeLabels = showNodeLabels;
    }

    @Override
    public Column[] getNodeLabelColumns() {
        return this.nodeLabelColumns;
    }

    @Override
    public void setNodeLabelColumns(Column[] nodeLabelColumns) {
        this.nodeLabelColumns = Objects.requireNonNull(nodeLabelColumns, "nodeLabelColumns can't be null");
    }

    @Override
    public boolean isNodeLabelFitToNodeSize() {
        return this.nodeLabelFitToNodeSize;
    }

    @Override
    public void setNodeLabelFitToNodeSize(boolean fitToNodeSize) {
        this.nodeLabelFitToNodeSize = fitToNodeSize;
    }

    @Override
    public float getNodeLabelScale() {
        return this.nodeLabelScale;
    }

    @Override
    public float getNodeLabelFitToNodeSizeFactor() {
        return this.nodeLabelFitToNodeSizeFactor;
    }

    @Override
    public void setNodeLabelFitToNodeSizeFactor(float factor) {
        this.nodeLabelFitToNodeSizeFactor = factor;
    }

    @Override
    public void setNodeLabelScale(float nodeLabelScale) {
        if (nodeLabelScale <= 0.0f || Float.isNaN(nodeLabelScale) || Float.isInfinite(nodeLabelScale)) {
            throw new IllegalArgumentException("nodeLabelScale should be > 0");
        }
        this.nodeLabelScale = nodeLabelScale;
    }

    @Override
    public GraphRenderingOptions.LabelColorMode getNodeLabelColorMode() {
        return this.nodeLabelColorMode;
    }

    @Override
    public void setNodeLabelColorMode(GraphRenderingOptions.LabelColorMode labelColorMode) {
        this.nodeLabelColorMode = Objects.requireNonNull(labelColorMode, "labelColorMode can't be null");
    }

    @Override
    public GraphRenderingOptions.LabelSizeMode getNodeLabelSizeMode() {
        return this.nodeLabelSizeMode;
    }

    @Override
    public void setNodeLabelSizeMode(GraphRenderingOptions.LabelSizeMode labelSizeMode) {
        this.nodeLabelSizeMode = Objects.requireNonNull(labelSizeMode, "labelSizeMode can't be null");
    }

    @Override
    public Font getNodeLabelFont() {
        return this.nodeLabelFont;
    }

    @Override
    public void setNodeLabelFont(Font font) {
        this.nodeLabelFont = Objects.requireNonNull(font, "font can't be null");
    }

    @Override
    public boolean isHideNonSelectedNodeLabels() {
        return this.hideNonSelectedNodeLabels;
    }

    @Override
    public void setHideNonSelectedNodeLabels(boolean hideNonSelected) {
        this.hideNonSelectedNodeLabels = hideNonSelected;
    }

    @Override
    public boolean isAvoidNodeLabelOverlap() {
        return this.avoidNodeLabelOverlap;
    }

    @Override
    public void setAvoidNodeLabelOverlap(boolean avoidOverlap) {
        this.avoidNodeLabelOverlap = avoidOverlap;
    }

    @Override
    public boolean isShowEdgeLabels() {
        return this.showEdgeLabels;
    }

    @Override
    public void setShowEdgeLabels(boolean showEdgeLabels) {
        this.showEdgeLabels = showEdgeLabels;
    }

    @Override
    public Column[] getEdgeLabelColumns() {
        return this.edgeLabelColumns;
    }

    @Override
    public void setEdgeLabelColumns(Column[] edgeLabelColumns) {
        this.edgeLabelColumns = Objects.requireNonNull(edgeLabelColumns, "edgeLabelColumns can't be null");
    }

    @Override
    public GraphRenderingOptions.LabelColorMode getEdgeLabelColorMode() {
        return this.edgeLabelColorMode;
    }

    @Override
    public void setEdgeLabelColorMode(GraphRenderingOptions.LabelColorMode labelColorMode) {
        this.edgeLabelColorMode = Objects.requireNonNull(labelColorMode, "labelColorMode can't be null");
    }

    @Override
    public GraphRenderingOptions.LabelSizeMode getEdgeLabelSizeMode() {
        return this.edgeLabelSizeMode;
    }

    @Override
    public void setEdgeLabelSizeMode(GraphRenderingOptions.LabelSizeMode labelSizeMode) {
        this.edgeLabelSizeMode = Objects.requireNonNull(labelSizeMode, "labelSizeMode can't be null");
    }

    @Override
    public Font getEdgeLabelFont() {
        return this.edgeLabelFont;
    }

    @Override
    public void setEdgeLabelFont(Font font) {
        this.edgeLabelFont = Objects.requireNonNull(font, "font can't be null");
    }

    @Override
    public float getEdgeLabelScale() {
        return this.edgeLabelScale;
    }

    @Override
    public void setEdgeLabelScale(float edgeLabelScale) {
        if (edgeLabelScale <= 0.0f || Float.isNaN(edgeLabelScale) || Float.isInfinite(edgeLabelScale)) {
            throw new IllegalArgumentException("edgeLabelScale should be > 0");
        }
        this.edgeLabelScale = edgeLabelScale;
    }

    @Override
    public boolean isHideNonSelectedEdgeLabels() {
        return this.hideNonSelectedEdgeLabels;
    }

    @Override
    public void setHideNonSelectedEdgeLabels(boolean hideNonSelected) {
        this.hideNonSelectedEdgeLabels = hideNonSelected;
    }
}

