/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.util.gl.capabilities;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.gephi.viz.engine.jogl.util.gl.GLFunctions;
import org.gephi.viz.engine.jogl.util.gl.capabilities.GLExtensionData;
import org.gephi.viz.engine.jogl.util.gl.capabilities.GLVersionData;
import org.gephi.viz.engine.jogl.util.gl.capabilities.Profile;

public final class GLCapabilitiesSummary {
    private GLVersionData version;
    private GLExtensionData extensions;
    private final IntBuffer data = GLBuffers.newDirectIntBuffer((int)1);

    public GLCapabilitiesSummary(GL gl, Profile profile) {
        this.initVersion(gl, profile);
        this.initExtensions(gl);
        if (this.check(4, 3) || this.extensions.KHR_debug) {
            gl.glGetIntegerv(33310, this.data);
            this.version.CONTEXT_FLAGS = this.data.get(0);
        }
    }

    private boolean check(int majorVersionRequire, int minorVersionRequire) {
        return this.version.MAJOR_VERSION * 100 + this.version.MINOR_VERSION * 10 >= majorVersionRequire * 100 + minorVersionRequire * 10;
    }

    public GLVersionData getVersion() {
        return this.version;
    }

    public GLExtensionData getExtensions() {
        return this.extensions;
    }

    private void initVersion(GL gl, Profile profile) {
        this.version = new GLVersionData(profile);
        gl.glGetIntegerv(33308, this.data);
        this.version.MINOR_VERSION = this.data.get(0);
        gl.glGetIntegerv(33307, this.data);
        this.version.MAJOR_VERSION = this.data.get(0);
        this.version.RENDERER = gl.glGetString(7937);
        this.version.VENDOR = gl.glGetString(7936);
        this.version.VERSION = gl.glGetString(7938);
        this.version.SHADING_LANGUAGE_VERSION = gl.glGetString(35724);
    }

    private void initExtensions(GL gl) {
        Object extension;
        this.extensions = new GLExtensionData();
        ArrayList<String> extensionsList = new ArrayList<String>();
        if (gl.isGL2ES3()) {
            gl.glGetIntegerv(33309, this.data);
            this.version.NUM_EXTENSIONS = this.data.get(0);
            for (int i = 0; i < this.version.NUM_EXTENSIONS; ++i) {
                extension = GLFunctions.glGetStringi(gl.getGL2ES3(), 7939, i);
                extensionsList.add(((String)extension).trim());
            }
        } else {
            String[] parts = gl.glGetString(7939).split(Pattern.quote(","));
            extension = parts;
            int n = ((String[])extension).length;
            for (int i = 0; i < n; ++i) {
                String extension2 = extension[i];
                extensionsList.add(extension2.trim());
            }
        }
        Iterator iterator = extensionsList.iterator();
        while (iterator.hasNext()) {
            switch (extension = (String)iterator.next()) {
                case "GL_ARB_multitexture": {
                    this.extensions.ARB_multitexture = true;
                    break;
                }
                case "GL_ARB_transpose_matrix": {
                    this.extensions.ARB_transpose_matrix = true;
                    break;
                }
                case "GL_ARB_multisample": {
                    this.extensions.ARB_multisample = true;
                    break;
                }
                case "GL_ARB_texture_env_add": {
                    this.extensions.ARB_texture_env_add = true;
                    break;
                }
                case "GL_ARB_texture_cube_map": {
                    this.extensions.ARB_texture_cube_map = true;
                    break;
                }
                case "GL_ARB_texture_compression": {
                    this.extensions.ARB_texture_compression = true;
                    break;
                }
                case "GL_ARB_texture_border_clamp": {
                    this.extensions.ARB_texture_border_clamp = true;
                    break;
                }
                case "GL_ARB_point_parameters": {
                    this.extensions.ARB_point_parameters = true;
                    break;
                }
                case "GL_ARB_vertex_blend": {
                    this.extensions.ARB_vertex_blend = true;
                    break;
                }
                case "GL_ARB_matrix_palette": {
                    this.extensions.ARB_matrix_palette = true;
                    break;
                }
                case "GL_ARB_texture_env_combine": {
                    this.extensions.ARB_texture_env_combine = true;
                    break;
                }
                case "GL_ARB_texture_env_crossbar": {
                    this.extensions.ARB_texture_env_crossbar = true;
                    break;
                }
                case "GL_ARB_texture_env_dot3": {
                    this.extensions.ARB_texture_env_dot3 = true;
                    break;
                }
                case "GL_ARB_texture_mirrored_repeat": {
                    this.extensions.ARB_texture_mirrored_repeat = true;
                    break;
                }
                case "GL_ARB_depth_texture": {
                    this.extensions.ARB_depth_texture = true;
                    break;
                }
                case "GL_ARB_shadow": {
                    this.extensions.ARB_shadow = true;
                    break;
                }
                case "GL_ARB_shadow_ambient": {
                    this.extensions.ARB_shadow_ambient = true;
                    break;
                }
                case "GL_ARB_window_pos": {
                    this.extensions.ARB_window_pos = true;
                    break;
                }
                case "GL_ARB_vertex_program": {
                    this.extensions.ARB_vertex_program = true;
                    break;
                }
                case "GL_ARB_fragment_program": {
                    this.extensions.ARB_fragment_program = true;
                    break;
                }
                case "GL_ARB_vertex_buffer_object": {
                    this.extensions.ARB_vertex_buffer_object = true;
                    break;
                }
                case "GL_ARB_occlusion_query": {
                    this.extensions.ARB_occlusion_query = true;
                    break;
                }
                case "GL_ARB_shader_objects": {
                    this.extensions.ARB_shader_objects = true;
                    break;
                }
                case "GL_ARB_vertex_shader": {
                    this.extensions.ARB_vertex_shader = true;
                    break;
                }
                case "GL_ARB_fragment_shader": {
                    this.extensions.ARB_fragment_shader = true;
                    break;
                }
                case "GL_ARB_shading_language_100": {
                    this.extensions.ARB_shading_language_100 = true;
                    break;
                }
                case "GL_ARB_texture_non_power_of_two": {
                    this.extensions.ARB_texture_non_power_of_two = true;
                    break;
                }
                case "GL_ARB_point_sprite": {
                    this.extensions.ARB_point_sprite = true;
                    break;
                }
                case "GL_ARB_fragment_program_shadow": {
                    this.extensions.ARB_fragment_program_shadow = true;
                    break;
                }
                case "GL_ARB_draw_buffers": {
                    this.extensions.ARB_draw_buffers = true;
                    break;
                }
                case "GL_ARB_texture_rectangle": {
                    this.extensions.ARB_texture_rectangle = true;
                    break;
                }
                case "GL_ARB_color_buffer_float": {
                    this.extensions.ARB_color_buffer_float = true;
                    break;
                }
                case "GL_ARB_half_float_pixel": {
                    this.extensions.ARB_half_float_pixel = true;
                    break;
                }
                case "GL_ARB_texture_float": {
                    this.extensions.ARB_texture_float = true;
                    break;
                }
                case "GL_ARB_pixel_buffer_object": {
                    this.extensions.ARB_pixel_buffer_object = true;
                    break;
                }
                case "GL_ARB_depth_buffer_float": {
                    this.extensions.ARB_depth_buffer_float = true;
                    break;
                }
                case "GL_ARB_draw_instanced": {
                    this.extensions.ARB_draw_instanced = true;
                    break;
                }
                case "GL_ARB_framebuffer_object": {
                    this.extensions.ARB_framebuffer_object = true;
                    break;
                }
                case "GL_ARB_framebuffer_sRGB": {
                    this.extensions.ARB_framebuffer_sRGB = true;
                    break;
                }
                case "GL_ARB_geometry_shader4": {
                    this.extensions.ARB_geometry_shader4 = true;
                    break;
                }
                case "GL_ARB_half_float_vertex": {
                    this.extensions.ARB_half_float_vertex = true;
                    break;
                }
                case "GL_ARB_instanced_arrays": {
                    this.extensions.ARB_instanced_arrays = true;
                    break;
                }
                case "GL_ARB_map_buffer_range": {
                    this.extensions.ARB_map_buffer_range = true;
                    break;
                }
                case "GL_ARB_texture_buffer_object": {
                    this.extensions.ARB_texture_buffer_object = true;
                    break;
                }
                case "GL_ARB_texture_compression_rgtc": {
                    this.extensions.ARB_texture_compression_rgtc = true;
                    break;
                }
                case "GL_ARB_texture_rg": {
                    this.extensions.ARB_texture_rg = true;
                    break;
                }
                case "GL_ARB_vertex_array_object": {
                    this.extensions.ARB_vertex_array_object = true;
                    break;
                }
                case "GL_ARB_uniform_buffer_object": {
                    this.extensions.ARB_uniform_buffer_object = true;
                    break;
                }
                case "GL_ARB_compatibility": {
                    this.extensions.ARB_compatibility = true;
                    break;
                }
                case "GL_ARB_copy_buffer": {
                    this.extensions.ARB_copy_buffer = true;
                    break;
                }
                case "GL_ARB_shader_texture_lod": {
                    this.extensions.ARB_shader_texture_lod = true;
                    break;
                }
                case "GL_ARB_depth_clamp": {
                    this.extensions.ARB_depth_clamp = true;
                    break;
                }
                case "GL_ARB_draw_elements_base_vertex": {
                    this.extensions.ARB_draw_elements_base_vertex = true;
                    break;
                }
                case "GL_ARB_fragment_coord_conventions": {
                    this.extensions.ARB_fragment_coord_conventions = true;
                    break;
                }
                case "GL_ARB_provoking_vertex": {
                    this.extensions.ARB_provoking_vertex = true;
                    break;
                }
                case "GL_ARB_seamless_cube_map": {
                    this.extensions.ARB_seamless_cube_map = true;
                    break;
                }
                case "GL_ARB_sync": {
                    this.extensions.ARB_sync = true;
                    break;
                }
                case "GL_ARB_texture_multisample": {
                    this.extensions.ARB_texture_multisample = true;
                    break;
                }
                case "GL_ARB_vertex_array_bgra": {
                    this.extensions.ARB_vertex_array_bgra = true;
                    break;
                }
                case "GL_ARB_draw_buffers_blend": {
                    this.extensions.ARB_draw_buffers_blend = true;
                    break;
                }
                case "GL_ARB_sample_shading": {
                    this.extensions.ARB_sample_shading = true;
                    break;
                }
                case "GL_ARB_texture_cube_map_array": {
                    this.extensions.ARB_texture_cube_map_array = true;
                    break;
                }
                case "GL_ARB_texture_gather": {
                    this.extensions.ARB_texture_gather = true;
                    break;
                }
                case "GL_ARB_texture_query_lod": {
                    this.extensions.ARB_texture_query_lod = true;
                    break;
                }
                case "GL_ARB_shading_language_include": {
                    this.extensions.ARB_shading_language_include = true;
                    break;
                }
                case "GL_ARB_texture_compression_bptc": {
                    this.extensions.ARB_texture_compression_bptc = true;
                    break;
                }
                case "GL_ARB_blend_func_extended": {
                    this.extensions.ARB_blend_func_extended = true;
                    break;
                }
                case "GL_ARB_explicit_attrib_location": {
                    this.extensions.ARB_explicit_attrib_location = true;
                    break;
                }
                case "GL_ARB_occlusion_query2": {
                    this.extensions.ARB_occlusion_query2 = true;
                    break;
                }
                case "GL_ARB_sampler_objects": {
                    this.extensions.ARB_sampler_objects = true;
                    break;
                }
                case "GL_ARB_shader_bit_encoding": {
                    this.extensions.ARB_shader_bit_encoding = true;
                    break;
                }
                case "GL_ARB_texture_rgb10_a2ui": {
                    this.extensions.ARB_texture_rgb10_a2ui = true;
                    break;
                }
                case "GL_ARB_texture_swizzle": {
                    this.extensions.ARB_texture_swizzle = true;
                    break;
                }
                case "GL_ARB_timer_query": {
                    this.extensions.ARB_timer_query = true;
                    break;
                }
                case "GL_ARB_vertex_type_2_10_10_10_rev": {
                    this.extensions.ARB_vertex_type_2_10_10_10_rev = true;
                    break;
                }
                case "GL_ARB_draw_indirect": {
                    this.extensions.ARB_draw_indirect = true;
                    break;
                }
                case "GL_ARB_gpu_shader5": {
                    this.extensions.ARB_gpu_shader5 = true;
                    break;
                }
                case "GL_ARB_gpu_shader_fp64": {
                    this.extensions.ARB_gpu_shader_fp64 = true;
                    break;
                }
                case "GL_ARB_shader_subroutine": {
                    this.extensions.ARB_shader_subroutine = true;
                    break;
                }
                case "GL_ARB_tessellation_shader": {
                    this.extensions.ARB_tessellation_shader = true;
                    break;
                }
                case "GL_ARB_texture_buffer_object_rgb32": {
                    this.extensions.ARB_texture_buffer_object_rgb32 = true;
                    break;
                }
                case "GL_ARB_transform_feedback2": {
                    this.extensions.ARB_transform_feedback2 = true;
                    break;
                }
                case "GL_ARB_transform_feedback3": {
                    this.extensions.ARB_transform_feedback3 = true;
                    break;
                }
                case "GL_ARB_ES2_compatibility": {
                    this.extensions.ARB_ES2_compatibility = true;
                    break;
                }
                case "GL_ARB_get_program_binary": {
                    this.extensions.ARB_get_program_binary = true;
                    break;
                }
                case "GL_ARB_separate_shader_objects": {
                    this.extensions.ARB_separate_shader_objects = true;
                    break;
                }
                case "GL_ARB_shader_precision": {
                    this.extensions.ARB_shader_precision = true;
                    break;
                }
                case "GL_ARB_vertex_attrib_64bit": {
                    this.extensions.ARB_vertex_attrib_64bit = true;
                    break;
                }
                case "GL_ARB_viewport_array": {
                    this.extensions.ARB_viewport_array = true;
                    break;
                }
                case "GL_ARB_cl_event": {
                    this.extensions.ARB_cl_event = true;
                    break;
                }
                case "GL_ARB_debug_output": {
                    this.extensions.ARB_debug_output = true;
                    break;
                }
                case "GL_ARB_robustness": {
                    this.extensions.ARB_robustness = true;
                    break;
                }
                case "GL_ARB_shader_stencil_export": {
                    this.extensions.ARB_shader_stencil_export = true;
                    break;
                }
                case "GL_ARB_base_instance": {
                    this.extensions.ARB_base_instance = true;
                    break;
                }
                case "GL_ARB_shading_language_420pack": {
                    this.extensions.ARB_shading_language_420pack = true;
                    break;
                }
                case "GL_ARB_transform_feedback_instanced": {
                    this.extensions.ARB_transform_feedback_instanced = true;
                    break;
                }
                case "GL_ARB_compressed_texture_pixel_storage": {
                    this.extensions.ARB_compressed_texture_pixel_storage = true;
                    break;
                }
                case "GL_ARB_conservative_depth": {
                    this.extensions.ARB_conservative_depth = true;
                    break;
                }
                case "GL_ARB_internalformat_query": {
                    this.extensions.ARB_internalformat_query = true;
                    break;
                }
                case "GL_ARB_map_buffer_alignment": {
                    this.extensions.ARB_map_buffer_alignment = true;
                    break;
                }
                case "GL_ARB_shader_atomic_counters": {
                    this.extensions.ARB_shader_atomic_counters = true;
                    break;
                }
                case "GL_ARB_shader_image_load_store": {
                    this.extensions.ARB_shader_image_load_store = true;
                    break;
                }
                case "GL_ARB_shading_language_packing": {
                    this.extensions.ARB_shading_language_packing = true;
                    break;
                }
                case "GL_ARB_texture_storage": {
                    this.extensions.ARB_texture_storage = true;
                    break;
                }
                case "GL_KHR_texture_compression_astc_hdr": {
                    this.extensions.KHR_texture_compression_astc_hdr = true;
                    break;
                }
                case "GL_KHR_texture_compression_astc_ldr": {
                    this.extensions.KHR_texture_compression_astc_ldr = true;
                    break;
                }
                case "GL_KHR_debug": {
                    this.extensions.KHR_debug = true;
                    break;
                }
                case "GL_ARB_arrays_of_arrays": {
                    this.extensions.ARB_arrays_of_arrays = true;
                    break;
                }
                case "GL_ARB_clear_buffer_object": {
                    this.extensions.ARB_clear_buffer_object = true;
                    break;
                }
                case "GL_ARB_compute_shader": {
                    this.extensions.ARB_compute_shader = true;
                    break;
                }
                case "GL_ARB_copy_image": {
                    this.extensions.ARB_copy_image = true;
                    break;
                }
                case "GL_ARB_texture_view": {
                    this.extensions.ARB_texture_view = true;
                    break;
                }
                case "GL_ARB_vertex_attrib_binding": {
                    this.extensions.ARB_vertex_attrib_binding = true;
                    break;
                }
                case "GL_ARB_robustness_isolation": {
                    this.extensions.ARB_robustness_isolation = true;
                    break;
                }
                case "GL_ARB_ES3_compatibility": {
                    this.extensions.ARB_ES3_compatibility = true;
                    break;
                }
                case "GL_ARB_explicit_uniform_location": {
                    this.extensions.ARB_explicit_uniform_location = true;
                    break;
                }
                case "GL_ARB_fragment_layer_viewport": {
                    this.extensions.ARB_fragment_layer_viewport = true;
                    break;
                }
                case "GL_ARB_framebuffer_no_attachments": {
                    this.extensions.ARB_framebuffer_no_attachments = true;
                    break;
                }
                case "GL_ARB_internalformat_query2": {
                    this.extensions.ARB_internalformat_query2 = true;
                    break;
                }
                case "GL_ARB_invalidate_subdata": {
                    this.extensions.ARB_invalidate_subdata = true;
                    break;
                }
                case "GL_ARB_multi_draw_indirect": {
                    this.extensions.ARB_multi_draw_indirect = true;
                    break;
                }
                case "GL_ARB_program_interface_query": {
                    this.extensions.ARB_program_interface_query = true;
                    break;
                }
                case "GL_ARB_robust_buffer_access_behavior": {
                    this.extensions.ARB_robust_buffer_access_behavior = true;
                    break;
                }
                case "GL_ARB_shader_image_size": {
                    this.extensions.ARB_shader_image_size = true;
                    break;
                }
                case "GL_ARB_shader_storage_buffer_object": {
                    this.extensions.ARB_shader_storage_buffer_object = true;
                    break;
                }
                case "GL_ARB_stencil_texturing": {
                    this.extensions.ARB_stencil_texturing = true;
                    break;
                }
                case "GL_ARB_texture_buffer_range": {
                    this.extensions.ARB_texture_buffer_range = true;
                    break;
                }
                case "GL_ARB_texture_query_levels": {
                    this.extensions.ARB_texture_query_levels = true;
                    break;
                }
                case "GL_ARB_texture_storage_multisample": {
                    this.extensions.ARB_texture_storage_multisample = true;
                    break;
                }
                case "GL_ARB_buffer_storage": {
                    this.extensions.ARB_buffer_storage = true;
                    break;
                }
                case "GL_ARB_clear_texture": {
                    this.extensions.ARB_clear_texture = true;
                    break;
                }
                case "GL_ARB_enhanced_layouts": {
                    this.extensions.ARB_enhanced_layouts = true;
                    break;
                }
                case "GL_ARB_multi_bind": {
                    this.extensions.ARB_multi_bind = true;
                    break;
                }
                case "GL_ARB_query_buffer_object": {
                    this.extensions.ARB_query_buffer_object = true;
                    break;
                }
                case "GL_ARB_texture_mirror_clamp_to_edge": {
                    this.extensions.ARB_texture_mirror_clamp_to_edge = true;
                    break;
                }
                case "GL_ARB_texture_stencil8": {
                    this.extensions.ARB_texture_stencil8 = true;
                    break;
                }
                case "GL_ARB_vertex_type_10f_11f_11f_rev": {
                    this.extensions.ARB_vertex_type_10f_11f_11f_rev = true;
                    break;
                }
                case "GL_ARB_bindless_texture": {
                    this.extensions.ARB_bindless_texture = true;
                    break;
                }
                case "GL_ARB_compute_variable_group_size": {
                    this.extensions.ARB_compute_variable_group_size = true;
                    break;
                }
                case "GL_ARB_indirect_parameters": {
                    this.extensions.ARB_indirect_parameters = true;
                    break;
                }
                case "GL_ARB_seamless_cubemap_per_texture": {
                    this.extensions.ARB_seamless_cubemap_per_texture = true;
                    break;
                }
                case "GL_ARB_shader_draw_parameters": {
                    this.extensions.ARB_shader_draw_parameters = true;
                    break;
                }
                case "GL_ARB_shader_group_vote": {
                    this.extensions.ARB_shader_group_vote = true;
                    break;
                }
                case "GL_ARB_sparse_texture": {
                    this.extensions.ARB_sparse_texture = true;
                    break;
                }
                case "GL_ARB_ES3_1_compatibility": {
                    this.extensions.ARB_ES3_1_compatibility = true;
                    break;
                }
                case "GL_ARB_clip_control": {
                    this.extensions.ARB_clip_control = true;
                    break;
                }
                case "GL_ARB_conditional_render_inverted": {
                    this.extensions.ARB_conditional_render_inverted = true;
                    break;
                }
                case "GL_ARB_derivative_control": {
                    this.extensions.ARB_derivative_control = true;
                    break;
                }
                case "GL_ARB_direct_state_access": {
                    this.extensions.ARB_direct_state_access = true;
                    break;
                }
                case "GL_ARB_get_texture_sub_image": {
                    this.extensions.ARB_get_texture_sub_image = true;
                    break;
                }
                case "GL_ARB_shader_texture_image_samples": {
                    this.extensions.ARB_shader_texture_image_samples = true;
                    break;
                }
                case "GL_ARB_texture_barrier": {
                    this.extensions.ARB_texture_barrier = true;
                    break;
                }
                case "GL_KHR_context_flush_control": {
                    this.extensions.KHR_context_flush_control = true;
                    break;
                }
                case "GL_KHR_robust_buffer_access_behavior": {
                    this.extensions.KHR_robust_buffer_access_behavior = true;
                    break;
                }
                case "GL_KHR_robustness": {
                    this.extensions.KHR_robustness = true;
                    break;
                }
                case "GL_ARB_pipeline_statistics_query": {
                    this.extensions.ARB_pipeline_statistics_query = true;
                    break;
                }
                case "GL_ARB_sparse_buffer": {
                    this.extensions.ARB_sparse_buffer = true;
                    break;
                }
                case "GL_ARB_transform_feedback_overflow_query": {
                    this.extensions.ARB_transform_feedback_overflow_query = true;
                    break;
                }
                case "GL_EXT_gpu_shader4": {
                    this.extensions.EXT_gpu_shader4 = true;
                    break;
                }
                case "GL_EXT_texture_compression_s3tc": {
                    this.extensions.EXT_texture_compression_s3tc = true;
                    break;
                }
                case "GL_EXT_texture_compression_latc": {
                    this.extensions.EXT_texture_compression_latc = true;
                    break;
                }
                case "GL_EXT_transform_feedback": {
                    this.extensions.EXT_transform_feedback = true;
                    break;
                }
                case "GL_EXT_direct_state_access": {
                    this.extensions.EXT_direct_state_access = true;
                    break;
                }
                case "GL_EXT_texture_filter_anisotropic": {
                    this.extensions.EXT_texture_filter_anisotropic = true;
                    break;
                }
                case "GL_EXT_texture_array": {
                    this.extensions.EXT_texture_array = true;
                    break;
                }
                case "GL_EXT_texture_snorm": {
                    this.extensions.EXT_texture_snorm = true;
                    break;
                }
                case "GL_EXT_texture_sRGB_decode": {
                    this.extensions.EXT_texture_sRGB_decode = true;
                    break;
                }
                case "GL_EXT_framebuffer_multisample_blit_scaled": {
                    this.extensions.EXT_framebuffer_multisample_blit_scaled = true;
                    break;
                }
                case "GL_EXT_shader_integer_mix": {
                    this.extensions.EXT_shader_integer_mix = true;
                    break;
                }
                case "GL_EXT_polygon_offset_clamp": {
                    this.extensions.EXT_polygon_offset_clamp = true;
                    break;
                }
                case "GL_NV_explicit_multisample": {
                    this.extensions.NV_explicit_multisample = true;
                    break;
                }
                case "GL_NV_shader_buffer_load": {
                    this.extensions.NV_shader_buffer_load = true;
                    break;
                }
                case "GL_NV_vertex_buffer_unified_memory": {
                    this.extensions.NV_vertex_buffer_unified_memory = true;
                    break;
                }
                case "GL_NV_shader_buffer_store": {
                    this.extensions.NV_shader_buffer_store = true;
                    break;
                }
                case "GL_NV_bindless_multi_draw_indirect": {
                    this.extensions.NV_bindless_multi_draw_indirect = true;
                    break;
                }
                case "GL_NV_blend_equation_advanced": {
                    this.extensions.NV_blend_equation_advanced = true;
                    break;
                }
                case "GL_NV_deep_texture3D": {
                    this.extensions.NV_deep_texture3D = true;
                    break;
                }
                case "GL_NV_shader_thread_group": {
                    this.extensions.NV_shader_thread_group = true;
                    break;
                }
                case "GL_NV_shader_thread_shuffle": {
                    this.extensions.NV_shader_thread_shuffle = true;
                    break;
                }
                case "GL_NV_shader_atomic_int64": {
                    this.extensions.NV_shader_atomic_int64 = true;
                    break;
                }
                case "GL_NV_bindless_multi_draw_indirect_count": {
                    this.extensions.NV_bindless_multi_draw_indirect_count = true;
                    break;
                }
                case "GL_NV_uniform_buffer_unified_memory": {
                    this.extensions.NV_uniform_buffer_unified_memory = true;
                    break;
                }
                case "GL_ATI_texture_compression_3dc": {
                    this.extensions.ATI_texture_compression_3dc = true;
                    break;
                }
                case "GL_AMD_depth_clamp_separate": {
                    this.extensions.AMD_depth_clamp_separate = true;
                    break;
                }
                case "GL_AMD_stencil_operation_extended": {
                    this.extensions.AMD_stencil_operation_extended = true;
                    break;
                }
                case "GL_AMD_vertex_shader_viewport_index": {
                    this.extensions.AMD_vertex_shader_viewport_index = true;
                    break;
                }
                case "GL_AMD_vertex_shader_layer": {
                    this.extensions.AMD_vertex_shader_layer = true;
                    break;
                }
                case "GL_AMD_shader_trinary_minmax": {
                    this.extensions.AMD_shader_trinary_minmax = true;
                    break;
                }
                case "GL_AMD_interleaved_elements": {
                    this.extensions.AMD_interleaved_elements = true;
                    break;
                }
                case "GL_AMD_shader_atomic_counter_ops": {
                    this.extensions.AMD_shader_atomic_counter_ops = true;
                    break;
                }
                case "GL_AMD_shader_stencil_value_export": {
                    this.extensions.AMD_shader_stencil_value_export = true;
                    break;
                }
                case "GL_AMD_transform_feedback4": {
                    this.extensions.AMD_transform_feedback4 = true;
                    break;
                }
                case "GL_AMD_gpu_shader_int64": {
                    this.extensions.AMD_gpu_shader_int64 = true;
                    break;
                }
                case "GL_AMD_gcn_shader": {
                    this.extensions.AMD_gcn_shader = true;
                    break;
                }
                case "GL_INTEL_map_texture": {
                    this.extensions.INTEL_map_texture = true;
                    break;
                }
                case "GL_INTEL_fragment_shader_ordering": {
                    this.extensions.INTEL_fragment_shader_ordering = true;
                    break;
                }
                case "GL_INTEL_performance_query": {
                    this.extensions.INTEL_performance_query = true;
                }
            }
        }
    }

    public boolean isVAOSupported() {
        return this.version.MAJOR_VERSION >= 3 || this.extensions.ARB_vertex_array_object;
    }

    public boolean isInstancingSupported() {
        return (this.version.MAJOR_VERSION >= 3 || this.extensions.ARB_draw_instanced) && this.extensions.ARB_instanced_arrays;
    }

    public boolean isIndirectDrawSupported() {
        return this.extensions.ARB_draw_indirect && this.extensions.ARB_multi_draw_indirect && this.extensions.ARB_buffer_storage;
    }

    public boolean isVendorIntel() {
        return this.version.VENDOR != null && this.version.VENDOR.toLowerCase().contains("intel");
    }

    public String getVendor() {
        return this.version.VENDOR;
    }

    public String getRenderer() {
        return this.version.RENDERER;
    }

    public String getVersionString() {
        return this.version.VERSION;
    }

    public String getShadingLanguageVersion() {
        return this.version.SHADING_LANGUAGE_VERSION;
    }
}

