/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.util.gl;

import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.IntBuffer;
import org.gephi.viz.engine.jogl.util.gl.GLFunctions;
import org.gephi.viz.engine.util.gl.OpenGLOptions;

public abstract class GLVertexArrayObject {
    private final boolean vaoSupported;
    private int[] attributeLocations;
    private int[] instancedAttributeLocations;
    private int arrayId = -1;
    private final int[] previousArrayId = new int[1];

    public GLVertexArrayObject(OpenGLOptions openGLOptions) {
        this.vaoSupported = openGLOptions.isVAOSupported();
    }

    private void init(GL2ES2 gl) {
        this.attributeLocations = this.getUsedAttributeLocations();
        this.attributeLocations = this.attributeLocations == null ? new int[0] : (int[])this.attributeLocations.clone();
        this.instancedAttributeLocations = this.getInstancedAttributeLocations();
        this.instancedAttributeLocations = this.instancedAttributeLocations == null ? new int[0] : (int[])this.instancedAttributeLocations.clone();
        if (this.vaoSupported) {
            IntBuffer vertexArrayName = GLBuffers.newDirectIntBuffer((int)1);
            GLFunctions.glGenVertexArrays(gl, 1, vertexArrayName);
            this.arrayId = vertexArrayName.get(0);
            gl.glGetIntegerv(34229, this.previousArrayId, 0);
            this.bind(gl);
            this.configureAll(gl);
            this.unbind(gl);
        }
    }

    public void use(GL2ES2 gl) {
        if (this.attributeLocations == null) {
            this.init(gl);
        }
        if (this.vaoSupported) {
            this.bind(gl);
        } else {
            this.configureAll(gl);
        }
    }

    public void stopUsing(GL2ES2 gl) {
        if (this.vaoSupported) {
            this.unbind(gl);
        } else {
            this.unconfigureEnabledAttributes(gl);
        }
    }

    private void configureAll(GL2ES2 gl) {
        this.configure(gl);
        this.configureEnabledAttributes(gl);
    }

    private void bind(GL2ES2 gl) {
        GLFunctions.glBindVertexArray(gl, this.arrayId);
    }

    private void unbind(GL2ES2 gl) {
        GLFunctions.glUnbindVertexArray(gl, this.previousArrayId[0]);
    }

    private void configureEnabledAttributes(GL2ES2 gl) {
        for (int attributeLocation : this.attributeLocations) {
            gl.glEnableVertexAttribArray(attributeLocation);
        }
        for (int instancedAttributeLocation : this.instancedAttributeLocations) {
            GLFunctions.glVertexAttribDivisor(gl, instancedAttributeLocation, 1);
        }
    }

    private void unconfigureEnabledAttributes(GL2ES2 gl) {
        for (int attributeLocation : this.attributeLocations) {
            gl.glDisableVertexAttribArray(attributeLocation);
        }
        for (int instancedAttributeLocation : this.instancedAttributeLocations) {
            GLFunctions.glVertexAttribDivisor(gl, instancedAttributeLocation, 0);
        }
    }

    public void destroy(GL2ES2 gl) {
        if (this.vaoSupported && this.arrayId != -1) {
            IntBuffer vertexArrayName = GLBuffers.newDirectIntBuffer((int)1);
            vertexArrayName.put(0, this.arrayId);
            GLFunctions.glDeleteVertexArrays(gl, 1, vertexArrayName);
            this.arrayId = -1;
        }
        this.attributeLocations = null;
        this.instancedAttributeLocations = null;
    }

    protected abstract void configure(GL2ES2 var1);

    protected abstract int[] getUsedAttributeLocations();

    protected abstract int[] getInstancedAttributeLocations();
}

