/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.util.gl;

import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.util.HashMap;
import java.util.Map;

public class GLShaderProgram {
    private final String srcRoot;
    private final String vertBasename;
    private final String fragBasename;
    private int id = -1;
    private final Map<String, Integer> uniformLocations;
    private final Map<String, Integer> attribLocations;
    private boolean initDone = false;

    public GLShaderProgram(String srcRoot, String vertBasename) {
        this(srcRoot, vertBasename, null);
    }

    public GLShaderProgram(String srcRoot, String vertBasename, String fragBasename) {
        this.srcRoot = srcRoot;
        this.vertBasename = vertBasename;
        this.fragBasename = fragBasename;
        this.uniformLocations = new HashMap<String, Integer>();
        this.attribLocations = new HashMap<String, Integer>();
    }

    public GLShaderProgram addUniformName(String name) {
        this.uniformLocations.put(name, null);
        return this;
    }

    public GLShaderProgram addAttribName(String name) {
        this.attribLocations.put(name, null);
        return this;
    }

    public GLShaderProgram addAttribLocation(String name, int location) {
        this.attribLocations.put(name, location);
        return this;
    }

    public GLShaderProgram init(GL2ES2 gl) {
        if (this.initDone) {
            throw new IllegalStateException("Already initialized");
        }
        ShaderProgram shaderProgram = new ShaderProgram();
        ShaderCode vertShaderCode = ShaderCode.create((GL2ES2)gl, (int)35633, this.getClass(), (String)this.srcRoot, null, (String)this.vertBasename, (String)"vert", null, (boolean)true);
        shaderProgram.add(vertShaderCode);
        if (this.fragBasename != null) {
            ShaderCode fragShaderCode = ShaderCode.create((GL2ES2)gl, (int)35632, this.getClass(), (String)this.srcRoot, null, (String)this.fragBasename, (String)"frag", null, (boolean)true);
            shaderProgram.add(fragShaderCode);
        }
        shaderProgram.init(gl);
        this.id = shaderProgram.program();
        for (String name : this.attribLocations.keySet().toArray(new String[0])) {
            if (this.attribLocations.get(name) == null) continue;
            gl.glBindAttribLocation(this.id, this.attribLocations.get(name).intValue(), name);
        }
        shaderProgram.link(gl, System.out);
        for (String name : this.uniformLocations.keySet().toArray(new String[0])) {
            this.uniformLocations.put(name, gl.glGetUniformLocation(this.id, name));
        }
        for (String name : this.attribLocations.keySet().toArray(new String[0])) {
            if (this.attribLocations.get(name) != null) continue;
            this.attribLocations.put(name, gl.glGetAttribLocation(this.id, name));
        }
        this.initDone = true;
        return this;
    }

    public boolean isInitialized() {
        return this.initDone;
    }

    public int id() {
        return this.id;
    }

    public int getUniformLocation(String name) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Initialize the program first!");
        }
        Integer loc = this.uniformLocations.get(name);
        if (loc == null) {
            throw new IllegalArgumentException("Name of uniform " + name + " was not added before init");
        }
        return loc;
    }

    public int getAttribLocation(String name) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Initialize the program first!");
        }
        Integer loc = this.attribLocations.get(name);
        if (loc == null) {
            throw new IllegalArgumentException("Name of attribute " + name + " was not added before init");
        }
        return loc;
    }

    public void use(GL2ES2 gl) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Initialize the program first!");
        }
        gl.glUseProgram(this.id);
    }

    public void stopUsing(GL2ES2 gl) {
        gl.glUseProgram(0);
    }

    public void destroy(GL2ES2 gl) {
        if (this.id != -1) {
            gl.glDeleteProgram(this.id);
            this.id = -1;
        }
        this.uniformLocations.clear();
        this.attribLocations.clear();
        this.initDone = false;
    }
}

