/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.util.gl;

import com.jogamp.opengl.GL;
import java.nio.Buffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.jogl.util.gl.GLBuffer;
import org.gephi.viz.engine.util.ArrayUtils;
import org.gephi.viz.engine.util.gl.Buffers;

public class GLBufferMutable
implements GLBuffer {
    public static final int GL_BUFFER_TYPE_ARRAY = 34962;
    public static final int GL_BUFFER_TYPE_ELEMENT_INDICES = 34963;
    public static final int GL_BUFFER_TYPE_DRAW_INDIRECT = 36671;
    public static final int GL_BUFFER_USAGE_STATIC_DRAW = 35044;
    public static final int GL_BUFFER_USAGE_STREAM_DRAW = 35040;
    public static final int GL_BUFFER_USAGE_DYNAMIC_DRAW = 35048;
    private final int id;
    private final int type;
    private int usage = -1;
    private long sizeBytes = -1L;

    public GLBufferMutable(int id, int type) {
        this.id = id;
        this.type = type;
    }

    @Override
    public void bind(GL gl) {
        gl.glBindBuffer(this.type, this.id);
    }

    @Override
    public void unbind(GL gl) {
        gl.glBindBuffer(this.type, 0);
    }

    @Override
    public void init(GL gl, long sizeBytes, int usage) {
        if (!this.isBound(gl)) {
            throw new IllegalStateException("You should bind the buffer first!");
        }
        this.usage = usage;
        this.sizeBytes = sizeBytes;
        gl.glBufferData(this.type, sizeBytes, null, usage);
    }

    @Override
    public void init(GL gl, Buffer buffer, int usage) {
        if (!this.isBound(gl)) {
            throw new IllegalStateException("You should bind the buffer first!");
        }
        this.usage = usage;
        int elementBytes = Buffers.bufferElementBytes(buffer);
        this.sizeBytes = (long)buffer.capacity() * (long)elementBytes;
        gl.glBufferData(this.type, this.sizeBytes, buffer, usage);
    }

    @Override
    public void update(GL gl, Buffer buffer) {
        this.update(gl, buffer, (long)buffer.remaining() * (long)Buffers.bufferElementBytes(buffer));
    }

    @Override
    public void update(GL gl, Buffer buffer, long sizeBytes) {
        this.update(gl, buffer, 0L, sizeBytes);
    }

    @Override
    public void update(GL gl, Buffer buffer, long offsetBytes, long sizeBytes) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("You should initialize the buffer first!");
        }
        if (!this.isBound(gl)) {
            throw new IllegalStateException("You should bind the buffer first!");
        }
        long neededBytesCapacity = offsetBytes + sizeBytes;
        this.ensureCapacity(gl, neededBytesCapacity);
        gl.glBufferSubData(this.type, offsetBytes, sizeBytes, buffer);
    }

    @Override
    public void updateWithOrphaning(GL gl, Buffer buffer) {
        if (!this.isBound(gl)) {
            throw new IllegalStateException("You should bind the buffer first!");
        }
        gl.glBufferData(this.type, this.sizeBytes, null, this.usage);
        this.update(gl, buffer);
    }

    @Override
    public void updateWithOrphaning(GL gl, Buffer buffer, long sizeBytes) {
        if (!this.isBound(gl)) {
            throw new IllegalStateException("You should bind the buffer first!");
        }
        gl.glBufferData(this.type, sizeBytes, null, this.usage);
        this.update(gl, buffer, sizeBytes);
    }

    @Override
    public void destroy(GL gl) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("You should initialize the buffer first!");
        }
        gl.glDeleteBuffers(1, new int[]{this.id}, 0);
        this.sizeBytes = -1L;
    }

    @Override
    public long size() {
        return this.sizeBytes;
    }

    public void ensureCapacity(GL gl, long neededBytes) {
        if (this.sizeBytes < neededBytes) {
            long newSizeBytes = ArrayUtils.getNextPowerOf2(neededBytes);
            Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "Growing GL buffer from " + this.sizeBytes + " to " + newSizeBytes + " bytes");
            this.init(gl, newSizeBytes, this.usage);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.sizeBytes != -1L;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isBound(GL gl) {
        return gl.getBoundBuffer(this.type) == this.id;
    }

    @Override
    public int getUsageFlags() {
        return this.usage;
    }

    @Override
    public long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

