/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.util.gl;

import com.jogamp.opengl.GL;
import java.nio.Buffer;
import org.gephi.viz.engine.jogl.util.gl.GLBuffer;
import org.gephi.viz.engine.util.gl.Buffers;

public class GLBufferImmutable
implements GLBuffer {
    private final int id;
    private final int type;
    private int flags = -1;
    private long sizeBytes = -1L;

    public GLBufferImmutable(int id, int type) {
        this.id = id;
        this.type = type;
    }

    @Override
    public void bind(GL gl) {
        gl.glBindBuffer(this.type, this.id);
    }

    @Override
    public void unbind(GL gl) {
        gl.glBindBuffer(this.type, 0);
    }

    @Override
    public void init(GL gl, long sizeBytes, int flags) {
        if (!this.isBound(gl)) {
            throw new IllegalStateException("You should bind the buffer first!");
        }
        if (this.isInitialized()) {
            throw new UnsupportedOperationException("Cannot reinitialize an immutable buffer");
        }
        if (!gl.isGL4()) {
            throw new UnsupportedOperationException("Need GL4 for using immutable buffer");
        }
        this.flags = flags;
        this.sizeBytes = sizeBytes;
        gl.getGL4().glBufferStorage(this.type, sizeBytes, null, flags);
    }

    @Override
    public void init(GL gl, Buffer buffer, int flags) {
        if (!this.isBound(gl)) {
            throw new IllegalStateException("You should bind the buffer first!");
        }
        if (this.isInitialized()) {
            throw new UnsupportedOperationException("Cannot reinitialize an immutable buffer");
        }
        if (!gl.isGL4()) {
            throw new UnsupportedOperationException("Need GL4 for using immutable buffer");
        }
        this.flags = flags;
        int elementBytes = Buffers.bufferElementBytes(buffer);
        this.sizeBytes = (long)buffer.capacity() * (long)elementBytes;
        gl.getGL4().glBufferStorage(this.type, this.sizeBytes, buffer, flags);
    }

    @Override
    public void update(GL gl, Buffer buffer) {
        this.update(gl, buffer, (long)buffer.remaining() * (long)Buffers.bufferElementBytes(buffer));
    }

    @Override
    public void update(GL gl, Buffer buffer, long sizeBytes) {
        this.update(gl, buffer, 0L, sizeBytes);
    }

    @Override
    public void update(GL gl, Buffer buffer, long offsetBytes, long sizeBytes) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("You should initialize the buffer first!");
        }
        if (!this.isBound(gl)) {
            throw new IllegalStateException("You should bind the buffer first!");
        }
        long neededBytesCapacity = offsetBytes + sizeBytes;
        this.ensureCapacity(gl, neededBytesCapacity);
        gl.glBufferSubData(this.type, offsetBytes, sizeBytes, buffer);
    }

    @Override
    public void updateWithOrphaning(GL gl, Buffer buffer) {
        throw new UnsupportedOperationException("This buffer is immutable and can't be reinitialized");
    }

    @Override
    public void updateWithOrphaning(GL gl, Buffer buffer, long sizeBytes) {
        throw new UnsupportedOperationException("This buffer is immutable and can't be reinitialized");
    }

    @Override
    public long size() {
        return this.sizeBytes;
    }

    private void ensureCapacity(GL gl, long neededBytes) {
        if (this.sizeBytes < neededBytes) {
            throw new UnsupportedOperationException("This buffer is immutable and needed capacity (" + neededBytes + ") is not enough. Size = " + this.sizeBytes);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.sizeBytes != -1L;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isBound(GL gl) {
        return gl.getBoundBuffer(this.type) == this.id;
    }

    @Override
    public int getUsageFlags() {
        return this.flags;
    }

    @Override
    public long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public void destroy(GL gl) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("You should initialize the buffer first!");
        }
        gl.glDeleteBuffers(1, new int[]{this.id}, 0);
        this.sizeBytes = -1L;
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

