/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.util;

import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.TileRenderer;
import com.jogamp.opengl.util.awt.ImageUtil;
import com.jogamp.opengl.util.texture.TextureData;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.CancellationException;
import java.util.function.BooleanSupplier;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.joml.Vector2fc;

public class ScreenshotTaker {
    public static int getMaxScaleFactor(int viewportWidth, int viewportHeight, boolean transparentBackground) {
        int bytesPerPixel = transparentBackground ? 4 : 3;
        long maxTotalPixels = Integer.MAX_VALUE / bytesPerPixel;
        long baseTilePixels = (long)viewportWidth * (long)viewportHeight;
        return (int)Math.sqrt((double)maxTotalPixels / (double)baseTilePixels);
    }

    public static BufferedImage takeSimpleScreenshot(GL gl, int width, int height, boolean transparentBackground) {
        int[] pixelData = new int[width * height];
        IntBuffer buffer = IntBuffer.wrap(pixelData);
        gl.getGL3ES3().glReadBuffer(1029);
        gl.glPixelStorei(3333, 1);
        gl.glReadPixels(0, 0, width, height, 32993, 33639, (Buffer)buffer);
        for (int y = 0; y < height / 2; ++y) {
            int topRowStart = y * width;
            int bottomRowStart = (height - 1 - y) * width;
            for (int x = 0; x < width; ++x) {
                int temp = pixelData[topRowStart + x];
                pixelData[topRowStart + x] = pixelData[bottomRowStart + x];
                pixelData[bottomRowStart + x] = temp;
            }
        }
        BufferedImage screenshot = new BufferedImage(width, height, transparentBackground ? 2 : 1);
        screenshot.setRGB(0, 0, width, height, pixelData, 0, width);
        return screenshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage takeTiledScreenshot(VizEngine<JOGLRenderingTarget, NEWTEvent> engine, int scaleFactor, final boolean transparentBackground, BooleanSupplier isCancelled) {
        float originalZoom = engine.getZoom();
        Vector2fc originalPan = engine.getRenderingOptions().getPan();
        GLAutoDrawable drawable = engine.getRenderingTarget().getDrawable();
        int tileWidth = drawable.getSurfaceWidth();
        int tileHeight = drawable.getSurfaceHeight();
        long imageWidthLong = (long)tileWidth * (long)scaleFactor;
        long imageHeightLong = (long)tileHeight * (long)scaleFactor;
        if (imageWidthLong > Integer.MAX_VALUE || imageHeightLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Image dimensions too large: %dx%d (scale factor: %d). Maximum dimension is %d.", imageWidthLong, imageHeightLong, scaleFactor, Integer.MAX_VALUE));
        }
        long totalPixels = imageWidthLong * imageHeightLong;
        int bytesPerPixel = transparentBackground ? 4 : 3;
        long totalBytes = totalPixels * (long)bytesPerPixel;
        if (totalBytes > Integer.MAX_VALUE) {
            int maxScaleFactor = ScreenshotTaker.getMaxScaleFactor(tileWidth, tileHeight, transparentBackground);
            throw new IllegalArgumentException(String.format("Scale factor %d is too large for %dx%d viewport. Maximum scale factor: %d", scaleFactor, tileWidth, tileHeight, maxScaleFactor));
        }
        final int imageWidth = (int)imageWidthLong;
        final int imageHeight = (int)imageHeightLong;
        final TileRenderer renderer = new TileRenderer();
        renderer.setImageSize(imageWidth, imageHeight);
        renderer.setTileSize(tileWidth, tileHeight, 0);
        renderer.attachAutoDrawable(drawable);
        final GLPixelBuffer.GLPixelBufferProvider pixelBufferProvider = GLPixelBuffer.defaultProviderWithRowStride;
        final boolean[] flipVertically = new boolean[]{false};
        GLEventListener preTileGLEL = new GLEventListener(){

            public void init(GLAutoDrawable drawable) {
                GL gl = drawable.getGL();
                PixelFormat.Composition hostPixelComp = pixelBufferProvider.getHostPixelComp(gl.getGLProfile(), transparentBackground ? 4 : 3);
                GLPixelBuffer.GLPixelAttributes pixelAttribs = pixelBufferProvider.getAttributes(gl, transparentBackground ? 4 : 3, true);
                GLPixelBuffer pixelBuffer = pixelBufferProvider.allocate(gl, hostPixelComp, pixelAttribs, true, imageWidth, imageHeight, 1, 0);
                renderer.setImageBuffer(pixelBuffer);
                flipVertically[0] = !drawable.isGLOriented();
            }

            public void dispose(GLAutoDrawable drawable) {
            }

            public void display(GLAutoDrawable drawable) {
            }

            public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            }
        };
        renderer.setGLEventListener(preTileGLEL, null);
        float[] backgroundColor = engine.getBackgroundColor();
        if (transparentBackground) {
            backgroundColor[3] = 0.0f;
            engine.setBackgroundColor(backgroundColor);
        }
        try {
            while (!renderer.eot()) {
                renderer.display();
                engine.setZoom(originalZoom);
                engine.setTranslate(originalPan);
                if (!isCancelled.getAsBoolean()) continue;
                break;
            }
        }
        finally {
            renderer.detachAutoDrawable();
            engine.setZoom(originalZoom);
            engine.setTranslate(originalPan);
            if (transparentBackground) {
                backgroundColor[3] = 1.0f;
                engine.setBackgroundColor(backgroundColor);
            }
        }
        if (isCancelled.getAsBoolean()) {
            throw new CancellationException("Tiled screenshot taking was cancelled.");
        }
        GLPixelBuffer imageBuffer = renderer.getImageBuffer();
        TextureData textureData = new TextureData(drawable.getChosenGLCapabilities().getGLProfile(), transparentBackground ? 6408 : 6407, imageWidth, imageHeight, 0, imageBuffer.pixelAttributes, false, false, flipVertically[0], imageBuffer.buffer, null);
        return ScreenshotTaker.toImage(textureData, isCancelled);
    }

    private static BufferedImage toImage(TextureData data, BooleanSupplier isCancelled) {
        int pixelFormat = data.getPixelFormat();
        int pixelType = data.getPixelType();
        if (!(pixelFormat != 6407 && pixelFormat != 6408 || pixelType != 5120 && pixelType != 5121)) {
            BufferedImage image = new BufferedImage(data.getWidth(), data.getHeight(), pixelFormat == 6407 ? 5 : 6);
            byte[] imageData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            ByteBuffer buf = (ByteBuffer)data.getBuffer();
            if (buf == null) {
                buf = (ByteBuffer)data.getMipmapData()[0];
            }
            buf.rewind();
            buf.get(imageData);
            buf.rewind();
            if (isCancelled.getAsBoolean()) {
                throw new CancellationException("Screenshot conversion to image was cancelled.");
            }
            if (pixelFormat == 6407) {
                for (int i = 0; i < imageData.length; i += 3) {
                    byte blue;
                    byte red = imageData[i];
                    imageData[i] = blue = imageData[i + 2];
                    imageData[i + 2] = red;
                }
            } else {
                for (int i = 0; i < imageData.length; i += 4) {
                    byte alpha;
                    byte red = imageData[i];
                    byte green = imageData[i + 1];
                    byte blue = imageData[i + 2];
                    imageData[i] = alpha = imageData[i + 3];
                    imageData[i + 1] = blue;
                    imageData[i + 2] = green;
                    imageData[i + 3] = red;
                }
            }
            ImageUtil.flipImageVertically((BufferedImage)image);
            if (isCancelled.getAsBoolean()) {
                throw new CancellationException("Screenshot conversion to image was cancelled.");
            }
            return image;
        }
        throw new IllegalArgumentException("Unsupported pixel format/type: " + pixelFormat + "/" + pixelType);
    }
}

