/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.util.ArrayUtils;

public class ManagedDirectBuffer {
    private final int glType;
    private Buffer buffer;
    private int elementsCapacity;

    public ManagedDirectBuffer(int glType, int initialCapacity) {
        this.glType = glType;
        this.elementsCapacity = initialCapacity;
        this.buffer = GLBuffers.newDirectGLBuffer((int)glType, (int)initialCapacity);
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public FloatBuffer floatBuffer() {
        return (FloatBuffer)this.buffer.clear();
    }

    public IntBuffer intBuffer() {
        return (IntBuffer)this.buffer.clear();
    }

    public void ensureCapacity(int elements) {
        if (this.elementsCapacity < elements) {
            int newElementsCapacity = ArrayUtils.getNextPowerOf2(elements);
            Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "Growing managed direct buffer from " + this.elementsCapacity + " to " + newElementsCapacity + " elements");
            Buffer newBuffer = GLBuffers.newDirectGLBuffer((int)this.glType, (int)newElementsCapacity);
            this.buffer.clear();
            GLBuffers.put((Buffer)newBuffer, (Buffer)this.buffer);
            this.buffer = newBuffer;
            this.elementsCapacity = newElementsCapacity;
        }
    }

    public int getElementsCapacity() {
        return this.elementsCapacity;
    }

    public void destroy() {
        if (this.buffer instanceof ByteBuffer) {
            Buffers.Cleaner.clean((ByteBuffer)((ByteBuffer)this.buffer));
        }
    }
}

