/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.text;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.gephi.graph.api.Node;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.pipeline.text.AbstractLabelData;
import org.gephi.viz.engine.jogl.pipeline.text.AbstractLabelUpdater;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphRenderingOptionsImpl;
import org.gephi.viz.engine.util.structure.NodesCallback;

public class NodeLabelUpdater
extends AbstractLabelUpdater<Node> {
    private static final int GRID_SIZE = 15;

    public NodeLabelUpdater(VizEngine engine, AbstractLabelData<Node> labelData) {
        super(engine, labelData);
    }

    @Override
    public void updateWorld(VizEngineModel model) {
        GraphRenderingOptionsImpl options = model.getRenderingOptions();
        if (!options.isShowNodeLabels()) {
            this.labelData.dispose();
            return;
        }
        NodesCallback nodesCallback = (NodesCallback)this.labelData.getElementsCallback();
        boolean someSelection = nodesCallback.hasSelection();
        String[] texts = nodesCallback.getNodesLabelsArray();
        if (texts == null || texts.length == 0) {
            this.labelData.setMaxValidIndex(-1);
            return;
        }
        Node[] nodes = nodesCallback.getNodesArray();
        int maxIndex = nodesCallback.getMaxIndex();
        GraphRenderingOptions.LabelColorMode labelColorMode = options.getNodeLabelColorMode();
        GraphRenderingOptions.LabelSizeMode labelSizeMode = options.getNodeLabelSizeMode();
        float lightenNonSelectedFactor = options.getLightenNonSelectedFactor();
        float nodeLabelScale = options.getNodeLabelScale();
        float fitNodeLabelsToNodeSizeFactor = options.getNodeLabelFitToNodeSizeFactor();
        boolean fitToNodeSize = options.isNodeLabelFitToNodeSize();
        boolean hideNonSelectedLabels = options.isHideNonSelectedNodeLabels();
        boolean avoidOverlap = options.isAvoidNodeLabelOverlap();
        float zoom = options.getZoom();
        float nodeScale = options.getNodeScale();
        if (hideNonSelectedLabels && !someSelection) {
            this.labelData.setMaxValidIndex(-1);
            return;
        }
        this.labelData.ensureLabelBatchesSize(maxIndex);
        this.labelData.ensureTextRenderer(options.getNodeLabelFont(), this.vaoSupported, this.mipMapSupported);
        this.labelData.setMaxValidIndex(maxIndex);
        Int2IntOpenHashMap gridOccupancy = null;
        float gridMinX = 0.0f;
        float gridMinY = 0.0f;
        float gridWidth = 0.0f;
        float gridHeight = 0.0f;
        int gridCols = 0;
        int gridRows = 0;
        if (avoidOverlap) {
            gridMinX = nodesCallback.getMinX() - 15.0f;
            gridMinY = nodesCallback.getMinY() - 15.0f;
            float gridMaxX = nodesCallback.getMaxX() + 15.0f;
            float gridMaxY = nodesCallback.getMaxY() + 15.0f;
            gridWidth = gridMaxX - gridMinX;
            gridHeight = gridMaxY - gridMinY;
            if (gridWidth > 0.0f && gridHeight > 0.0f) {
                gridCols = (int)Math.ceil(gridWidth / 15.0f);
                gridRows = (int)Math.ceil(gridHeight / 15.0f);
                gridOccupancy = new Int2IntOpenHashMap();
                gridOccupancy.defaultReturnValue(-1);
            }
        }
        for (int i = 0; i <= maxIndex; ++i) {
            float finalA;
            float finalB;
            float finalG;
            float finalR;
            boolean selected;
            Node node = nodes[i];
            if (node == null) {
                this.labelData.invalidateBatch(i);
                continue;
            }
            String text = texts[i];
            if (text == null) {
                this.labelData.invalidateBatch(i);
                continue;
            }
            boolean bl = selected = someSelection && nodesCallback.isSelected(i, true);
            if (hideNonSelectedLabels && !selected) {
                this.labelData.invalidateBatch(i);
                continue;
            }
            float baseNodeSizeFactor = fitToNodeSize ? node.size() * fitNodeLabelsToNodeSizeFactor * nodeScale : (float)Math.sqrt(node.getTextProperties().getSize());
            float nodeSizeFactor = baseNodeSizeFactor * (1.0f + node.size() * nodeScale * 1.0E-5f);
            float sizeFactor = nodeLabelScale * nodeSizeFactor;
            if (labelSizeMode.equals((Object)GraphRenderingOptions.LabelSizeMode.SCREEN)) {
                sizeFactor /= zoom;
            }
            int rgba = labelColorMode.equals((Object)GraphRenderingOptions.LabelColorMode.OBJECT) ? node.getRGBA() : node.getTextProperties().getRGBA();
            float r = (float)(rgba >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgba >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgba & 0xFF) / 255.0f;
            float a = (float)(rgba >> 24 & 0xFF) / 255.0f;
            if (someSelection && !selected) {
                float lightColorFactor = 1.0f - lightenNonSelectedFactor;
                finalR = r;
                finalG = g;
                finalB = b;
                finalA = lightColorFactor;
            } else {
                finalR = r;
                finalG = g;
                finalB = b;
                finalA = a;
            }
            AbstractLabelData.LabelBatch batch = this.labelData.updateBatch(node, i, text, sizeFactor, node.x(), node.y(), finalR, finalG, finalB, finalA);
            boolean shouldRender = true;
            if (avoidOverlap && gridOccupancy != null && batch.isWriteValid()) {
                float width = node.getTextProperties().getWidth();
                float height = node.getTextProperties().getHeight();
                if (width > 0.0f && height > 0.0f) {
                    int cellIndex;
                    int col;
                    int row;
                    float labelMinX = node.x() - width * 0.5f;
                    float labelMaxX = node.x() + width * 0.5f;
                    float labelMinY = node.y() - height * 0.5f;
                    float labelMaxY = node.y() + height * 0.5f;
                    int minCol = Math.max(0, (int)((labelMinX - gridMinX) / 15.0f));
                    int maxCol = Math.min(gridCols - 1, (int)((labelMaxX - gridMinX) / 15.0f));
                    int minRow = Math.max(0, (int)((labelMinY - gridMinY) / 15.0f));
                    int maxRow = Math.min(gridRows - 1, (int)((labelMaxY - gridMinY) / 15.0f));
                    for (row = minRow; row <= maxRow && shouldRender; ++row) {
                        for (col = minCol; col <= maxCol && shouldRender; ++col) {
                            AbstractLabelData.LabelBatch occupyingBatch;
                            cellIndex = row * gridCols + col;
                            int occupyingStoreId = gridOccupancy.get(cellIndex);
                            if (occupyingStoreId == -1 || (occupyingBatch = this.labelData.getBatch(occupyingStoreId)) == null || !occupyingBatch.isWriteValid()) continue;
                            float occupyingSizeFactor = occupyingBatch.getWriteScale();
                            if (sizeFactor <= occupyingSizeFactor) {
                                shouldRender = false;
                                continue;
                            }
                            this.labelData.invalidateBatch(occupyingStoreId);
                        }
                    }
                    if (shouldRender) {
                        for (row = minRow; row <= maxRow; ++row) {
                            for (col = minCol; col <= maxCol; ++col) {
                                cellIndex = row * gridCols + col;
                                gridOccupancy.put(cellIndex, i);
                            }
                        }
                    }
                }
            }
            if (shouldRender) continue;
            this.labelData.invalidateBatch(i);
        }
    }

    @Override
    public String getCategory() {
        return "Node label";
    }

    @Override
    public String getName() {
        return "Nodes Labels";
    }
}

