/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.text;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphView;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.pipeline.text.AbstractLabelUpdater;
import org.gephi.viz.engine.jogl.pipeline.text.EdgeLabelData;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphRenderingOptionsImpl;
import org.gephi.viz.engine.util.structure.EdgesCallback;

public class EdgeLabelUpdater
extends AbstractLabelUpdater<Edge> {
    private static final float STROKE_MULTIPLIER = 1.3f;

    public EdgeLabelUpdater(VizEngine engine, EdgeLabelData edgeLabelData) {
        super(engine, edgeLabelData);
    }

    @Override
    public void updateWorld(VizEngineModel model) {
        GraphRenderingOptionsImpl options = model.getRenderingOptions();
        GraphView view = model.getGraphModel().getVisibleView();
        if (!options.isShowEdgeLabels()) {
            this.labelData.dispose();
            return;
        }
        EdgesCallback edgesCallback = (EdgesCallback)this.labelData.getElementsCallback();
        boolean someSelection = edgesCallback.hasSelection();
        String[] texts = edgesCallback.getEdgeLabelsArray();
        if (texts == null || texts.length == 0) {
            this.labelData.setMaxValidIndex(-1);
            return;
        }
        Edge[] edges = edgesCallback.getEdgesArray();
        int maxIndex = edgesCallback.getMaxIndex();
        GraphRenderingOptions.LabelColorMode labelColorMode = options.getEdgeLabelColorMode();
        GraphRenderingOptions.LabelSizeMode labelSizeMode = options.getEdgeLabelSizeMode();
        GraphRenderingOptions.EdgeColorMode edgeColorMode = options.getEdgeColorMode();
        float lightenNonSelectedFactor = options.getLightenNonSelectedFactor();
        float edgeLabelScale = options.getEdgeLabelScale();
        float nodeScale = options.getNodeScale();
        boolean hideNonSelectedLabels = options.isHideNonSelectedEdgeLabels();
        float zoom = options.getZoom();
        float edgeScale = options.getEdgeScale();
        float edgeRescaleMin = options.getEdgeRescaleMin();
        float edgeRescaleMax = options.getEdgeRescaleMax();
        float minWeight = edgesCallback.getMinWeight();
        float maxWeight = edgesCallback.getMaxWeight();
        if (hideNonSelectedLabels && !someSelection) {
            this.labelData.setMaxValidIndex(-1);
            return;
        }
        this.labelData.ensureLabelBatchesSize(maxIndex);
        this.labelData.ensureTextRenderer(options.getEdgeLabelFont(), this.vaoSupported, this.mipMapSupported);
        this.labelData.setMaxValidIndex(maxIndex);
        for (int i = 0; i <= maxIndex; ++i) {
            float y;
            float x;
            float finalA;
            float finalB;
            float finalG;
            float finalR;
            boolean selected;
            Edge edge = edges[i];
            if (edge == null) {
                this.labelData.invalidateBatch(i);
                continue;
            }
            String text = texts[i];
            if (text == null) {
                this.labelData.invalidateBatch(i);
                continue;
            }
            boolean bl = selected = someSelection && edgesCallback.isSelected(i);
            if (hideNonSelectedLabels && !selected) {
                this.labelData.invalidateBatch(i);
                continue;
            }
            float edgeSizeFactor = (float)Math.sqrt(edge.getTextProperties().getSize());
            float sizeFactor = edgeLabelScale * edgeSizeFactor;
            if (labelSizeMode.equals((Object)GraphRenderingOptions.LabelSizeMode.SCREEN)) {
                sizeFactor /= zoom;
            }
            int rgba = labelColorMode.equals((Object)GraphRenderingOptions.LabelColorMode.OBJECT) ? this.getEdgeColor(edge, edgeColorMode) : edge.getTextProperties().getRGBA();
            float r = (float)(rgba >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgba >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgba & 0xFF) / 255.0f;
            float a = (float)(rgba >> 24 & 0xFF) / 255.0f;
            if (someSelection && !selected) {
                float lightColorFactor = 1.0f - lightenNonSelectedFactor;
                finalR = r;
                finalG = g;
                finalB = b;
                finalA = lightColorFactor;
            } else {
                finalR = r;
                finalG = g;
                finalB = b;
                finalA = a;
            }
            float sourceSize = edge.getSource().size() * nodeScale;
            float targetSize = edge.getTarget().size() * nodeScale;
            float dx = edge.getTarget().x() - edge.getSource().x();
            float dy = edge.getTarget().y() - edge.getSource().y();
            float edgeLength = (float)Math.sqrt(dx * dx + dy * dy);
            if (edge.isSelfLoop()) {
                float weight = (float)edge.getWeight(view);
                float thickness = this.edgeThickness(edgeScale * edgeRescaleMin, edgeScale * edgeRescaleMax, weight, minWeight, maxWeight);
                float strokeWidth = thickness * 1.3f;
                float loopRadius = sourceSize * 0.5f + strokeWidth * 0.33f;
                float cos45 = 0.707f;
                x = edge.getSource().x() + loopRadius * 1.707f;
                y = edge.getSource().y() + loopRadius * 1.707f;
            } else if (edgeLength > 0.0f) {
                float ndx = dx / edgeLength;
                float ndy = dy / edgeLength;
                if (edge.isDirected()) {
                    offsetFromSource = sourceSize + (edgeLength - sourceSize - targetSize) * 2.0f / 3.0f;
                    x = edge.getSource().x() + ndx * offsetFromSource;
                    y = edge.getSource().y() + ndy * offsetFromSource;
                } else {
                    offsetFromSource = sourceSize + (edgeLength - sourceSize - targetSize) * 0.5f;
                    x = edge.getSource().x() + ndx * offsetFromSource;
                    y = edge.getSource().y() + ndy * offsetFromSource;
                }
            } else {
                x = edge.getSource().x();
                y = edge.getSource().y();
            }
            this.labelData.updateBatch(edge, i, text, sizeFactor, x, y, finalR, finalG, finalB, finalA);
        }
    }

    private int getEdgeColor(Edge edge, GraphRenderingOptions.EdgeColorMode edgeColorMode) {
        switch (edgeColorMode) {
            case SOURCE: {
                return edge.getSource().getRGBA();
            }
            case TARGET: {
                return edge.getTarget().getRGBA();
            }
            case MIXED: {
                int s = edge.getSource().getRGBA();
                int t = edge.getTarget().getRGBA();
                if (s == t) {
                    return s;
                }
                int b0 = (s & 0xFF) + (t & 0xFF);
                int b1 = (s >>> 8 & 0xFF) + (t >>> 8 & 0xFF);
                int b2 = (s >>> 16 & 0xFF) + (t >>> 16 & 0xFF);
                int b3 = (s >>> 24 & 0xFF) + (t >>> 24 & 0xFF);
                return b3 >>> 1 << 24 | b2 >>> 1 << 16 | b1 >>> 1 << 8 | b0 >>> 1;
            }
        }
        return edge.getRGBA();
    }

    private float edgeThickness(float edgeScaleMin, float edgeScaleMax, float weight, float minWeight, float maxWeight) {
        if (Math.abs(edgeScaleMin - edgeScaleMax) < 0.001f) {
            return weight * edgeScaleMin;
        }
        float weightDivisor = maxWeight - minWeight;
        if (Math.abs(weightDivisor) < 0.001f) {
            weightDivisor = 1.0f;
        }
        float t = (weight - minWeight) / weightDivisor;
        t = Math.max(0.0f, Math.min(1.0f, t));
        return edgeScaleMin + (edgeScaleMax - edgeScaleMin) * t;
    }

    @Override
    public String getCategory() {
        return "Edge label";
    }

    @Override
    public String getName() {
        return "Edges Labels";
    }
}

