/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.text;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.util.texture.TextureCoords;
import java.util.EnumSet;
import java.util.List;
import jogamp.text.TextRenderer;
import jogamp.text.util.Glyph;
import org.gephi.graph.api.Element;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.pipeline.common.LabelWorldData;
import org.gephi.viz.engine.jogl.pipeline.text.AbstractLabelData;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.spi.Renderer;

public abstract class AbstractLabelRenderer<E extends Element>
implements Renderer<JOGLRenderingTarget, LabelWorldData> {
    public static final EnumSet<RenderingLayer> LAYERS = EnumSet.of(RenderingLayer.FRONT1);
    private final VizEngine engine;
    private final AbstractLabelData<E> labelData;
    private TextRenderer textRenderer;
    private final float[] mvp = new float[16];

    public AbstractLabelRenderer(VizEngine engine, AbstractLabelData<E> labelData) {
        this.engine = engine;
        this.labelData = labelData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
    }

    @Override
    public void dispose(JOGLRenderingTarget target) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
            this.textRenderer = null;
        }
    }

    @Override
    public LabelWorldData worldUpdated(VizEngineModel model, JOGLRenderingTarget target) {
        this.labelData.swapBuffers();
        return new LabelWorldData(this.labelData.getTextRenderer(), this.labelData.getLabelBatches(), this.labelData.getMaxValidIndex());
    }

    @Override
    public void render(LabelWorldData data, JOGLRenderingTarget target, RenderingLayer layer) {
        if (this.textRenderer != null && data.getTextRenderer() != null && this.textRenderer != data.getTextRenderer()) {
            this.textRenderer.dispose();
        }
        if (data.getTextRenderer() == null) {
            if (this.textRenderer != null) {
                this.textRenderer.dispose();
                this.textRenderer = null;
            }
            return;
        }
        this.textRenderer = data.getTextRenderer();
        AbstractLabelData.LabelBatch[] batches = data.getLabelBatches();
        int maxIndex = data.getMaxIndex();
        if (batches == null || batches.length == 0 || maxIndex < 0) {
            return;
        }
        this.engine.getModelViewProjectionMatrixFloats(this.mvp);
        GL gl = GLContext.getCurrentGL();
        this.textRenderer.begin3DRendering();
        this.textRenderer.setTransform(this.mvp);
        for (int i = 0; i <= maxIndex && i < batches.length; ++i) {
            List<Glyph> glyphs;
            AbstractLabelData.LabelBatch batch = batches[i];
            if (batch == null || !batch.isValid() || (glyphs = batch.getGlyphs()) == null || glyphs.isEmpty()) continue;
            this.textRenderer.setColor(batch.getR(), batch.getG(), batch.getB(), batch.getA());
            float x = batch.getX();
            float y = batch.getY();
            float scale = batch.getScale();
            for (Glyph glyph : glyphs) {
                if (glyph.location == null) {
                    this.textRenderer.getGlyphCache().upload(glyph);
                }
                TextureCoords coords = this.textRenderer.getGlyphCache().find(glyph);
                float advance = this.textRenderer.getGlyphRenderer().drawGlyph(gl, glyph, x, y, 0.0f, scale, coords);
                x += advance * scale;
            }
        }
        this.textRenderer.end3DRendering();
    }

    @Override
    public EnumSet<RenderingLayer> getLayers() {
        return LAYERS;
    }

    @Override
    public int getOrder() {
        return 200;
    }

    @Override
    public int getPreferenceInCategory() {
        return 0;
    }
}

