/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.text;

import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jogamp.text.TextRenderer;
import jogamp.text.util.Glyph;
import org.gephi.graph.api.Element;
import org.gephi.viz.engine.spi.ElementsCallback;
import org.gephi.viz.engine.util.ArrayUtils;

public abstract class AbstractLabelData<E extends Element> {
    private static final boolean SMOOTHING = true;
    private static final boolean ANTIALIASED = true;
    private static final boolean FRACTIONAL_METRICS = true;
    private static final boolean MIPMAP = true;
    private final ElementsCallback<E> elementsCallback;
    private LabelBatch[] labelBatches = new LabelBatch[0];
    private int maxValidIndex = -1;
    private TextRenderer textRenderer;
    private Font currentFont;

    public AbstractLabelData(ElementsCallback<E> elementsCallback) {
        this.elementsCallback = elementsCallback;
    }

    public ElementsCallback<E> getElementsCallback() {
        return this.elementsCallback;
    }

    public void dispose() {
        this.textRenderer = null;
        this.currentFont = null;
        this.labelBatches = new LabelBatch[0];
        this.maxValidIndex = -1;
    }

    public void ensureTextRenderer(Font font, boolean vaoSupported, boolean mipMapSupported) {
        if (this.textRenderer == null || !font.equals(this.currentFont)) {
            this.textRenderer = new TextRenderer(font, true, true, null, mipMapSupported);
            this.textRenderer.setUseVertexArrays(vaoSupported);
            this.textRenderer.setSmoothing(true);
            this.currentFont = font;
            this.invalidateAllGlyphs();
        }
    }

    private void invalidateAllGlyphs() {
        for (LabelBatch batch : this.labelBatches) {
            if (batch == null) continue;
            batch.invalidateGlyphs();
        }
    }

    public Rectangle2D getTextBounds(String text) {
        if (this.textRenderer == null || text == null || text.isEmpty()) {
            return null;
        }
        return this.textRenderer.getBounds(text);
    }

    public void ensureLabelBatchesSize(int maxStoreId) {
        if (maxStoreId >= this.labelBatches.length) {
            int newSize = ArrayUtils.getNextPowerOf2(maxStoreId + 1);
            LabelBatch[] newArray = new LabelBatch[newSize];
            System.arraycopy(this.labelBatches, 0, newArray, 0, this.labelBatches.length);
            this.labelBatches = newArray;
        }
    }

    public LabelBatch updateBatch(E element, int storeId, String text, float sizeFactor, float nodeX, float nodeY, float r, float g, float b, float a) {
        float ascent;
        float height;
        float width;
        boolean sizeFactorChanged;
        boolean textChanged;
        LabelBatch batch = this.labelBatches[storeId];
        if (batch == null) {
            this.labelBatches[storeId] = batch = new LabelBatch();
        }
        boolean bl = textChanged = !text.equals(batch.writeText);
        if (textChanged) {
            List<Glyph> glyphs = this.textRenderer.getGlyphProducer().createGlyphs(text);
            if (glyphs == null || glyphs.isEmpty()) {
                batch.markInvalid();
                return batch;
            }
            if (batch.writeGlyphs == null) {
                batch.writeGlyphs = new ArrayList<Glyph>(glyphs);
            } else {
                batch.writeGlyphs.clear();
                batch.writeGlyphs.addAll(glyphs);
            }
            batch.writeText = text;
        }
        boolean bl2 = sizeFactorChanged = Math.abs(sizeFactor - batch.writeScale) > 1.0E-4f;
        if (textChanged || sizeFactorChanged) {
            Rectangle2D bounds = this.getTextBounds(text);
            if (bounds == null) {
                batch.markInvalid();
                return batch;
            }
            width = (float)bounds.getWidth() * sizeFactor;
            height = (float)bounds.getHeight() * sizeFactor;
            ascent = (float)(-bounds.getY());
            element.getTextProperties().setDimensions(width, height);
        } else {
            width = element.getTextProperties().getWidth();
            height = element.getTextProperties().getHeight();
            ascent = batch.writeAscent;
        }
        float descentPx = height / sizeFactor - ascent;
        float drawX = nodeX - width * 0.5f;
        float drawY = nodeY - (ascent - descentPx) * sizeFactor * 0.5f;
        batch.writeAscent = ascent;
        batch.writeX = drawX;
        batch.writeY = drawY;
        batch.writeScale = sizeFactor;
        batch.writeR = r;
        batch.writeG = g;
        batch.writeB = b;
        batch.writeA = a;
        batch.writeValid = true;
        return batch;
    }

    public LabelBatch getBatch(int storeId) {
        if (storeId >= 0 && storeId < this.labelBatches.length) {
            return this.labelBatches[storeId];
        }
        return null;
    }

    public void invalidateBatch(int storeId) {
        if (storeId < this.labelBatches.length && this.labelBatches[storeId] != null) {
            this.labelBatches[storeId].markInvalid();
        }
    }

    public void setMaxValidIndex(int maxIndex) {
        this.maxValidIndex = maxIndex;
    }

    public int getMaxValidIndex() {
        return this.maxValidIndex;
    }

    public void swapBuffers() {
        LabelBatch[] batches;
        for (LabelBatch batch : batches = this.labelBatches) {
            if (batch == null) continue;
            batch.swap();
        }
    }

    public LabelBatch[] getLabelBatches() {
        return this.labelBatches;
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public static class LabelBatch {
        private boolean readValid = false;
        private List<Glyph> readGlyphs;
        private float readX;
        private float readY;
        private float readScale;
        private float readR;
        private float readG;
        private float readB;
        private float readA;
        private boolean writeValid = false;
        private List<Glyph> writeGlyphs;
        private String writeText = null;
        private float writeAscent;
        private float writeX;
        private float writeY;
        private float writeScale;
        private float writeR;
        private float writeG;
        private float writeB;
        private float writeA;

        public void swap() {
            this.readValid = this.writeValid;
            if (this.writeValid) {
                if (this.writeGlyphs != null) {
                    if (this.readGlyphs == null) {
                        this.readGlyphs = new ArrayList<Glyph>(this.writeGlyphs);
                    } else {
                        this.readGlyphs.clear();
                        this.readGlyphs.addAll(this.writeGlyphs);
                    }
                } else {
                    this.readGlyphs = null;
                }
                this.readX = this.writeX;
                this.readY = this.writeY;
                this.readScale = this.writeScale;
                this.readR = this.writeR;
                this.readG = this.writeG;
                this.readB = this.writeB;
                this.readA = this.writeA;
            }
        }

        public void markInvalid() {
            this.writeValid = false;
        }

        public void invalidateGlyphs() {
            this.writeText = null;
            this.writeGlyphs = null;
        }

        public boolean isValid() {
            return this.readValid;
        }

        public boolean isWriteValid() {
            return this.writeValid;
        }

        public float getWriteScale() {
            return this.writeScale;
        }

        public List<Glyph> getGlyphs() {
            return this.readGlyphs;
        }

        public float getX() {
            return this.readX;
        }

        public float getY() {
            return this.readY;
        }

        public float getScale() {
            return this.readScale;
        }

        public float getR() {
            return this.readR;
        }

        public float getG() {
            return this.readG;
        }

        public float getB() {
            return this.readB;
        }

        public float getA() {
            return this.readA;
        }
    }
}

