/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.instanced.renderers;

import com.jogamp.newt.event.NEWTEvent;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.availability.InstancedDraw;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractNodeRenderer;
import org.gephi.viz.engine.jogl.pipeline.common.NodeWorldData;
import org.gephi.viz.engine.jogl.pipeline.instanced.InstancedNodeData;
import org.gephi.viz.engine.pipeline.RenderingLayer;

public class NodeRendererInstanced
extends AbstractNodeRenderer {
    private final VizEngine<JOGLRenderingTarget, NEWTEvent> engine;
    private final InstancedNodeData nodeData;
    private final float[] mvpFloats = new float[16];

    public NodeRendererInstanced(VizEngine<JOGLRenderingTarget, NEWTEvent> engine, InstancedNodeData nodeData) {
        this.engine = engine;
        this.nodeData = nodeData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
    }

    @Override
    public NodeWorldData worldUpdated(VizEngineModel model, JOGLRenderingTarget target) {
        this.nodeData.updateBuffers(target.getDrawable().getGL());
        return this.nodeData.createWorldData(model, this.engine);
    }

    @Override
    public void render(NodeWorldData data, JOGLRenderingTarget target, RenderingLayer layer) {
        this.engine.getModelViewProjectionMatrixFloats(this.mvpFloats);
        this.nodeData.drawInstanced(target.getDrawable().getGL().getGL2ES3(), layer, data, this.mvpFloats);
    }

    @Override
    public int getPreferenceInCategory() {
        return InstancedDraw.getPreferenceInCategory();
    }

    @Override
    public String getName() {
        return "Nodes (Instanced)";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return InstancedDraw.isAvailable(this.engine, target.getDrawable());
    }
}

