/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.instanced.renderers;

import com.jogamp.newt.event.NEWTEvent;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.availability.InstancedDraw;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractEdgeRenderer;
import org.gephi.viz.engine.jogl.pipeline.common.EdgeWorldData;
import org.gephi.viz.engine.jogl.pipeline.instanced.InstancedEdgeData;
import org.gephi.viz.engine.pipeline.RenderingLayer;

public class EdgeRendererInstanced
extends AbstractEdgeRenderer {
    private final VizEngine<JOGLRenderingTarget, NEWTEvent> engine;
    private final InstancedEdgeData edgeData;
    private final float[] mvpFloats = new float[16];

    public EdgeRendererInstanced(VizEngine<JOGLRenderingTarget, NEWTEvent> engine, InstancedEdgeData edgeData) {
        this.engine = engine;
        this.edgeData = edgeData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
    }

    @Override
    public EdgeWorldData worldUpdated(VizEngineModel model, JOGLRenderingTarget target) {
        this.edgeData.updateBuffers(target.getDrawable().getGL());
        return this.edgeData.createWorldData(model, this.engine);
    }

    @Override
    public void render(EdgeWorldData data, JOGLRenderingTarget target, RenderingLayer layer) {
        this.engine.getModelViewProjectionMatrixFloats(this.mvpFloats);
        this.edgeData.drawInstanced(target.getDrawable().getGL().getGL3ES3(), layer, data, this.mvpFloats);
    }

    @Override
    public int getPreferenceInCategory() {
        return InstancedDraw.getPreferenceInCategory();
    }

    @Override
    public String getName() {
        return "Edges (Instanced)";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return InstancedDraw.isAvailable(this.engine, target.getDrawable());
    }
}

