/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.instanced;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL2ES3;
import java.nio.FloatBuffer;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractNodeData;
import org.gephi.viz.engine.jogl.pipeline.common.NodeWorldData;
import org.gephi.viz.engine.jogl.util.gl.GLBufferMutable;
import org.gephi.viz.engine.jogl.util.gl.GLFunctions;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.util.structure.NodesCallback;

public class InstancedNodeData
extends AbstractNodeData {
    private final int[] bufferName = new int[3];
    private static final int VERT_BUFFER = 0;
    private static final int ATTRIBS_BUFFER = 1;
    private static final int ATTRIBS_BUFFER_SECONDARY = 2;

    public InstancedNodeData(NodesCallback nodesCallback) {
        super(nodesCallback, true, false);
    }

    public void drawInstanced(GL2ES3 gl, RenderingLayer layer, NodeWorldData data, float[] mvpFloats) {
        this.refreshTime();
        this.drawInstancedInternal(gl, layer, data, mvpFloats);
    }

    private void drawInstancedInternal(GL2ES3 gl, RenderingLayer layer, NodeWorldData data, float[] mvpFloats) {
        int firstVertex;
        int circleVertexCount;
        int instanceCount = this.setupShaderProgramForRenderingLayer((GL2ES2)gl, layer, data, mvpFloats);
        if (instanceCount <= 0) {
            GLFunctions.stopUsingProgram((GL2ES2)gl);
            this.unsetupVertexArrayAttributes((GL2ES2)gl);
            return;
        }
        float maxObservedSize = data.getMaxNodeSize() * data.getZoom();
        if (maxObservedSize > 128.0f) {
            circleVertexCount = this.circleMesh64.vertexCount;
            firstVertex = this.firstVertex64;
        } else if (maxObservedSize > 16.0f) {
            circleVertexCount = this.circleMesh32.vertexCount;
            firstVertex = this.firstVertex32;
        } else if (maxObservedSize > 2.0f) {
            circleVertexCount = this.circleMesh16.vertexCount;
            firstVertex = this.firstVertex16;
        } else {
            circleVertexCount = this.circleMesh8.vertexCount;
            firstVertex = this.firstVertex8;
        }
        GLFunctions.drawInstanced(gl, firstVertex, circleVertexCount, instanceCount);
        GLFunctions.stopUsingProgram((GL2ES2)gl);
        this.unsetupVertexArrayAttributes((GL2ES2)gl);
    }

    @Override
    protected void initBuffers(GL gl) {
        super.initBuffers(gl);
        gl.glGenBuffers(this.bufferName.length, this.bufferName, 0);
        this.initCirclesGLVertexBuffer(gl, this.bufferName[0]);
        this.attributesGLBuffer = new GLBufferMutable(this.bufferName[1], 34962);
        this.attributesGLBuffer.bind(gl);
        this.attributesGLBuffer.init(gl, 524288L, 35048);
        this.attributesGLBuffer.unbind(gl);
        this.attributesGLBufferSecondary = new GLBufferMutable(this.bufferName[2], 34962);
        this.attributesGLBufferSecondary.bind(gl);
        this.attributesGLBufferSecondary.init(gl, 524288L, 35048);
        this.attributesGLBufferSecondary.unbind(gl);
    }

    public void updateBuffers(GL gl) {
        FloatBuffer buf = this.attributesBuffer.floatBuffer();
        buf.limit(this.instanceCounter.unselectedCount * 4);
        buf.position(0);
        this.attributesGLBufferSecondary.bind(gl);
        this.attributesGLBufferSecondary.updateWithOrphaning(gl, buf);
        this.attributesGLBufferSecondary.unbind(gl);
        int offset = buf.limit();
        buf.limit(offset + this.instanceCounter.selectedCount * 4);
        buf.position(offset);
        this.attributesGLBuffer.bind(gl);
        this.attributesGLBuffer.updateWithOrphaning(gl, buf);
        this.attributesGLBuffer.unbind(gl);
        this.instanceCounter.promoteCountToDraw();
    }
}

