/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.instanced;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GL3ES3;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.FloatBuffer;
import org.gephi.graph.api.Edge;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractEdgeData;
import org.gephi.viz.engine.jogl.pipeline.common.EdgeWorldData;
import org.gephi.viz.engine.jogl.util.gl.GLBufferMutable;
import org.gephi.viz.engine.jogl.util.gl.GLFunctions;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.util.structure.EdgesCallback;
import org.gephi.viz.engine.util.structure.NodesCallback;

public class InstancedEdgeData
extends AbstractEdgeData {
    private final int[] bufferName = new int[9];
    private static final int VERT_BUFFER_UNDIRECTED = 0;
    private static final int VERT_BUFFER_DIRECTED = 1;
    private static final int ATTRIBS_BUFFER_UNDIRECTED = 2;
    private static final int ATTRIBS_BUFFER_UNDIRECTED_SECONDARY = 3;
    private static final int ATTRIBS_BUFFER_DIRECTED = 4;
    private static final int ATTRIBS_BUFFER_DIRECTED_SECONDARY = 5;
    private static final int VERT_BUFFER_SELF_LOOP = 6;
    private static final int ATTRIBS_BUFFER_SELF_LOOP = 7;
    private static final int ATTRIBS_BUFFER_SELF_LOOP_SECONDARY = 8;

    public InstancedEdgeData(EdgesCallback edgesCallback, NodesCallback nodesCallback) {
        super(edgesCallback, nodesCallback, true, true);
    }

    public void drawInstanced(GL3ES3 gl, RenderingLayer layer, EdgeWorldData data, float[] mvpFloats) {
        this.refreshTime();
        if (this.edgesCallback.hasSelfLoop()) {
            this.drawSelfLoop(gl, data, layer, mvpFloats);
        }
        this.drawUndirected(gl, data, layer, mvpFloats);
        this.drawDirected(gl, data, layer, mvpFloats);
    }

    private void drawSelfLoop(GL3ES3 gl, EdgeWorldData data, RenderingLayer layer, float[] mvpFloats) {
        int instanceCount = this.setupShaderProgramForRenderingLayerSelfLoop((GL2ES2)gl, layer, data, mvpFloats);
        GLFunctions.drawInstanced((GL2ES3)gl, 0, this.selfLoopMesh.vertexCount, instanceCount);
        GLFunctions.stopUsingProgram((GL2ES2)gl);
        this.unsetupSelfLoopVertexArrayAttributes((GL2ES2)gl);
    }

    private void drawUndirected(GL3ES3 gl, EdgeWorldData data, RenderingLayer layer, float[] mvpFloats) {
        int instanceCount = this.setupShaderProgramForRenderingLayerUndirected((GL2ES2)gl, layer, data, mvpFloats);
        GLFunctions.drawInstanced((GL2ES3)gl, 0, 6, instanceCount);
        GLFunctions.stopUsingProgram((GL2ES2)gl);
        this.unsetupUndirectedVertexArrayAttributes((GL2ES2)gl);
    }

    private void drawDirected(GL3ES3 gl, EdgeWorldData data, RenderingLayer layer, float[] mvpFloats) {
        int instanceCount = this.setupShaderProgramForRenderingLayerDirected((GL2ES2)gl, layer, data, mvpFloats);
        GLFunctions.drawInstanced((GL2ES3)gl, 0, 9, instanceCount);
        GLFunctions.stopUsingProgram((GL2ES2)gl);
        this.unsetupDirectedVertexArrayAttributes((GL2ES2)gl);
    }

    @Override
    protected void initBuffers(GL gl) {
        super.initBuffers(gl);
        gl.glGenBuffers(this.bufferName.length, this.bufferName, 0);
        FloatBuffer undirectedVertexData = GLBuffers.newDirectFloatBuffer((float[])this.undirectedEdgeMesh.vertexData);
        this.vertexGLBufferUndirected = new GLBufferMutable(this.bufferName[0], 34962);
        this.vertexGLBufferUndirected.bind(gl);
        this.vertexGLBufferUndirected.init(gl, undirectedVertexData, 35044);
        this.vertexGLBufferUndirected.unbind(gl);
        FloatBuffer directedVertexData = GLBuffers.newDirectFloatBuffer((float[])this.directedEdgeMesh.vertexData);
        this.vertexGLBufferDirected = new GLBufferMutable(this.bufferName[1], 34962);
        this.vertexGLBufferDirected.bind(gl);
        this.vertexGLBufferDirected.init(gl, directedVertexData, 35044);
        this.vertexGLBufferDirected.unbind(gl);
        FloatBuffer selfLoopVertexData = GLBuffers.newDirectFloatBuffer((float[])this.selfLoopMesh.vertexData);
        this.vertexGLBufferSelfLoop = new GLBufferMutable(this.bufferName[6], 34962);
        this.vertexGLBufferSelfLoop.bind(gl);
        this.vertexGLBufferSelfLoop.init(gl, selfLoopVertexData, 35044);
        this.vertexGLBufferSelfLoop.unbind(gl);
        this.attributesGLBufferDirected = new GLBufferMutable(this.bufferName[4], 34962);
        this.attributesGLBufferDirected.bind(gl);
        this.attributesGLBufferDirected.init(gl, (long)ATTRIBS_STRIDE * 4L * 32768L, 35048);
        this.attributesGLBufferDirected.unbind(gl);
        this.attributesGLBufferDirectedSecondary = new GLBufferMutable(this.bufferName[5], 34962);
        this.attributesGLBufferDirectedSecondary.bind(gl);
        this.attributesGLBufferDirectedSecondary.init(gl, (long)ATTRIBS_STRIDE * 4L * 32768L, 35048);
        this.attributesGLBufferDirectedSecondary.unbind(gl);
        this.attributesGLBufferUndirected = new GLBufferMutable(this.bufferName[2], 34962);
        this.attributesGLBufferUndirected.bind(gl);
        this.attributesGLBufferUndirected.init(gl, (long)ATTRIBS_STRIDE * 4L * 32768L, 35048);
        this.attributesGLBufferUndirected.unbind(gl);
        this.attributesGLBufferUndirectedSecondary = new GLBufferMutable(this.bufferName[3], 34962);
        this.attributesGLBufferUndirectedSecondary.bind(gl);
        this.attributesGLBufferUndirectedSecondary.init(gl, (long)ATTRIBS_STRIDE * 4L * 32768L, 35048);
        this.attributesGLBufferUndirectedSecondary.unbind(gl);
        this.attributesGLBufferSelfLoop = new GLBufferMutable(this.bufferName[7], 34962);
        this.attributesGLBufferSelfLoop.bind(gl);
        this.attributesGLBufferSelfLoop.init(gl, 163840L, 35048);
        this.attributesGLBufferSelfLoop.unbind(gl);
        this.attributesGLBufferSelfLoopSecondary = new GLBufferMutable(this.bufferName[8], 34962);
        this.attributesGLBufferSelfLoopSecondary.bind(gl);
        this.attributesGLBufferSelfLoopSecondary.init(gl, 163840L, 35048);
        this.attributesGLBufferSelfLoopSecondary.unbind(gl);
    }

    public void updateBuffers(GL gl) {
        FloatBuffer buf = this.attributesBuffer.floatBuffer();
        buf.limit(this.undirectedInstanceCounter.unselectedCount * ATTRIBS_STRIDE);
        buf.position(0);
        this.attributesGLBufferUndirectedSecondary.bind(gl);
        this.attributesGLBufferUndirectedSecondary.updateWithOrphaning(gl, buf);
        this.attributesGLBufferUndirectedSecondary.unbind(gl);
        int offset = buf.limit();
        buf.limit(offset + this.undirectedInstanceCounter.selectedCount * ATTRIBS_STRIDE);
        buf.position(offset);
        this.attributesGLBufferUndirected.bind(gl);
        this.attributesGLBufferUndirected.updateWithOrphaning(gl, buf);
        this.attributesGLBufferUndirected.unbind(gl);
        offset = buf.limit();
        buf.limit(offset + this.directedInstanceCounter.unselectedCount * ATTRIBS_STRIDE);
        buf.position(offset);
        this.attributesGLBufferDirectedSecondary.bind(gl);
        this.attributesGLBufferDirectedSecondary.updateWithOrphaning(gl, buf);
        this.attributesGLBufferDirectedSecondary.unbind(gl);
        offset = buf.limit();
        buf.limit(offset + this.directedInstanceCounter.selectedCount * ATTRIBS_STRIDE);
        buf.position(offset);
        this.attributesGLBufferDirected.bind(gl);
        this.attributesGLBufferDirected.updateWithOrphaning(gl, buf);
        this.attributesGLBufferDirected.unbind(gl);
        if (this.edgesCallback.hasSelfLoop()) {
            FloatBuffer selfLoopBuf = this.selfLoopAttributesBuffer.floatBuffer();
            selfLoopBuf.limit(this.selfLoopCounter.unselectedCount * 5);
            selfLoopBuf.position(0);
            this.attributesGLBufferSelfLoopSecondary.bind(gl);
            this.attributesGLBufferSelfLoopSecondary.updateWithOrphaning(gl, selfLoopBuf);
            this.attributesGLBufferSelfLoopSecondary.unbind(gl);
            offset = selfLoopBuf.limit();
            selfLoopBuf.limit(offset + this.selfLoopCounter.selectedCount * 5);
            selfLoopBuf.position(offset);
            this.attributesGLBufferSelfLoop.bind(gl);
            this.attributesGLBufferSelfLoop.updateWithOrphaning(gl, selfLoopBuf);
            this.attributesGLBufferSelfLoop.unbind(gl);
        }
        this.undirectedInstanceCounter.promoteCountToDraw();
        this.directedInstanceCounter.promoteCountToDraw();
        this.selfLoopCounter.promoteCountToDraw();
    }

    @Override
    protected void updateData(GraphSelection selection) {
        int totalEdges = this.edgesCallback.getCount();
        this.attributesBuffer.ensureCapacity(totalEdges * ATTRIBS_STRIDE);
        FloatBuffer attribsDirectBuffer = this.attributesBuffer.floatBuffer();
        Edge[] visibleEdgesArray = this.edgesCallback.getEdgesArray();
        float[] edgeWeightsArray = this.edgesCallback.getEdgeWeightsArray();
        int maxIndex = this.edgesCallback.getMaxIndex();
        boolean isDirected = this.edgesCallback.isDirected();
        boolean isUndirected = this.edgesCallback.isUndirected();
        boolean hasSelfLoop = this.edgesCallback.hasSelfLoop();
        if (hasSelfLoop) {
            this.selfLoopAttributesBuffer.ensureCapacity(totalEdges * 5);
            FloatBuffer attribsSelfLoopBuffer = this.selfLoopAttributesBuffer.floatBuffer();
            this.updateSelfLoop(maxIndex, visibleEdgesArray, edgeWeightsArray, this.selfLoopAttributesBufferBatch, 0, attribsSelfLoopBuffer);
        } else {
            this.selfLoopCounter.clearCount();
        }
        this.updateUndirectedData(isDirected, maxIndex, visibleEdgesArray, edgeWeightsArray, this.attributesBufferBatch, 0, attribsDirectBuffer);
        this.updateDirectedData(isUndirected, maxIndex, visibleEdgesArray, edgeWeightsArray, this.attributesBufferBatch, 0, attribsDirectBuffer);
    }

    @Override
    public void dispose(GL gl) {
        super.dispose(gl);
        this.attributesBufferBatch = null;
        this.selfLoopAttributesBufferBatch = null;
        if (this.attributesBuffer != null) {
            this.attributesBuffer.destroy();
            this.attributesBuffer = null;
        }
        if (this.selfLoopAttributesBuffer != null) {
            this.selfLoopAttributesBuffer.destroy();
            this.selfLoopAttributesBuffer = null;
        }
    }
}

