/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.indirect.updaters;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import org.gephi.graph.api.Node;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.availability.IndirectDraw;
import org.gephi.viz.engine.jogl.pipeline.indirect.IndirectNodeData;
import org.gephi.viz.engine.spi.ElementsCallback;
import org.gephi.viz.engine.spi.WorldUpdater;

public class NodesUpdaterIndirectRendering
implements WorldUpdater<JOGLRenderingTarget, Node> {
    private final VizEngine engine;
    private final IndirectNodeData nodeData;

    public NodesUpdaterIndirectRendering(VizEngine engine, IndirectNodeData nodeData) {
        this.engine = engine;
        this.nodeData = nodeData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
        this.nodeData.init((GL2ES2)target.getDrawable().getGL().getGL4());
    }

    @Override
    public void dispose(JOGLRenderingTarget target) {
        this.nodeData.dispose((GL)target.getDrawable().getGL().getGL4());
    }

    @Override
    public void updateWorld(VizEngineModel model) {
        this.nodeData.update(model.getRenderingOptions());
    }

    @Override
    public ElementsCallback<Node> getElementsCallback() {
        return this.nodeData.getNodesCallback();
    }

    @Override
    public String getCategory() {
        return "Node";
    }

    @Override
    public int getPreferenceInCategory() {
        return IndirectDraw.getPreferenceInCategory();
    }

    @Override
    public String getName() {
        return "Nodes (Indirect)";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return IndirectDraw.isAvailable(this.engine, target.getDrawable());
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

