/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.indirect.renderers;

import com.jogamp.newt.event.NEWTEvent;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.availability.IndirectDraw;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractNodeRenderer;
import org.gephi.viz.engine.jogl.pipeline.common.NodeWorldData;
import org.gephi.viz.engine.jogl.pipeline.indirect.IndirectNodeData;
import org.gephi.viz.engine.pipeline.RenderingLayer;

public class NodeRendererIndirect
extends AbstractNodeRenderer {
    private final VizEngine<JOGLRenderingTarget, NEWTEvent> engine;
    private final IndirectNodeData nodeData;
    private final float[] mvpFloats = new float[16];

    public NodeRendererIndirect(VizEngine<JOGLRenderingTarget, NEWTEvent> engine, IndirectNodeData nodeData) {
        this.engine = engine;
        this.nodeData = nodeData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
    }

    @Override
    public NodeWorldData worldUpdated(VizEngineModel model, JOGLRenderingTarget target) {
        this.nodeData.updateBuffers(target.getDrawable().getGL().getGL4());
        return this.nodeData.createWorldData(model, this.engine);
    }

    @Override
    public void render(NodeWorldData data, JOGLRenderingTarget target, RenderingLayer layer) {
        this.engine.getModelViewProjectionMatrixFloats(this.mvpFloats);
        this.nodeData.drawIndirect(target.getDrawable().getGL().getGL4(), layer, data, this.mvpFloats);
    }

    @Override
    public int getPreferenceInCategory() {
        return IndirectDraw.getPreferenceInCategory();
    }

    @Override
    public String getName() {
        return "Nodes (Indirect)";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return IndirectDraw.isAvailable(this.engine, target.getDrawable());
    }
}

