/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.indirect;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL4;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractNodeData;
import org.gephi.viz.engine.jogl.pipeline.common.NodeWorldData;
import org.gephi.viz.engine.jogl.util.gl.GLBufferMutable;
import org.gephi.viz.engine.jogl.util.gl.GLFunctions;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.util.structure.NodesCallback;

public class IndirectNodeData
extends AbstractNodeData {
    private final int[] bufferName = new int[4];
    private static final int VERT_BUFFER = 0;
    private static final int ATTRIBS_BUFFER = 1;
    private static final int ATTRIBS_BUFFER_SECONDARY = 2;
    private static final int INDIRECT_DRAW_BUFFER = 3;

    public IndirectNodeData(NodesCallback nodesCallback) {
        super(nodesCallback, true, true);
    }

    public void drawIndirect(GL4 gl, RenderingLayer layer, NodeWorldData data, float[] mvpFloats) {
        this.refreshTime();
        this.drawIndirectInternal(gl, layer, data, mvpFloats);
    }

    private void drawIndirectInternal(GL4 gl, RenderingLayer layer, NodeWorldData data, float[] mvpFloats) {
        int instanceCount = this.setupShaderProgramForRenderingLayer((GL2ES2)gl, layer, data, mvpFloats);
        if (instanceCount <= 0) {
            GLFunctions.stopUsingProgram((GL2ES2)gl);
            this.unsetupVertexArrayAttributes((GL2ES2)gl);
            return;
        }
        boolean renderingUnselectedNodes = layer.isBack();
        int instancesOffset = renderingUnselectedNodes ? 0 : this.instanceCounter.unselectedCountToDraw;
        this.commandsGLBuffer.bind((GL)gl);
        GLFunctions.drawIndirect(gl, instanceCount, instancesOffset);
        this.commandsGLBuffer.unbind((GL)gl);
        GLFunctions.stopUsingProgram((GL2ES2)gl);
        this.unsetupVertexArrayAttributes((GL2ES2)gl);
    }

    @Override
    protected void initBuffers(GL gl) {
        super.initBuffers(gl);
        gl.glGenBuffers(this.bufferName.length, this.bufferName, 0);
        this.initCirclesGLVertexBuffer(gl, this.bufferName[0]);
        this.attributesGLBuffer = new GLBufferMutable(this.bufferName[1], 34962);
        this.attributesGLBuffer.bind(gl);
        this.attributesGLBuffer.init(gl, 524288L, 35048);
        this.attributesGLBuffer.unbind(gl);
        this.attributesGLBufferSecondary = new GLBufferMutable(this.bufferName[2], 34962);
        this.attributesGLBufferSecondary.bind(gl);
        this.attributesGLBufferSecondary.init(gl, 524288L, 35048);
        this.attributesGLBufferSecondary.unbind(gl);
        this.commandsGLBuffer = new GLBufferMutable(this.bufferName[3], 36671);
        this.commandsGLBuffer.bind(gl);
        this.commandsGLBuffer.init(gl, 524288L, 35048);
        this.commandsGLBuffer.unbind(gl);
    }

    public void updateBuffers(GL4 gl) {
        FloatBuffer buf = this.attributesBuffer.floatBuffer();
        buf.limit(this.instanceCounter.unselectedCount * 4);
        buf.position(0);
        this.attributesGLBufferSecondary.bind((GL)gl);
        this.attributesGLBufferSecondary.updateWithOrphaning((GL)gl, buf);
        this.attributesGLBufferSecondary.unbind((GL)gl);
        int offset = buf.limit();
        buf.limit(offset + this.instanceCounter.selectedCount * 4);
        buf.position(offset);
        this.attributesGLBuffer.bind((GL)gl);
        this.attributesGLBuffer.updateWithOrphaning((GL)gl, buf);
        this.attributesGLBuffer.unbind((GL)gl);
        IntBuffer commandsBufferData = this.commandsBuffer.intBuffer();
        commandsBufferData.position(0);
        commandsBufferData.limit(this.instanceCounter.total() * 4);
        this.commandsGLBuffer.bind((GL)gl);
        this.commandsGLBuffer.updateWithOrphaning((GL)gl, commandsBufferData);
        this.commandsGLBuffer.unbind((GL)gl);
        this.instanceCounter.promoteCountToDraw();
    }
}

