/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.common;

import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.gephi.graph.api.Node;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.models.NodeDiskModel;
import org.gephi.viz.engine.jogl.models.mesh.NodeDiskVertexMeshGenerator;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractSelectionData;
import org.gephi.viz.engine.jogl.pipeline.common.NodeWorldData;
import org.gephi.viz.engine.jogl.util.ManagedDirectBuffer;
import org.gephi.viz.engine.jogl.util.Mesh;
import org.gephi.viz.engine.jogl.util.gl.GLBuffer;
import org.gephi.viz.engine.jogl.util.gl.GLBufferMutable;
import org.gephi.viz.engine.jogl.util.gl.GLVertexArrayObject;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.pipeline.common.InstanceCounter;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.util.ColorUtils;
import org.gephi.viz.engine.util.gl.Constants;
import org.gephi.viz.engine.util.gl.OpenGLOptions;
import org.gephi.viz.engine.util.structure.NodesCallback;

public abstract class AbstractNodeData
extends AbstractSelectionData {
    protected static final int OBSERVED_SIZE_LOD_THRESHOLD_64 = 128;
    protected static final int OBSERVED_SIZE_LOD_THRESHOLD_32 = 16;
    protected static final int OBSERVED_SIZE_LOD_THRESHOLD_16 = 2;
    protected GLBuffer vertexGLBuffer;
    protected GLBuffer attributesGLBuffer;
    protected GLBuffer attributesGLBufferSecondary;
    protected GLBuffer commandsGLBuffer;
    protected final NodesCallback nodesCallback;
    protected static final int ATTRIBS_STRIDE = 4;
    protected final NodeDiskModel diskModel;
    protected final Mesh circleMesh64 = NodeDiskVertexMeshGenerator.generateFilledCircle(64);
    protected final Mesh circleMesh32 = NodeDiskVertexMeshGenerator.generateFilledCircle(32);
    protected final Mesh circleMesh16 = NodeDiskVertexMeshGenerator.generateFilledCircle(16);
    protected final Mesh circleMesh8 = NodeDiskVertexMeshGenerator.generateFilledCircle(8);
    protected final int firstVertex64;
    protected final int firstVertex32;
    protected final int firstVertex16;
    protected final int firstVertex8;
    protected final boolean instancedRendering;
    protected final boolean indirectCommands;
    protected final InstanceCounter instanceCounter = new InstanceCounter();
    protected float maxNodeSize = 0.0f;
    protected float currentNodeScale;
    protected float currentZoom;
    protected static final int BATCH_NODES_SIZE = 32768;
    protected ManagedDirectBuffer attributesBuffer;
    protected float[] attributesBufferBatch;
    protected ManagedDirectBuffer commandsBuffer;
    private int[] commandsBufferBatch;
    private NodesVAO nodesVAO;
    private NodesVAO nodesVAOSecondary;

    public AbstractNodeData(NodesCallback nodesCallback, boolean instancedRendering, boolean indirectCommands) {
        this.startedTime = System.currentTimeMillis();
        this.instancedRendering = instancedRendering;
        this.indirectCommands = indirectCommands;
        this.nodesCallback = nodesCallback;
        this.diskModel = new NodeDiskModel();
        this.firstVertex64 = 0;
        this.firstVertex32 = this.circleMesh64.vertexCount;
        this.firstVertex16 = this.circleMesh64.vertexCount + this.circleMesh32.vertexCount;
        this.firstVertex8 = this.circleMesh64.vertexCount + this.circleMesh32.vertexCount + this.circleMesh16.vertexCount;
    }

    public void init(GL2ES2 gl) {
        this.diskModel.initGLPrograms(gl);
        this.initBuffers((GL)gl);
    }

    protected void initBuffers(GL gl) {
        this.attributesBufferBatch = new float[131072];
        this.attributesBuffer = new ManagedDirectBuffer(5126, 131072);
        if (this.indirectCommands) {
            this.commandsBufferBatch = new int[131072];
            this.commandsBuffer = new ManagedDirectBuffer(5125, 131072);
        }
    }

    protected void initCirclesGLVertexBuffer(GL gl, int bufferName) {
        float[] circleVertexData = new float[this.circleMesh64.vertexData.length + this.circleMesh32.vertexData.length + this.circleMesh16.vertexData.length + this.circleMesh8.vertexData.length];
        int offset = 0;
        System.arraycopy(this.circleMesh64.vertexData, 0, circleVertexData, offset, this.circleMesh64.vertexData.length);
        System.arraycopy(this.circleMesh32.vertexData, 0, circleVertexData, offset += this.circleMesh64.vertexData.length, this.circleMesh32.vertexData.length);
        System.arraycopy(this.circleMesh16.vertexData, 0, circleVertexData, offset += this.circleMesh32.vertexData.length, this.circleMesh16.vertexData.length);
        System.arraycopy(this.circleMesh8.vertexData, 0, circleVertexData, offset += this.circleMesh16.vertexData.length, this.circleMesh8.vertexData.length);
        FloatBuffer circleVertexBuffer = GLBuffers.newDirectFloatBuffer((float[])circleVertexData);
        this.vertexGLBuffer = new GLBufferMutable(bufferName, 34962);
        this.vertexGLBuffer.bind(gl);
        this.vertexGLBuffer.init(gl, circleVertexBuffer, 35044);
        this.vertexGLBuffer.unbind(gl);
    }

    protected int setupShaderProgramForRenderingLayer(GL2ES2 gl, RenderingLayer layer, NodeWorldData data, float[] mvpFloats) {
        int instanceCount;
        float nodeBorderColorFactor;
        boolean someSelection = data.hasSomeSelection();
        boolean renderingUnselectedNodes = layer.isBack();
        if (!someSelection && renderingUnselectedNodes) {
            return 0;
        }
        float[] backgroundColorFloats = data.getBackgroundColor();
        float f = nodeBorderColorFactor = ColorUtils.isColorDark(backgroundColorFloats) ? 1.0f + Constants.getNodeBorderDarkenFactor() : Constants.getNodeBorderDarkenFactor();
        if (renderingUnselectedNodes) {
            instanceCount = this.instanceCounter.unselectedCountToDraw;
            float colorLightenFactor = data.getLightenNonSelectedFactor();
            this.diskModel.useProgramWithSelectionUnselected(gl, mvpFloats, backgroundColorFloats, colorLightenFactor, this.globalTime, this.selectedTime, nodeBorderColorFactor);
            this.setupSecondaryVertexArrayAttributes(gl, data);
        } else {
            instanceCount = this.instanceCounter.selectedCountToDraw;
            if (someSelection) {
                this.diskModel.useProgramWithSelectionSelected(gl, mvpFloats, this.globalTime, this.selectedTime, nodeBorderColorFactor);
            } else {
                this.diskModel.useProgram(gl, mvpFloats, nodeBorderColorFactor);
            }
            this.setupVertexArrayAttributes(gl, data);
        }
        return instanceCount;
    }

    public NodeWorldData createWorldData(VizEngineModel model, VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        return new NodeWorldData(this.someSelection, model.getRenderingOptions().getBackgroundColor(), this.maxNodeSize, this.currentZoom, model.getRenderingOptions().getLightenNonSelectedFactor(), engine.getOpenGLOptions());
    }

    public void update(GraphRenderingOptions renderingOptions) {
        if (!renderingOptions.isShowNodes()) {
            this.instanceCounter.clearCount();
            return;
        }
        this.currentZoom = renderingOptions.getZoom();
        this.currentNodeScale = renderingOptions.getNodeScale();
        Node[] visibleNodesArray = this.nodesCallback.getNodesArray();
        int maxIndex = this.nodesCallback.getMaxIndex();
        int totalNodes = this.nodesCallback.getCount();
        this.someSelection = this.nodesCallback.hasSelection();
        this.attributesBuffer.ensureCapacity(totalNodes * 4);
        if (this.indirectCommands) {
            this.commandsBuffer.ensureCapacity(totalNodes * 4);
        }
        FloatBuffer attribs = this.attributesBuffer.floatBuffer();
        IntBuffer commands = this.indirectCommands ? this.commandsBuffer.intBuffer() : null;
        int newNodesCountUnselected = 0;
        int newNodesCountSelected = 0;
        float newMaxNodeSize = this.nodesCallback.getMaxNodeSize() * this.currentNodeScale;
        int attributesIndex = 0;
        int commandIndex = 0;
        int instanceId = 0;
        if (this.someSelection) {
            boolean selected;
            Node node;
            int j;
            for (j = 0; j <= maxIndex; ++j) {
                node = visibleNodesArray[j];
                if (node == null || (selected = this.nodesCallback.isSelected(j, true))) continue;
                ++newNodesCountUnselected;
                this.fillNodeAttributesData(node, attributesIndex);
                if ((attributesIndex += 4) == this.attributesBufferBatch.length) {
                    attribs.put(this.attributesBufferBatch);
                    attributesIndex = 0;
                }
                if (!this.indirectCommands) continue;
                this.fillNodeCommandData(node, commandIndex, instanceId);
                ++instanceId;
                if ((commandIndex += 4) != this.commandsBufferBatch.length) continue;
                commands.put(this.commandsBufferBatch);
                commandIndex = 0;
            }
            instanceId = 0;
            for (j = 0; j <= maxIndex; ++j) {
                node = visibleNodesArray[j];
                if (node == null || !(selected = this.nodesCallback.isSelected(j, true))) continue;
                ++newNodesCountSelected;
                this.fillNodeAttributesData(node, attributesIndex);
                if ((attributesIndex += 4) == this.attributesBufferBatch.length) {
                    attribs.put(this.attributesBufferBatch);
                    attributesIndex = 0;
                }
                if (!this.indirectCommands) continue;
                this.fillNodeCommandData(node, commandIndex, instanceId);
                ++instanceId;
                if ((commandIndex += 4) != this.commandsBufferBatch.length) continue;
                commands.put(this.commandsBufferBatch);
                commandIndex = 0;
            }
        } else {
            for (int j = 0; j <= maxIndex; ++j) {
                Node node = visibleNodesArray[j];
                if (node == null) continue;
                ++newNodesCountSelected;
                this.fillNodeAttributesData(node, attributesIndex);
                if ((attributesIndex += 4) == this.attributesBufferBatch.length) {
                    attribs.put(this.attributesBufferBatch);
                    attributesIndex = 0;
                }
                if (!this.indirectCommands) continue;
                this.fillNodeCommandData(node, commandIndex, instanceId);
                ++instanceId;
                if ((commandIndex += 4) != this.commandsBufferBatch.length) continue;
                commands.put(this.commandsBufferBatch);
                commandIndex = 0;
            }
        }
        if (attributesIndex > 0) {
            attribs.put(this.attributesBufferBatch, 0, attributesIndex);
        }
        if (this.indirectCommands && commandIndex > 0) {
            commands.put(this.commandsBufferBatch, 0, commandIndex);
        }
        this.instanceCounter.unselectedCount = newNodesCountUnselected;
        this.instanceCounter.selectedCount = newNodesCountSelected;
        this.maxNodeSize = newMaxNodeSize;
    }

    protected void fillNodeAttributesData(Node node, int index) {
        float x = node.x();
        float y = node.y();
        float size = node.size() * this.currentNodeScale;
        int rgba = node.getRGBA();
        this.attributesBufferBatch[index] = x;
        this.attributesBufferBatch[index + 1] = y;
        this.attributesBufferBatch[index + 2] = Float.intBitsToFloat(rgba);
        this.attributesBufferBatch[index + 3] = size;
    }

    protected void fillNodeCommandData(Node node, int index, int instanceId) {
        int firstVertex;
        int circleVertexCount;
        float observedSize = node.size() * this.currentNodeScale * this.currentZoom;
        if (observedSize > 128.0f) {
            circleVertexCount = this.circleMesh64.vertexCount;
            firstVertex = this.firstVertex64;
        } else if (observedSize > 16.0f) {
            circleVertexCount = this.circleMesh32.vertexCount;
            firstVertex = this.firstVertex32;
        } else if (observedSize > 2.0f) {
            circleVertexCount = this.circleMesh16.vertexCount;
            firstVertex = this.firstVertex16;
        } else {
            circleVertexCount = this.circleMesh8.vertexCount;
            firstVertex = this.firstVertex8;
        }
        this.commandsBufferBatch[index] = circleVertexCount;
        this.commandsBufferBatch[index + 1] = 1;
        this.commandsBufferBatch[index + 2] = firstVertex;
        this.commandsBufferBatch[index + 3] = instanceId;
    }

    public void setupVertexArrayAttributes(GL2ES2 gl, NodeWorldData data) {
        if (this.nodesVAO == null) {
            this.nodesVAO = new NodesVAO(data.getOpenGLOptions(), this.vertexGLBuffer, this.attributesGLBuffer);
        }
        this.nodesVAO.use(gl);
    }

    public void setupSecondaryVertexArrayAttributes(GL2ES2 gl, NodeWorldData data) {
        if (this.nodesVAOSecondary == null) {
            this.nodesVAOSecondary = new NodesVAO(data.getOpenGLOptions(), this.vertexGLBuffer, this.attributesGLBufferSecondary);
        }
        this.nodesVAOSecondary.use(gl);
    }

    public void unsetupVertexArrayAttributes(GL2ES2 gl) {
        if (this.nodesVAO != null) {
            this.nodesVAO.stopUsing(gl);
        }
        if (this.nodesVAOSecondary != null) {
            this.nodesVAOSecondary.stopUsing(gl);
        }
    }

    public void dispose(GL gl) {
        this.attributesBufferBatch = null;
        this.commandsBufferBatch = null;
        if (this.attributesBuffer != null) {
            this.attributesBuffer.destroy();
            this.attributesBuffer = null;
        }
        if (this.vertexGLBuffer != null) {
            this.vertexGLBuffer.destroy(gl);
            this.vertexGLBuffer = null;
        }
        if (this.attributesGLBuffer != null) {
            this.attributesGLBuffer.destroy(gl);
            this.attributesGLBuffer = null;
        }
        if (this.attributesGLBufferSecondary != null) {
            this.attributesGLBufferSecondary.destroy(gl);
            this.attributesGLBufferSecondary = null;
        }
        if (this.commandsBuffer != null) {
            this.commandsBuffer.destroy();
            this.commandsBuffer = null;
        }
        if (this.commandsGLBuffer != null) {
            this.commandsGLBuffer.destroy(gl);
            this.commandsGLBuffer = null;
        }
        if (this.nodesVAO != null) {
            this.nodesVAO.destroy(gl.getGL2ES2());
            this.nodesVAO = null;
        }
        if (this.nodesVAOSecondary != null) {
            this.nodesVAOSecondary.destroy(gl.getGL2ES2());
            this.nodesVAOSecondary = null;
        }
        this.diskModel.destroy(gl.getGL2ES2());
        this.nodesCallback.reset();
    }

    public NodesCallback getNodesCallback() {
        return this.nodesCallback;
    }

    private class NodesVAO
    extends GLVertexArrayObject {
        private final GLBuffer vertexBuffer;
        private final GLBuffer attributesBuffer;

        public NodesVAO(OpenGLOptions openGLOptions, GLBuffer vertexBuffer, GLBuffer attributesBuffer) {
            super(openGLOptions);
            this.vertexBuffer = vertexBuffer;
            this.attributesBuffer = attributesBuffer;
        }

        @Override
        protected void configure(GL2ES2 gl) {
            this.vertexBuffer.bind((GL)gl);
            gl.glVertexAttribPointer(0, 2, 5126, false, 0, 0L);
            this.vertexBuffer.unbind((GL)gl);
            if (AbstractNodeData.this.instancedRendering) {
                this.attributesBuffer.bind((GL)gl);
                int stride = 16;
                int offset = 0;
                gl.glVertexAttribPointer(1, 2, 5126, false, 16, (long)offset);
                gl.glVertexAttribPointer(2, 4, 5121, false, 16, (long)(offset += 8));
                gl.glVertexAttribPointer(3, 1, 5126, false, 16, (long)(offset += 4));
                this.attributesBuffer.unbind((GL)gl);
            }
        }

        @Override
        protected int[] getUsedAttributeLocations() {
            if (AbstractNodeData.this.instancedRendering) {
                return new int[]{0, 1, 2, 3};
            }
            return new int[]{0};
        }

        @Override
        protected int[] getInstancedAttributeLocations() {
            if (AbstractNodeData.this.instancedRendering) {
                return new int[]{1, 2, 3};
            }
            return null;
        }
    }
}

