/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.common;

import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import java.nio.FloatBuffer;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Rect2D;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.models.EdgeCircleSelfLoopNoSelection;
import org.gephi.viz.engine.jogl.models.EdgeCircleSelfLoopSelectionSelected;
import org.gephi.viz.engine.jogl.models.EdgeCircleSelfLoopSelectionUnselected;
import org.gephi.viz.engine.jogl.models.EdgeLineModelDirected;
import org.gephi.viz.engine.jogl.models.EdgeLineModelUndirected;
import org.gephi.viz.engine.jogl.models.mesh.EdgeLineMeshGenerator;
import org.gephi.viz.engine.jogl.models.mesh.NodeDiskVertexMeshGenerator;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractSelectionData;
import org.gephi.viz.engine.jogl.pipeline.common.EdgeWorldData;
import org.gephi.viz.engine.jogl.util.ManagedDirectBuffer;
import org.gephi.viz.engine.jogl.util.Mesh;
import org.gephi.viz.engine.jogl.util.gl.GLBuffer;
import org.gephi.viz.engine.jogl.util.gl.GLVertexArrayObject;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.pipeline.common.InstanceCounter;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.structure.GraphIndex;
import org.gephi.viz.engine.util.gl.OpenGLOptions;
import org.gephi.viz.engine.util.structure.EdgesCallback;
import org.gephi.viz.engine.util.structure.NodesCallback;

public abstract class AbstractEdgeData
extends AbstractSelectionData {
    protected final EdgeLineModelUndirected lineModelUndirected = new EdgeLineModelUndirected();
    protected final EdgeLineModelDirected lineModelDirected = new EdgeLineModelDirected();
    protected final EdgeCircleSelfLoopNoSelection edgeCircleSelfLoopNoSelection = new EdgeCircleSelfLoopNoSelection();
    protected final EdgeCircleSelfLoopSelectionSelected edgeCircleSelfLoopSelectionSelected = new EdgeCircleSelfLoopSelectionSelected();
    protected final EdgeCircleSelfLoopSelectionUnselected edgeCircleSelfLoopSelectionUnselected = new EdgeCircleSelfLoopSelectionUnselected();
    protected final InstanceCounter undirectedInstanceCounter = new InstanceCounter();
    protected final InstanceCounter directedInstanceCounter = new InstanceCounter();
    protected final InstanceCounter selfLoopCounter = new InstanceCounter();
    protected final Mesh undirectedEdgeMesh = EdgeLineMeshGenerator.undirectedMeshGenerator();
    protected final Mesh directedEdgeMesh = EdgeLineMeshGenerator.directedMeshGenerator();
    protected final Mesh selfLoopMesh = NodeDiskVertexMeshGenerator.generateFilledCircle(48);
    protected GLBuffer vertexGLBufferUndirected;
    protected GLBuffer vertexGLBufferDirected;
    protected GLBuffer attributesGLBufferDirected;
    protected GLBuffer attributesGLBufferDirectedSecondary;
    protected GLBuffer attributesGLBufferUndirected;
    protected GLBuffer attributesGLBufferUndirectedSecondary;
    public static final int ATTRIBS_STRIDE_SELFLOOP = 5;
    protected GLBuffer vertexGLBufferSelfLoop;
    protected GLBuffer attributesGLBufferSelfLoop;
    protected GLBuffer attributesGLBufferSelfLoopSecondary;
    protected final EdgesCallback edgesCallback;
    protected final NodesCallback nodesCallback;
    protected static final int ATTRIBS_STRIDE = Math.max(8, 8);
    protected static final int VERTEX_COUNT_UNDIRECTED = 6;
    protected static final int VERTEX_COUNT_DIRECTED = 9;
    protected static final int VERTEX_COUNT_MAX = Math.max(9, 6);
    protected final boolean instanced;
    protected final boolean usesSecondaryBuffer;
    protected ManagedDirectBuffer attributesBuffer;
    protected ManagedDirectBuffer selfLoopAttributesBuffer;
    protected float[] attributesBufferBatch;
    protected static final int BATCH_EDGES_SIZE = 32768;
    protected static final int BATCH_SELFLOOP_EDGES_SIZE = 8192;
    protected float[] selfLoopAttributesBufferBatch;
    protected boolean hideNonSelected;
    protected boolean edgeSelectionColor;
    protected boolean edgeWeightEnabled;
    protected float edgeBothSelectionColor;
    protected float edgeOutSelectionColor;
    protected float edgeInSelectionColor;
    protected GraphRenderingOptions.EdgeColorMode edgeColorMode;
    private UndirectedEdgesVAO undirectedEdgesVAO;
    private UndirectedEdgesVAO undirectedEdgesVAOSecondary;
    private DirectedEdgesVAO directedEdgesVAO;
    private DirectedEdgesVAO directedEdgesVAOSecondary;
    private SelfLoopEdgesVAO selfLoopEdgesVAO;
    private SelfLoopEdgesVAO selfLoopEdgesVAOSecondary;

    public AbstractEdgeData(EdgesCallback edgesCallback, NodesCallback nodesCallback, boolean instanced, boolean usesSecondaryBuffer) {
        this.startedTime = System.currentTimeMillis();
        this.edgesCallback = edgesCallback;
        this.nodesCallback = nodesCallback;
        this.instanced = instanced;
        this.usesSecondaryBuffer = usesSecondaryBuffer;
    }

    public void init(GL2ES2 gl) {
        this.edgeCircleSelfLoopNoSelection.initGLPrograms(gl);
        this.edgeCircleSelfLoopSelectionUnselected.initGLPrograms(gl);
        this.edgeCircleSelfLoopSelectionSelected.initGLPrograms(gl);
        this.lineModelDirected.initGLPrograms(gl);
        this.lineModelUndirected.initGLPrograms(gl);
        this.initBuffers((GL)gl);
    }

    protected void initBuffers(GL gl) {
        this.attributesBufferBatch = new float[ATTRIBS_STRIDE * 32768];
        this.attributesBuffer = new ManagedDirectBuffer(5126, ATTRIBS_STRIDE * 32768);
        this.selfLoopAttributesBufferBatch = new float[40960];
        this.selfLoopAttributesBuffer = new ManagedDirectBuffer(5126, 40960);
    }

    protected int setupShaderProgramForRenderingLayerSelfLoop(GL2ES2 gl, RenderingLayer layer, EdgeWorldData data, float[] mvpFloats) {
        int instanceCount;
        boolean renderingUnselectedEdges = layer.isBack();
        if (!this.someSelection && renderingUnselectedEdges) {
            return 0;
        }
        boolean someSelection = data.hasSomeSelection();
        float[] backgroundColorFloats = data.getBackgroundColor();
        float edgeScale = data.getEdgeScale();
        float nodeScale = data.getNodeScale();
        float lightenNonSelectedFactor = data.getLightenNonSelectedFactor();
        float minWeight = data.getMinWeight();
        float maxWeight = data.getMaxWeight();
        float edgeRescaleMin = data.getEdgeRescaleMin();
        float edgeRescaleMax = data.getEdgeRescaleMax();
        if (renderingUnselectedEdges) {
            instanceCount = this.selfLoopCounter.unselectedCountToDraw;
            this.edgeCircleSelfLoopSelectionUnselected.useProgram(gl, mvpFloats, backgroundColorFloats, lightenNonSelectedFactor, this.globalTime, this.selectedTime, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
            if (this.usesSecondaryBuffer) {
                this.setupSelfLoopVertexArrayAttributesSecondary(gl, data);
            } else {
                this.setupSelfLoopVertexArrayAttributes(gl, data);
            }
        } else {
            instanceCount = this.selfLoopCounter.selectedCountToDraw;
            if (someSelection) {
                if (this.edgeSelectionColor) {
                    this.edgeCircleSelfLoopNoSelection.useProgram(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
                } else {
                    this.edgeCircleSelfLoopSelectionSelected.useProgram(gl, mvpFloats, backgroundColorFloats, lightenNonSelectedFactor, this.globalTime, this.selectedTime, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
                }
            } else {
                this.edgeCircleSelfLoopNoSelection.useProgram(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
            }
            this.setupSelfLoopVertexArrayAttributes(gl, data);
        }
        return instanceCount;
    }

    protected int setupShaderProgramForRenderingLayerUndirected(GL2ES2 gl, RenderingLayer layer, EdgeWorldData data, float[] mvpFloats) {
        int instanceCount;
        boolean renderingUnselectedEdges = layer.isBack();
        if (!this.someSelection && renderingUnselectedEdges) {
            return 0;
        }
        boolean someSelection = data.hasSomeSelection();
        float[] backgroundColorFloats = data.getBackgroundColor();
        float edgeScale = data.getEdgeScale();
        float nodeScale = data.getNodeScale();
        float lightenNonSelectedFactor = data.getLightenNonSelectedFactor();
        float minWeight = data.getMinWeight();
        float maxWeight = data.getMaxWeight();
        float edgeRescaleMin = data.getEdgeRescaleMin();
        float edgeRescaleMax = data.getEdgeRescaleMax();
        if (renderingUnselectedEdges) {
            instanceCount = this.undirectedInstanceCounter.unselectedCountToDraw;
            this.lineModelUndirected.useProgramWithSelectionUnselected(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, backgroundColorFloats, lightenNonSelectedFactor, nodeScale, this.globalTime, this.selectedTime);
            if (this.usesSecondaryBuffer) {
                this.setupUndirectedVertexArrayAttributesSecondary(gl, data);
            } else {
                this.setupUndirectedVertexArrayAttributes(gl, data);
            }
        } else {
            instanceCount = this.undirectedInstanceCounter.selectedCountToDraw;
            this.lineModelUndirected.useProgram(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
            if (someSelection) {
                if (this.edgeSelectionColor) {
                    this.lineModelUndirected.useProgram(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
                } else {
                    this.lineModelUndirected.useProgramWithSelectionSelected(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale, this.globalTime, this.selectedTime);
                }
            } else {
                this.lineModelUndirected.useProgram(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
            }
            this.setupUndirectedVertexArrayAttributes(gl, data);
        }
        return instanceCount;
    }

    protected int setupShaderProgramForRenderingLayerDirected(GL2ES2 gl, RenderingLayer layer, EdgeWorldData data, float[] mvpFloats) {
        int instanceCount;
        boolean someSelection = data.hasSomeSelection();
        boolean renderingUnselectedEdges = layer.isBack();
        if (!someSelection && renderingUnselectedEdges) {
            return 0;
        }
        float[] backgroundColorFloats = data.getBackgroundColor();
        float edgeScale = data.getEdgeScale();
        float nodeScale = data.getNodeScale();
        float lightenNonSelectedFactor = data.getLightenNonSelectedFactor();
        float minWeight = data.getMinWeight();
        float maxWeight = data.getMaxWeight();
        float edgeRescaleMin = data.getEdgeRescaleMin();
        float edgeRescaleMax = data.getEdgeRescaleMax();
        if (renderingUnselectedEdges) {
            instanceCount = this.directedInstanceCounter.unselectedCountToDraw;
            this.lineModelDirected.useProgramWithSelectionUnselected(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, backgroundColorFloats, lightenNonSelectedFactor, nodeScale, this.globalTime, this.selectedTime);
            if (this.usesSecondaryBuffer) {
                this.setupDirectedVertexArrayAttributesSecondary(gl, data);
            } else {
                this.setupDirectedVertexArrayAttributes(gl, data);
            }
        } else {
            instanceCount = this.directedInstanceCounter.selectedCountToDraw;
            this.lineModelDirected.useProgram(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
            if (someSelection) {
                if (someSelection && this.edgeSelectionColor) {
                    this.lineModelDirected.useProgram(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
                } else {
                    this.lineModelDirected.useProgramWithSelectionSelected(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale, this.globalTime, this.selectedTime);
                }
            } else {
                this.lineModelDirected.useProgram(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, nodeScale);
            }
            this.setupDirectedVertexArrayAttributes(gl, data);
        }
        return instanceCount;
    }

    public EdgeWorldData createWorldData(VizEngineModel model, VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        return new EdgeWorldData(model.getRenderingOptions().getBackgroundColor(), this.someSelection, this.edgeWeightEnabled ? this.edgesCallback.getMinWeight() : 0.0f, this.edgeWeightEnabled ? this.edgesCallback.getMaxWeight() : 1.0f, model.getRenderingOptions().isEdgeRescaleWeightEnabled() ? model.getRenderingOptions().getEdgeRescaleMin() : 1.0f, model.getRenderingOptions().isEdgeRescaleWeightEnabled() ? model.getRenderingOptions().getEdgeRescaleMax() : 1.0f, model.getRenderingOptions().getNodeScale(), model.getRenderingOptions().getEdgeScale(), model.getRenderingOptions().getLightenNonSelectedFactor(), engine.getOpenGLOptions());
    }

    protected abstract void updateData(GraphSelection var1);

    public void update(GraphIndex graphIndex, GraphSelection selection, GraphRenderingOptions renderingOptions, Rect2D viewBoundaries) {
        if (!renderingOptions.isShowEdges()) {
            this.undirectedInstanceCounter.clearCount();
            this.directedInstanceCounter.clearCount();
            this.selfLoopCounter.clearCount();
            return;
        }
        this.someSelection = selection.someNodesOrEdgesSelection();
        float lightenNonSelectedFactor = renderingOptions.getLightenNonSelectedFactor();
        boolean hideNonSelectedFlag = renderingOptions.isHideNonSelectedEdges();
        if (!this.someSelection && hideNonSelectedFlag) {
            this.undirectedInstanceCounter.clearCount();
            this.directedInstanceCounter.clearCount();
            this.selfLoopCounter.clearCount();
            return;
        }
        this.hideNonSelected = this.someSelection && (hideNonSelectedFlag || lightenNonSelectedFactor >= 1.0f);
        this.edgeSelectionColor = renderingOptions.isEdgeSelectionColor();
        this.edgeColorMode = renderingOptions.getEdgeColorMode();
        this.edgeWeightEnabled = renderingOptions.isEdgeWeightEnabled();
        this.edgeBothSelectionColor = Float.intBitsToFloat(renderingOptions.getEdgeBothSelectionColor().getRGB());
        this.edgeInSelectionColor = Float.intBitsToFloat(renderingOptions.getEdgeInSelectionColor().getRGB());
        this.edgeOutSelectionColor = Float.intBitsToFloat(renderingOptions.getEdgeOutSelectionColor().getRGB());
        this.updateData(selection);
    }

    protected int updateDirectedData(boolean isUndirected, int maxIndex, Edge[] visibleEdgesArray, float[] edgeWeightsArray, float[] attribs, int index) {
        return this.updateDirectedData(isUndirected, maxIndex, visibleEdgesArray, edgeWeightsArray, attribs, index, null);
    }

    protected int updateSelfLoop(int maxIndex, Edge[] visibleEdgesArray, float[] edgeWeightsArray, float[] attribs, int index, FloatBuffer directBuffer) {
        int selfLoopEdgeIndex = 0;
        int unselectedSelfLoopEdgeIndex = 0;
        if (this.someSelection) {
            if (this.hideNonSelected) {
                for (int i = 0; i <= maxIndex; ++i) {
                    Edge e = visibleEdgesArray[i];
                    if (e == null || e.getSource() != e.getTarget() || !this.edgesCallback.isSelected(i)) continue;
                    ++selfLoopEdgeIndex;
                    float weight = this.edgeWeightEnabled ? edgeWeightsArray[i] : 1.0f;
                    this.fillSelfLoopEdgeAttributesDataWithSelection(attribs, e, index, weight);
                    if (directBuffer == null || (index += 5) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
            } else {
                float weight;
                Edge e;
                int i;
                for (i = 0; i <= maxIndex; ++i) {
                    e = visibleEdgesArray[i];
                    if (e == null || e.getSource() != e.getTarget() || this.edgesCallback.isSelected(i)) continue;
                    ++unselectedSelfLoopEdgeIndex;
                    weight = this.edgeWeightEnabled ? edgeWeightsArray[i] : 1.0f;
                    this.fillSelfLoopEdgeAttributesDataWithSelection(attribs, e, index, weight);
                    if (directBuffer == null || (index += 5) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
                for (i = 0; i <= maxIndex; ++i) {
                    e = visibleEdgesArray[i];
                    if (e == null || e.getSource() != e.getTarget() || !this.edgesCallback.isSelected(i)) continue;
                    ++selfLoopEdgeIndex;
                    weight = this.edgeWeightEnabled ? edgeWeightsArray[i] : 1.0f;
                    this.fillSelfLoopEdgeAttributesDataWithSelection(attribs, e, index, weight);
                    if (directBuffer == null || (index += 5) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
            }
        } else {
            for (int i = 0; i <= maxIndex; ++i) {
                Edge e = visibleEdgesArray[i];
                if (e == null || e.getSource() != e.getTarget()) continue;
                ++selfLoopEdgeIndex;
                float weight = this.edgeWeightEnabled ? edgeWeightsArray[i] : 1.0f;
                this.fillSelfLoopEdgeAttributesDataWithoutSelection(attribs, e, index, weight);
                if (directBuffer == null || (index += 5) != attribs.length) continue;
                directBuffer.put(attribs, 0, attribs.length);
                index = 0;
            }
        }
        if (directBuffer != null && index > 0) {
            directBuffer.put(attribs, 0, index);
            index = 0;
        }
        this.selfLoopCounter.selectedCount = selfLoopEdgeIndex;
        this.selfLoopCounter.unselectedCount = unselectedSelfLoopEdgeIndex;
        return index;
    }

    protected int updateDirectedData(boolean isUndirected, int maxIndex, Edge[] visibleEdgesArray, float[] edgeWeightsArray, float[] attribs, int index, FloatBuffer directBuffer) {
        this.checkBufferIndexing(directBuffer, attribs, index);
        if (isUndirected) {
            this.directedInstanceCounter.unselectedCount = 0;
            this.directedInstanceCounter.selectedCount = 0;
            this.selfLoopCounter.selectedCount = 0;
            return index;
        }
        int newEdgesCountUnselected = 0;
        int newEdgesCountSelected = 0;
        if (this.someSelection) {
            if (this.hideNonSelected) {
                for (int j = 0; j <= maxIndex; ++j) {
                    boolean selected;
                    Edge edge = visibleEdgesArray[j];
                    if (edge == null || edge.getSource() == edge.getTarget() || !edge.isDirected() || !(selected = this.edgesCallback.isSelected(j))) continue;
                    ++newEdgesCountSelected;
                    float weight = this.edgeWeightEnabled ? edgeWeightsArray[j] : 1.0f;
                    this.fillDirectedEdgeAttributesDataWithSelection(attribs, edge, index, selected, weight);
                    if (directBuffer == null || (index += ATTRIBS_STRIDE) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
            } else {
                float weight;
                Edge edge;
                int j;
                for (j = 0; j <= maxIndex; ++j) {
                    edge = visibleEdgesArray[j];
                    if (edge == null || edge.getSource() == edge.getTarget() || !edge.isDirected() || this.edgesCallback.isSelected(j)) continue;
                    ++newEdgesCountUnselected;
                    weight = this.edgeWeightEnabled ? edgeWeightsArray[j] : 1.0f;
                    this.fillDirectedEdgeAttributesDataWithSelection(attribs, edge, index, false, weight);
                    if (directBuffer == null || (index += ATTRIBS_STRIDE) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
                for (j = 0; j <= maxIndex; ++j) {
                    edge = visibleEdgesArray[j];
                    if (edge == null || edge.getSource() == edge.getTarget() || !edge.isDirected() || !this.edgesCallback.isSelected(j)) continue;
                    ++newEdgesCountSelected;
                    weight = this.edgeWeightEnabled ? edgeWeightsArray[j] : 1.0f;
                    this.fillDirectedEdgeAttributesDataWithSelection(attribs, edge, index, true, weight);
                    if (directBuffer == null || (index += ATTRIBS_STRIDE) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
            }
        } else {
            for (int j = 0; j <= maxIndex; ++j) {
                Edge edge = visibleEdgesArray[j];
                if (edge == null || edge.getSource() == edge.getTarget() || !edge.isDirected()) continue;
                ++newEdgesCountSelected;
                float weight = this.edgeWeightEnabled ? edgeWeightsArray[j] : 1.0f;
                this.fillDirectedEdgeAttributesDataWithoutSelection(attribs, edge, index, weight);
                if (directBuffer == null || (index += ATTRIBS_STRIDE) != attribs.length) continue;
                directBuffer.put(attribs, 0, attribs.length);
                index = 0;
            }
        }
        if (directBuffer != null && index > 0) {
            directBuffer.put(attribs, 0, index);
            index = 0;
        }
        this.directedInstanceCounter.unselectedCount = newEdgesCountUnselected;
        this.directedInstanceCounter.selectedCount = newEdgesCountSelected;
        return index;
    }

    protected int updateUndirectedData(boolean isDirected, int maxIndex, Edge[] visibleEdgesArray, float[] edgeWeightsArray, float[] attribs, int index) {
        return this.updateUndirectedData(isDirected, maxIndex, visibleEdgesArray, edgeWeightsArray, attribs, index, null);
    }

    protected int updateUndirectedData(boolean isDirected, int maxIndex, Edge[] visibleEdgesArray, float[] edgeWeightsArray, float[] attribs, int index, FloatBuffer directBuffer) {
        this.checkBufferIndexing(directBuffer, attribs, index);
        if (isDirected) {
            this.undirectedInstanceCounter.unselectedCount = 0;
            this.undirectedInstanceCounter.selectedCount = 0;
            return index;
        }
        int newEdgesCountUnselected = 0;
        int newEdgesCountSelected = 0;
        if (this.someSelection) {
            if (this.hideNonSelected) {
                for (int j = 0; j <= maxIndex; ++j) {
                    Edge edge = visibleEdgesArray[j];
                    if (edge == null || edge.getSource() == edge.getTarget() || edge.isDirected() || !this.edgesCallback.isSelected(j)) continue;
                    ++newEdgesCountSelected;
                    float weight = this.edgeWeightEnabled ? edgeWeightsArray[j] : 1.0f;
                    this.fillUndirectedEdgeAttributesDataWithSelection(attribs, edge, index, true, weight);
                    if (directBuffer == null || (index += ATTRIBS_STRIDE) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
            } else {
                float weight;
                Edge edge;
                int j;
                for (j = 0; j <= maxIndex; ++j) {
                    edge = visibleEdgesArray[j];
                    if (edge == null || edge.getSource() == edge.getTarget() || edge.isDirected() || this.edgesCallback.isSelected(j)) continue;
                    ++newEdgesCountUnselected;
                    weight = this.edgeWeightEnabled ? edgeWeightsArray[j] : 1.0f;
                    this.fillUndirectedEdgeAttributesDataWithSelection(attribs, edge, index, false, weight);
                    if (directBuffer == null || (index += ATTRIBS_STRIDE) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
                for (j = 0; j <= maxIndex; ++j) {
                    edge = visibleEdgesArray[j];
                    if (edge == null || edge.getSource() == edge.getTarget() || edge.isDirected() || !this.edgesCallback.isSelected(j)) continue;
                    ++newEdgesCountSelected;
                    weight = this.edgeWeightEnabled ? edgeWeightsArray[j] : 1.0f;
                    this.fillUndirectedEdgeAttributesDataWithSelection(attribs, edge, index, true, weight);
                    if (directBuffer == null || (index += ATTRIBS_STRIDE) != attribs.length) continue;
                    directBuffer.put(attribs, 0, attribs.length);
                    index = 0;
                }
            }
        } else {
            for (int j = 0; j <= maxIndex; ++j) {
                Edge edge = visibleEdgesArray[j];
                if (edge == null || edge.getSource() == edge.getTarget() || edge.isDirected()) continue;
                ++newEdgesCountSelected;
                float weight = this.edgeWeightEnabled ? edgeWeightsArray[j] : 1.0f;
                this.fillUndirectedEdgeAttributesDataWithoutSelection(attribs, edge, index, weight);
                if (directBuffer == null || (index += ATTRIBS_STRIDE) != attribs.length) continue;
                directBuffer.put(attribs, 0, attribs.length);
                index = 0;
            }
        }
        if (directBuffer != null && index > 0) {
            directBuffer.put(attribs, 0, index);
            index = 0;
        }
        this.undirectedInstanceCounter.unselectedCount = newEdgesCountUnselected;
        this.undirectedInstanceCounter.selectedCount = newEdgesCountSelected;
        return index;
    }

    private void checkBufferIndexing(FloatBuffer directBuffer, float[] attribs, int index) {
        if (directBuffer != null) {
            if (attribs.length % ATTRIBS_STRIDE != 0) {
                throw new IllegalArgumentException("When filling a directBuffer, attribs buffer length should be a multiple of ATTRIBS_STRIDE = " + ATTRIBS_STRIDE);
            }
            if (index % ATTRIBS_STRIDE != 0) {
                throw new IllegalArgumentException("When filling a directBuffer, index should be a multiple of ATTRIBS_STRIDE = " + ATTRIBS_STRIDE);
            }
        }
    }

    protected void fillUndirectedEdgeAttributesDataBase(float[] buffer, Edge edge, int index, float weight) {
        Node source = edge.getSource();
        Node target = edge.getTarget();
        float sourceX = source.x();
        float sourceY = source.y();
        float targetX = target.x();
        float targetY = target.y();
        buffer[index] = sourceX;
        buffer[index + 1] = sourceY;
        buffer[index + 2] = targetX;
        buffer[index + 3] = targetY;
        buffer[index + 4] = weight;
    }

    protected void fillUndirectedEdgeAttributesDataWithoutSelection(float[] buffer, Edge edge, int index, float weight) {
        this.fillUndirectedEdgeAttributesDataBase(buffer, edge, index, weight);
        buffer[index + 5] = this.computeElementColor(edge);
        buffer[index + 6] = edge.getSource().size();
        buffer[index + 7] = edge.getTarget().size();
    }

    protected void fillUndirectedEdgeAttributesDataWithSelection(float[] buffer, Edge edge, int index, boolean selected, float weight) {
        Node source = edge.getSource();
        Node target = edge.getTarget();
        this.fillUndirectedEdgeAttributesDataBase(buffer, edge, index, weight);
        if (selected) {
            if (this.someSelection && this.edgeSelectionColor) {
                boolean sourceSelected = this.nodesCallback.isSelected(source.getStoreId());
                boolean targetSelected = this.nodesCallback.isSelected(target.getStoreId());
                buffer[index + 5] = sourceSelected && targetSelected ? this.edgeBothSelectionColor : (sourceSelected ? this.edgeOutSelectionColor : (targetSelected ? this.edgeInSelectionColor : this.computeElementColor(edge)));
            } else {
                buffer[index + 5] = this.someSelection ? (this.nodesCallback.isSelected(source.getStoreId()) ? Float.intBitsToFloat(target.getRGBA()) : (this.nodesCallback.isSelected(target.getStoreId()) ? Float.intBitsToFloat(source.getRGBA()) : this.computeElementColor(edge))) : this.computeElementColor(edge);
            }
        } else {
            buffer[index + 5] = this.computeElementColor(edge);
        }
        buffer[index + 6] = edge.getSource().size();
        buffer[index + 7] = edge.getTarget().size();
    }

    protected void fillDirectedEdgeAttributesDataBase(float[] buffer, Edge edge, int index, float weight) {
        Node source = edge.getSource();
        Node target = edge.getTarget();
        float sourceX = source.x();
        float sourceY = source.y();
        float targetX = target.x();
        float targetY = target.y();
        buffer[index] = sourceX;
        buffer[index + 1] = sourceY;
        buffer[index + 2] = targetX;
        buffer[index + 3] = targetY;
        buffer[index + 4] = weight;
    }

    protected void fillSelfLoopEdgeAttributesDataWithSelection(float[] buffer, Edge edge, int index, float weight) {
        Node source = edge.getSource();
        float sourceX = source.x();
        float sourceY = source.y();
        buffer[index] = sourceX;
        buffer[index + 1] = sourceY;
        buffer[index + 2] = this.computeElementColor(edge);
        buffer[index + 3] = weight;
        buffer[index + 4] = source.size();
    }

    protected void fillSelfLoopEdgeAttributesDataWithoutSelection(float[] buffer, Edge edge, int index, float weight) {
        Node source = edge.getSource();
        float sourceX = source.x();
        float sourceY = source.y();
        buffer[index] = sourceX;
        buffer[index + 1] = sourceY;
        buffer[index + 2] = this.computeElementColor(edge);
        buffer[index + 3] = weight;
        buffer[index + 4] = source.size();
    }

    protected void fillDirectedEdgeAttributesDataWithoutSelection(float[] buffer, Edge edge, int index, float weight) {
        this.fillDirectedEdgeAttributesDataBase(buffer, edge, index, weight);
        buffer[index + 5] = this.computeElementColor(edge);
        buffer[index + 6] = edge.getSource().size();
        buffer[index + 7] = edge.getTarget().size();
    }

    protected void fillDirectedEdgeAttributesDataWithSelection(float[] buffer, Edge edge, int index, boolean selected, float weight) {
        Node source = edge.getSource();
        Node target = edge.getTarget();
        this.fillDirectedEdgeAttributesDataBase(buffer, edge, index, weight);
        if (selected) {
            if (this.someSelection && this.edgeSelectionColor) {
                boolean sourceSelected = this.nodesCallback.isSelected(source.getStoreId());
                boolean targetSelected = this.nodesCallback.isSelected(target.getStoreId());
                buffer[index + 5] = sourceSelected && targetSelected ? this.edgeBothSelectionColor : (sourceSelected ? this.edgeOutSelectionColor : (targetSelected ? this.edgeInSelectionColor : this.computeElementColor(edge)));
            } else {
                buffer[index + 5] = this.someSelection ? (this.nodesCallback.isSelected(source.getStoreId()) ? Float.intBitsToFloat(target.getRGBA()) : (this.nodesCallback.isSelected(target.getStoreId()) ? Float.intBitsToFloat(source.getRGBA()) : this.computeElementColor(edge))) : this.computeElementColor(edge);
            }
        } else {
            buffer[index + 5] = this.computeElementColor(edge);
        }
        buffer[index + 6] = source.size();
        buffer[index + 7] = target.size();
    }

    private float computeElementColor(Edge edge) {
        return Float.intBitsToFloat(switch (this.edgeColorMode) {
            case GraphRenderingOptions.EdgeColorMode.SOURCE -> edge.getSource().getRGBA();
            case GraphRenderingOptions.EdgeColorMode.TARGET -> edge.getTarget().getRGBA();
            case GraphRenderingOptions.EdgeColorMode.MIXED -> {
                int s = edge.getSource().getRGBA();
                int t = edge.getTarget().getRGBA();
                if (s == t) {
                    yield s;
                }
                int b0 = (s & 0xFF) + (t & 0xFF);
                int b1 = (s >>> 8 & 0xFF) + (t >>> 8 & 0xFF);
                int b2 = (s >>> 16 & 0xFF) + (t >>> 16 & 0xFF);
                int b3 = (s >>> 24 & 0xFF) + (t >>> 24 & 0xFF);
                yield b3 >>> 1 << 24 | b2 >>> 1 << 16 | b1 >>> 1 << 8 | b0 >>> 1;
            }
            default -> edge.getRGBA();
        });
    }

    public void setupSelfLoopVertexArrayAttributes(GL2ES2 gl, EdgeWorldData data) {
        if (this.selfLoopEdgesVAO == null) {
            this.selfLoopEdgesVAO = new SelfLoopEdgesVAO(data.getOpenGLOptions(), this.attributesGLBufferSelfLoop);
        }
        this.selfLoopEdgesVAO.use(gl);
    }

    public void setupSelfLoopVertexArrayAttributesSecondary(GL2ES2 gl, EdgeWorldData data) {
        if (this.selfLoopEdgesVAOSecondary == null) {
            this.selfLoopEdgesVAOSecondary = new SelfLoopEdgesVAO(data.getOpenGLOptions(), this.attributesGLBufferSelfLoopSecondary);
        }
        this.selfLoopEdgesVAOSecondary.use(gl);
    }

    public void setupUndirectedVertexArrayAttributes(GL2ES2 gl, EdgeWorldData data) {
        if (this.undirectedEdgesVAO == null) {
            this.undirectedEdgesVAO = new UndirectedEdgesVAO(data.getOpenGLOptions(), this.attributesGLBufferUndirected);
        }
        this.undirectedEdgesVAO.use(gl);
    }

    public void setupUndirectedVertexArrayAttributesSecondary(GL2ES2 gl, EdgeWorldData data) {
        if (this.undirectedEdgesVAOSecondary == null) {
            this.undirectedEdgesVAOSecondary = new UndirectedEdgesVAO(data.getOpenGLOptions(), this.attributesGLBufferUndirectedSecondary);
        }
        this.undirectedEdgesVAOSecondary.use(gl);
    }

    public void unsetupSelfLoopVertexArrayAttributes(GL2ES2 gl) {
        if (this.selfLoopEdgesVAO != null) {
            this.selfLoopEdgesVAO.stopUsing(gl);
        }
        if (this.selfLoopEdgesVAOSecondary != null) {
            this.selfLoopEdgesVAOSecondary.stopUsing(gl);
        }
    }

    public void unsetupUndirectedVertexArrayAttributes(GL2ES2 gl) {
        if (this.undirectedEdgesVAO != null) {
            this.undirectedEdgesVAO.stopUsing(gl);
        }
        if (this.undirectedEdgesVAOSecondary != null) {
            this.undirectedEdgesVAOSecondary.stopUsing(gl);
        }
    }

    public void setupDirectedVertexArrayAttributes(GL2ES2 gl, EdgeWorldData data) {
        if (this.directedEdgesVAO == null) {
            this.directedEdgesVAO = new DirectedEdgesVAO(data.getOpenGLOptions(), this.attributesGLBufferDirected);
        }
        this.directedEdgesVAO.use(gl);
    }

    public void setupDirectedVertexArrayAttributesSecondary(GL2ES2 gl, EdgeWorldData data) {
        if (this.directedEdgesVAOSecondary == null) {
            this.directedEdgesVAOSecondary = new DirectedEdgesVAO(data.getOpenGLOptions(), this.attributesGLBufferDirectedSecondary);
        }
        this.directedEdgesVAOSecondary.use(gl);
    }

    public void unsetupDirectedVertexArrayAttributes(GL2ES2 gl) {
        if (this.directedEdgesVAO != null) {
            this.directedEdgesVAO.stopUsing(gl);
        }
        if (this.directedEdgesVAOSecondary != null) {
            this.directedEdgesVAOSecondary.stopUsing(gl);
        }
    }

    public void dispose(GL gl) {
        if (this.vertexGLBufferUndirected != null) {
            this.vertexGLBufferUndirected.destroy(gl);
            this.vertexGLBufferUndirected = null;
        }
        if (this.vertexGLBufferDirected != null) {
            this.vertexGLBufferDirected.destroy(gl);
            this.vertexGLBufferDirected = null;
        }
        if (this.vertexGLBufferSelfLoop != null) {
            this.vertexGLBufferSelfLoop.destroy(gl);
            this.vertexGLBufferSelfLoop = null;
        }
        if (this.attributesGLBufferDirected != null) {
            this.attributesGLBufferDirected.destroy(gl);
            this.attributesGLBufferDirected = null;
        }
        if (this.attributesGLBufferDirectedSecondary != null) {
            this.attributesGLBufferDirectedSecondary.destroy(gl);
            this.attributesGLBufferDirectedSecondary = null;
        }
        if (this.attributesGLBufferUndirected != null) {
            this.attributesGLBufferUndirected.destroy(gl);
            this.attributesGLBufferUndirected = null;
        }
        if (this.attributesGLBufferUndirectedSecondary != null) {
            this.attributesGLBufferUndirectedSecondary.destroy(gl);
            this.attributesGLBufferUndirectedSecondary = null;
        }
        if (this.attributesGLBufferSelfLoop != null) {
            this.attributesGLBufferSelfLoop.destroy(gl);
            this.attributesGLBufferSelfLoop = null;
        }
        if (this.attributesGLBufferSelfLoopSecondary != null) {
            this.attributesGLBufferSelfLoopSecondary.destroy(gl);
            this.attributesGLBufferSelfLoopSecondary = null;
        }
        if (this.attributesBuffer != null) {
            this.attributesBuffer.destroy();
            this.attributesBuffer = null;
        }
        if (this.selfLoopAttributesBuffer != null) {
            this.selfLoopAttributesBuffer.destroy();
            this.selfLoopAttributesBuffer = null;
        }
        if (this.undirectedEdgesVAO != null) {
            this.undirectedEdgesVAO.destroy(gl.getGL2ES2());
            this.undirectedEdgesVAO = null;
        }
        if (this.undirectedEdgesVAOSecondary != null) {
            this.undirectedEdgesVAOSecondary.destroy(gl.getGL2ES2());
            this.undirectedEdgesVAOSecondary = null;
        }
        if (this.directedEdgesVAO != null) {
            this.directedEdgesVAO.destroy(gl.getGL2ES2());
            this.directedEdgesVAO = null;
        }
        if (this.directedEdgesVAOSecondary != null) {
            this.directedEdgesVAOSecondary.destroy(gl.getGL2ES2());
            this.directedEdgesVAOSecondary = null;
        }
        if (this.selfLoopEdgesVAO != null) {
            this.selfLoopEdgesVAO.destroy(gl.getGL2ES2());
            this.selfLoopEdgesVAO = null;
        }
        if (this.selfLoopEdgesVAOSecondary != null) {
            this.selfLoopEdgesVAOSecondary.destroy(gl.getGL2ES2());
            this.selfLoopEdgesVAOSecondary = null;
        }
        this.lineModelUndirected.destroy(gl.getGL2ES2());
        this.lineModelDirected.destroy(gl.getGL2ES2());
        this.edgeCircleSelfLoopNoSelection.destroy(gl.getGL2ES2());
        this.edgeCircleSelfLoopSelectionSelected.destroy(gl.getGL2ES2());
        this.edgeCircleSelfLoopSelectionUnselected.destroy(gl.getGL2ES2());
        this.edgesCallback.reset();
    }

    public EdgesCallback getEdgesCallback() {
        return this.edgesCallback;
    }

    private class SelfLoopEdgesVAO
    extends GLVertexArrayObject {
        private final GLBuffer attributesBuffer;

        public SelfLoopEdgesVAO(OpenGLOptions openGLOptions, GLBuffer attributesBuffer) {
            super(openGLOptions);
            this.attributesBuffer = attributesBuffer;
        }

        @Override
        protected void configure(GL2ES2 gl) {
            AbstractEdgeData.this.vertexGLBufferSelfLoop.bind((GL)gl);
            gl.glVertexAttribPointer(0, 2, 5126, false, 0, 0L);
            AbstractEdgeData.this.vertexGLBufferSelfLoop.unbind((GL)gl);
            this.attributesBuffer.bind((GL)gl);
            int stride = 20;
            int offset = 0;
            gl.glVertexAttribPointer(1, 2, 5126, false, stride, (long)offset);
            gl.glVertexAttribPointer(2, 4, 5121, false, stride, (long)(offset += 8));
            gl.glVertexAttribPointer(3, 1, 5126, false, stride, (long)(offset += 4));
            gl.glVertexAttribPointer(9, 1, 5126, false, stride, (long)(offset += 4));
            this.attributesBuffer.unbind((GL)gl);
        }

        @Override
        protected int[] getUsedAttributeLocations() {
            return new int[]{0, 1, 2, 3, 9};
        }

        @Override
        protected int[] getInstancedAttributeLocations() {
            if (AbstractEdgeData.this.instanced) {
                return new int[]{1, 2, 3, 9};
            }
            return null;
        }
    }

    private class UndirectedEdgesVAO
    extends GLVertexArrayObject {
        private final GLBuffer attributesBuffer;

        public UndirectedEdgesVAO(OpenGLOptions openGLOptions, GLBuffer attributesBuffer) {
            super(openGLOptions);
            this.attributesBuffer = attributesBuffer;
        }

        @Override
        protected void configure(GL2ES2 gl) {
            AbstractEdgeData.this.vertexGLBufferUndirected.bind((GL)gl);
            gl.glVertexAttribPointer(0, 2, 5126, false, 0, 0L);
            AbstractEdgeData.this.vertexGLBufferUndirected.unbind((GL)gl);
            this.attributesBuffer.bind((GL)gl);
            int stride = ATTRIBS_STRIDE * 4;
            int offset = 0;
            gl.glVertexAttribPointer(1, 2, 5126, false, stride, (long)offset);
            gl.glVertexAttribPointer(8, 2, 5126, false, stride, (long)(offset += 8));
            gl.glVertexAttribPointer(3, 1, 5126, false, stride, (long)(offset += 8));
            gl.glVertexAttribPointer(2, 4, 5121, false, stride, (long)(offset += 4));
            gl.glVertexAttribPointer(6, 1, 5126, false, stride, (long)(offset += 4));
            gl.glVertexAttribPointer(7, 1, 5126, false, stride, (long)(offset += 4));
            this.attributesBuffer.unbind((GL)gl);
        }

        @Override
        protected int[] getUsedAttributeLocations() {
            return new int[]{0, 1, 8, 3, 2, 6, 7};
        }

        @Override
        protected int[] getInstancedAttributeLocations() {
            if (AbstractEdgeData.this.instanced) {
                return new int[]{1, 8, 3, 2, 6, 7};
            }
            return null;
        }
    }

    private class DirectedEdgesVAO
    extends GLVertexArrayObject {
        private final GLBuffer attributesBuffer;

        public DirectedEdgesVAO(OpenGLOptions openGLOptions, GLBuffer attributesBuffer) {
            super(openGLOptions);
            this.attributesBuffer = attributesBuffer;
        }

        @Override
        protected void configure(GL2ES2 gl) {
            AbstractEdgeData.this.vertexGLBufferDirected.bind((GL)gl);
            gl.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
            AbstractEdgeData.this.vertexGLBufferDirected.unbind((GL)gl);
            this.attributesBuffer.bind((GL)gl);
            int stride = ATTRIBS_STRIDE * 4;
            int offset = 0;
            gl.glVertexAttribPointer(1, 2, 5126, false, stride, (long)offset);
            gl.glVertexAttribPointer(8, 2, 5126, false, stride, (long)(offset += 8));
            gl.glVertexAttribPointer(3, 1, 5126, false, stride, (long)(offset += 8));
            gl.glVertexAttribPointer(2, 4, 5121, false, stride, (long)(offset += 4));
            gl.glVertexAttribPointer(6, 1, 5126, false, stride, (long)(offset += 4));
            gl.glVertexAttribPointer(7, 1, 5126, false, stride, (long)(offset += 4));
            this.attributesBuffer.unbind((GL)gl);
        }

        @Override
        protected int[] getUsedAttributeLocations() {
            return new int[]{0, 1, 8, 3, 2, 6, 7};
        }

        @Override
        protected int[] getInstancedAttributeLocations() {
            if (AbstractEdgeData.this.instanced) {
                return new int[]{1, 8, 3, 2, 6, 7};
            }
            return null;
        }
    }
}

