/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.arrays.updaters;

import com.jogamp.opengl.GL;
import org.gephi.graph.api.Node;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.availability.ArrayDraw;
import org.gephi.viz.engine.jogl.pipeline.arrays.ArrayDrawNodeData;
import org.gephi.viz.engine.spi.ElementsCallback;
import org.gephi.viz.engine.spi.WorldUpdater;

public class NodesUpdaterArrayDrawRendering
implements WorldUpdater<JOGLRenderingTarget, Node> {
    private final VizEngine engine;
    private final ArrayDrawNodeData nodeData;

    public NodesUpdaterArrayDrawRendering(VizEngine engine, ArrayDrawNodeData nodeData) {
        this.engine = engine;
        this.nodeData = nodeData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
        this.nodeData.init(target.getDrawable().getGL().getGL2ES2());
    }

    @Override
    public void dispose(JOGLRenderingTarget target) {
        this.nodeData.dispose((GL)target.getDrawable().getGL().getGL2ES2());
    }

    @Override
    public void updateWorld(VizEngineModel model) {
        this.nodeData.update(model.getRenderingOptions());
    }

    @Override
    public ElementsCallback<Node> getElementsCallback() {
        return this.nodeData.getNodesCallback();
    }

    @Override
    public String getCategory() {
        return "Node";
    }

    @Override
    public int getPreferenceInCategory() {
        return ArrayDraw.getPreferenceInCategory();
    }

    @Override
    public String getName() {
        return "Nodes (Vertex Array)";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return ArrayDraw.isAvailable(this.engine, target.getDrawable());
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

