/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.arrays.updaters;

import com.jogamp.opengl.GL;
import org.gephi.graph.api.Edge;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.availability.ArrayDraw;
import org.gephi.viz.engine.jogl.pipeline.arrays.ArrayDrawEdgeData;
import org.gephi.viz.engine.spi.ElementsCallback;
import org.gephi.viz.engine.spi.WorldUpdater;

public class EdgesUpdaterArrayDrawRendering
implements WorldUpdater<JOGLRenderingTarget, Edge> {
    private final VizEngine engine;
    private final ArrayDrawEdgeData edgeData;

    public EdgesUpdaterArrayDrawRendering(VizEngine engine, ArrayDrawEdgeData edgeData) {
        this.engine = engine;
        this.edgeData = edgeData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
        this.edgeData.init(target.getDrawable().getGL().getGL2ES2());
    }

    @Override
    public void dispose(JOGLRenderingTarget target) {
        this.edgeData.dispose((GL)target.getDrawable().getGL().getGL2ES2());
    }

    @Override
    public void updateWorld(VizEngineModel model) {
        this.edgeData.update(model.getGraphIndex(), model.getGraphSelection(), model.getRenderingOptions(), this.engine.getViewBoundaries());
    }

    @Override
    public ElementsCallback<Edge> getElementsCallback() {
        return this.edgeData.getEdgesCallback();
    }

    @Override
    public String getCategory() {
        return "Edge";
    }

    @Override
    public int getPreferenceInCategory() {
        return ArrayDraw.getPreferenceInCategory();
    }

    @Override
    public String getName() {
        return "Edges (Vertex Array)";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return ArrayDraw.isAvailable(this.engine, target.getDrawable());
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

