/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.arrays.renderers;

import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import java.nio.FloatBuffer;
import java.util.EnumSet;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.pipeline.common.VoidWorldData;
import org.gephi.viz.engine.jogl.util.ManagedDirectBuffer;
import org.gephi.viz.engine.jogl.util.gl.GLBufferMutable;
import org.gephi.viz.engine.jogl.util.gl.GLShaderProgram;
import org.gephi.viz.engine.jogl.util.gl.GLVertexArrayObject;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.spi.Renderer;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.status.GraphSelectionImpl;
import org.gephi.viz.engine.util.gl.OpenGLOptions;
import org.joml.Vector2f;

public class RectangleSelectionArrayDraw
implements Renderer<JOGLRenderingTarget, VoidWorldData> {
    private final VizEngine<JOGLRenderingTarget, NEWTEvent> engine;
    final float[] mvpFloats = new float[16];
    private static final int VERT_BUFFER = 0;
    public static final int VERTEX_COUNT = 6;
    public static final int VERTEX_FLOATS = 2;
    private final int[] bufferName = new int[1];
    private ManagedDirectBuffer rectangleVertexDataBuffer;
    private GLBufferMutable vertexGLBuffer;
    private SelectionRectangleVAO vao;
    private boolean render = false;
    private static final String SHADERS_ROOT = "/org/gephi/viz-engine/shaders/rectangleSelection";
    private GLShaderProgram shaderProgram;
    private final int[] intData = new int[1];
    private final byte[] booleanData = new byte[1];

    public RectangleSelectionArrayDraw(VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        this.engine = engine;
    }

    @Override
    public String getCategory() {
        return "Rectangle selection";
    }

    @Override
    public int getPreferenceInCategory() {
        return 0;
    }

    @Override
    public String getName() {
        return "Rectangle Selection";
    }

    @Override
    public void init(JOGLRenderingTarget target) {
        GL2ES2 gl = target.getDrawable().getGL().getGL2ES2();
        this.shaderProgram = new GLShaderProgram(SHADERS_ROOT, "rectangleSelection", "rectangleSelection").addUniformName("mvp").addAttribLocation("vert", 0).init(gl);
        gl.glGenBuffers(this.bufferName.length, this.bufferName, 0);
        this.rectangleVertexDataBuffer = new ManagedDirectBuffer(5126, 48);
        this.vertexGLBuffer = new GLBufferMutable(this.bufferName[0], 34962);
        this.vertexGLBuffer.bind((GL)gl);
        this.vertexGLBuffer.init((GL)gl, 48L, 35048);
        this.vertexGLBuffer.unbind((GL)gl);
        this.vao = new SelectionRectangleVAO(this.engine.getOpenGLOptions());
    }

    @Override
    public void dispose(JOGLRenderingTarget target) {
        GL2ES2 gl = target.getDrawable().getGL().getGL2ES2();
        if (this.shaderProgram != null) {
            this.shaderProgram.destroy(gl);
            this.shaderProgram = null;
        }
        if (this.vertexGLBuffer != null) {
            this.vertexGLBuffer.destroy((GL)gl);
            this.vertexGLBuffer = null;
        }
        if (this.rectangleVertexDataBuffer != null) {
            this.rectangleVertexDataBuffer.destroy();
            this.rectangleVertexDataBuffer = null;
        }
        if (this.vao != null) {
            this.vao.destroy(gl);
            this.vao = null;
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public VoidWorldData worldUpdated(VizEngineModel model, JOGLRenderingTarget target) {
        GL2ES2 gl = target.getDrawable().getGL().getGL2ES2();
        GraphSelectionImpl graphSelection = model.getGraphSelection();
        if (graphSelection.getMode() != GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION) {
            return VoidWorldData.INSTANCE;
        }
        Vector2f initialPosition = graphSelection.getRectangleInitialPosition();
        Vector2f currentPosition = graphSelection.getRectangleCurrentPosition();
        if (initialPosition != null && currentPosition != null) {
            float minX = Math.min(initialPosition.x, currentPosition.x);
            float minY = Math.min(initialPosition.y, currentPosition.y);
            float maxX = Math.max(initialPosition.x, currentPosition.x);
            float maxY = Math.max(initialPosition.y, currentPosition.y);
            FloatBuffer floatBuffer = this.rectangleVertexDataBuffer.floatBuffer();
            float[] rectangleVertexData = new float[]{minX, minY, minX, maxY, maxX, minY, minX, maxY, maxX, maxY, maxX, minY};
            floatBuffer.put(rectangleVertexData);
            floatBuffer.position(0);
            this.vertexGLBuffer.bind((GL)gl);
            this.vertexGLBuffer.update((GL)gl, floatBuffer);
            this.vertexGLBuffer.unbind((GL)gl);
            this.render = true;
        } else {
            this.render = false;
        }
        return VoidWorldData.INSTANCE;
    }

    @Override
    public void render(VoidWorldData data, JOGLRenderingTarget target, RenderingLayer layer) {
        GL2ES2 gl = target.getDrawable().getGL().getGL2ES2();
        if (this.render) {
            this.shaderProgram.use(gl);
            this.engine.getModelViewProjectionMatrixFloats(this.mvpFloats);
            gl.glUniformMatrix4fv(this.shaderProgram.getUniformLocation("mvp"), 1, false, this.mvpFloats, 0);
            this.vao.use(gl);
            gl.glGetBooleanv(3042, this.booleanData, 0);
            gl.glGetIntegerv(32970, this.intData, 0);
            boolean blendEnabled = this.booleanData[0] > 0;
            int blendFunc = this.intData[0];
            if (!blendEnabled) {
                gl.glEnable(3042);
            }
            if (blendFunc != 771) {
                gl.glBlendFunc(770, 771);
            }
            gl.glDrawArrays(4, 0, 6);
            if (!blendEnabled) {
                gl.glDisable(3042);
            }
            if (blendFunc != 771) {
                gl.glBlendFunc(770, blendFunc);
            }
            this.vao.stopUsing(gl);
            this.shaderProgram.stopUsing(gl);
        }
    }

    @Override
    public EnumSet<RenderingLayer> getLayers() {
        return EnumSet.of(RenderingLayer.FRONT4);
    }

    private class SelectionRectangleVAO
    extends GLVertexArrayObject {
        public SelectionRectangleVAO(OpenGLOptions openGLOptions) {
            super(openGLOptions);
        }

        @Override
        protected void configure(GL2ES2 gl) {
            RectangleSelectionArrayDraw.this.vertexGLBuffer.bind((GL)gl);
            gl.glVertexAttribPointer(0, 2, 5126, false, 0, 0L);
            RectangleSelectionArrayDraw.this.vertexGLBuffer.unbind((GL)gl);
        }

        @Override
        protected int[] getUsedAttributeLocations() {
            return new int[]{0};
        }

        @Override
        protected int[] getInstancedAttributeLocations() {
            return null;
        }
    }
}

