/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.arrays.renderers;

import com.jogamp.newt.event.NEWTEvent;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.availability.ArrayDraw;
import org.gephi.viz.engine.jogl.pipeline.arrays.ArrayDrawNodeData;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractNodeRenderer;
import org.gephi.viz.engine.jogl.pipeline.common.NodeWorldData;
import org.gephi.viz.engine.pipeline.RenderingLayer;

public class NodeRendererArrayDraw
extends AbstractNodeRenderer {
    private final VizEngine<JOGLRenderingTarget, NEWTEvent> engine;
    private final ArrayDrawNodeData nodeData;
    private final float[] mvpFloats = new float[16];

    public NodeRendererArrayDraw(VizEngine<JOGLRenderingTarget, NEWTEvent> engine, ArrayDrawNodeData nodeData) {
        this.engine = engine;
        this.nodeData = nodeData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
    }

    @Override
    public NodeWorldData worldUpdated(VizEngineModel model, JOGLRenderingTarget target) {
        this.nodeData.updateBuffers();
        return this.nodeData.createWorldData(model, this.engine);
    }

    @Override
    public void render(NodeWorldData data, JOGLRenderingTarget target, RenderingLayer layer) {
        this.engine.getModelViewProjectionMatrixFloats(this.mvpFloats);
        this.nodeData.drawArrays(target.getDrawable().getGL().getGL2ES2(), layer, data, this.mvpFloats);
    }

    @Override
    public int getPreferenceInCategory() {
        return ArrayDraw.getPreferenceInCategory();
    }

    @Override
    public String getName() {
        return "Nodes (Vertex Array)";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return ArrayDraw.isAvailable(this.engine, target.getDrawable());
    }
}

