/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.arrays.renderers;

import com.jogamp.newt.event.NEWTEvent;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.availability.ArrayDraw;
import org.gephi.viz.engine.jogl.pipeline.arrays.ArrayDrawEdgeData;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractEdgeRenderer;
import org.gephi.viz.engine.jogl.pipeline.common.EdgeWorldData;
import org.gephi.viz.engine.pipeline.RenderingLayer;

public class EdgeRendererArrayDraw
extends AbstractEdgeRenderer {
    private final VizEngine<JOGLRenderingTarget, NEWTEvent> engine;
    private final ArrayDrawEdgeData edgeData;
    private final float[] mvpFloats = new float[16];

    public EdgeRendererArrayDraw(VizEngine<JOGLRenderingTarget, NEWTEvent> engine, ArrayDrawEdgeData edgeData) {
        this.engine = engine;
        this.edgeData = edgeData;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
    }

    @Override
    public EdgeWorldData worldUpdated(VizEngineModel model, JOGLRenderingTarget target) {
        this.edgeData.updateBuffers();
        return this.edgeData.createWorldData(model, this.engine);
    }

    @Override
    public void render(EdgeWorldData data, JOGLRenderingTarget target, RenderingLayer layer) {
        this.engine.getModelViewProjectionMatrixFloats(this.mvpFloats);
        this.edgeData.drawArrays(target.getDrawable().getGL().getGL2ES2(), layer, data, this.mvpFloats);
    }

    @Override
    public int getPreferenceInCategory() {
        return ArrayDraw.getPreferenceInCategory();
    }

    @Override
    public String getName() {
        return "Edges (Vertex Array)";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return ArrayDraw.isAvailable(this.engine, target.getDrawable());
    }
}

