/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.arrays;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import java.nio.FloatBuffer;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractNodeData;
import org.gephi.viz.engine.jogl.pipeline.common.NodeWorldData;
import org.gephi.viz.engine.jogl.util.gl.GLFunctions;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.util.structure.NodesCallback;

public class ArrayDrawNodeData
extends AbstractNodeData {
    private final int[] bufferName = new int[1];
    private static final int VERT_BUFFER = 0;

    public ArrayDrawNodeData(NodesCallback nodesCallback) {
        super(nodesCallback, false, false);
    }

    public void drawArrays(GL2ES2 gl, RenderingLayer layer, NodeWorldData data, float[] mvpFloats) {
        this.refreshTime();
        this.drawArraysInternal(gl, layer, data, mvpFloats);
    }

    public void drawArraysInternal(GL2ES2 gl, RenderingLayer layer, NodeWorldData data, float[] mvpFloats) {
        int instanceCount = this.setupShaderProgramForRenderingLayer(gl, layer, data, mvpFloats);
        if (instanceCount <= 0) {
            GLFunctions.stopUsingProgram(gl);
            this.unsetupVertexArrayAttributes(gl);
            return;
        }
        boolean renderingUnselectedNodes = layer.isBack();
        int instancesOffset = renderingUnselectedNodes ? 0 : this.instanceCounter.unselectedCountToDraw;
        float zoom = data.getZoom();
        float[] attrs = new float[4];
        int index = instancesOffset * 4;
        FloatBuffer attribs = this.attributesBuffer.floatBuffer();
        attribs.position(index);
        for (int i = 0; i < instanceCount; ++i) {
            int firstVertex;
            int circleVertexCount;
            attribs.get(attrs);
            float size = attrs[3];
            float observedSize = size * zoom;
            if (observedSize > 128.0f) {
                circleVertexCount = this.circleMesh64.vertexCount;
                firstVertex = this.firstVertex64;
            } else if (observedSize > 16.0f) {
                circleVertexCount = this.circleMesh32.vertexCount;
                firstVertex = this.firstVertex32;
            } else if (observedSize > 2.0f) {
                circleVertexCount = this.circleMesh16.vertexCount;
                firstVertex = this.firstVertex16;
            } else {
                circleVertexCount = this.circleMesh8.vertexCount;
                firstVertex = this.firstVertex8;
            }
            gl.glVertexAttrib2fv(1, attrs, 0);
            int argb = Float.floatToRawIntBits(attrs[2]);
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            gl.glVertexAttrib4f(2, (float)b, (float)g, (float)r, (float)a);
            gl.glVertexAttrib1f(3, size);
            GLFunctions.drawArraysSingleInstance(gl, firstVertex, circleVertexCount);
        }
        GLFunctions.stopUsingProgram(gl);
        this.unsetupVertexArrayAttributes(gl);
    }

    public void updateBuffers() {
        this.instanceCounter.promoteCountToDraw();
    }

    @Override
    protected void initBuffers(GL gl) {
        super.initBuffers(gl);
        gl.glGenBuffers(this.bufferName.length, this.bufferName, 0);
        this.initCirclesGLVertexBuffer(gl, this.bufferName[0]);
    }
}

