/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline.arrays;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.FloatBuffer;
import org.gephi.graph.api.Edge;
import org.gephi.viz.engine.jogl.pipeline.common.AbstractEdgeData;
import org.gephi.viz.engine.jogl.pipeline.common.EdgeWorldData;
import org.gephi.viz.engine.jogl.util.ManagedDirectBuffer;
import org.gephi.viz.engine.jogl.util.gl.GLBufferMutable;
import org.gephi.viz.engine.jogl.util.gl.GLFunctions;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.util.ArrayUtils;
import org.gephi.viz.engine.util.structure.EdgesCallback;
import org.gephi.viz.engine.util.structure.NodesCallback;

public class ArrayDrawEdgeData
extends AbstractEdgeData {
    private final int[] bufferName = new int[6];
    private static final int VERT_BUFFER_UNDIRECTED = 0;
    private static final int VERT_BUFFER_DIRECTED = 1;
    private static final int ATTRIBS_BUFFER_DIRECTED = 2;
    private static final int ATTRIBS_BUFFER_UNDIRECTED = 3;
    private static final int VERT_BUFFER_SELFLOOP = 4;
    private static final int ATTRIBS_BUFFER_SELFLOOP = 5;
    private float[] attributesBuffer;
    private float[] selfLoopAttributesBuffer;
    private float[] attributesDrawBufferBatchOneCopyPerVertex;
    private ManagedDirectBuffer attributesDrawBufferBatchOneCopyPerVertexManagedDirectBuffer;

    public ArrayDrawEdgeData(EdgesCallback edgesCallback, NodesCallback nodesCallback) {
        super(edgesCallback, nodesCallback, false, false);
    }

    public void drawArrays(GL2ES2 gl, RenderingLayer layer, EdgeWorldData data, float[] mvpFloats) {
        this.refreshTime();
        if (this.edgesCallback.hasSelfLoop()) {
            this.drawSelfLoop(gl, data, layer, mvpFloats);
        }
        this.drawUndirected(gl, data, layer, mvpFloats);
        this.drawDirected(gl, data, layer, mvpFloats);
    }

    private void drawSelfLoop(GL2ES2 gl, EdgeWorldData data, RenderingLayer layer, float[] mvpFloats) {
        int instanceCount = this.setupShaderProgramForRenderingLayerSelfLoop(gl, layer, data, mvpFloats);
        boolean renderingUnselectedEdges = layer == RenderingLayer.BACK1;
        int instancesOffset = renderingUnselectedEdges ? 0 : this.selfLoopCounter.unselectedCountToDraw;
        FloatBuffer batchUpdateBuffer = this.attributesDrawBufferBatchOneCopyPerVertexManagedDirectBuffer.floatBuffer();
        int maxIndex = instancesOffset + instanceCount;
        for (int edgeBase = instancesOffset; edgeBase < maxIndex; edgeBase += 8192) {
            int drawBatchCount = Math.min(maxIndex - edgeBase, 8192);
            for (int edgeIndex = 0; edgeIndex < drawBatchCount; ++edgeIndex) {
                System.arraycopy(this.selfLoopAttributesBuffer, (edgeBase + edgeIndex) * 5, this.attributesDrawBufferBatchOneCopyPerVertex, edgeIndex * 5 * this.selfLoopMesh.vertexCount, 5);
                ArrayUtils.repeat(this.attributesDrawBufferBatchOneCopyPerVertex, edgeIndex * 5 * this.selfLoopMesh.vertexCount, 5, this.selfLoopMesh.vertexCount);
            }
            batchUpdateBuffer.clear();
            batchUpdateBuffer.put(this.attributesDrawBufferBatchOneCopyPerVertex, 0, drawBatchCount * 5 * this.selfLoopMesh.vertexCount);
            batchUpdateBuffer.flip();
            this.attributesGLBufferSelfLoop.bind((GL)gl);
            this.attributesGLBufferSelfLoop.updateWithOrphaning((GL)gl, batchUpdateBuffer);
            this.attributesGLBufferSelfLoop.unbind((GL)gl);
            GLFunctions.drawArraysSingleInstance(gl, 0, this.selfLoopMesh.vertexCount * drawBatchCount);
        }
        GLFunctions.stopUsingProgram(gl);
        this.unsetupSelfLoopVertexArrayAttributes(gl);
    }

    private void drawUndirected(GL2ES2 gl, EdgeWorldData data, RenderingLayer layer, float[] mvpFloats) {
        int instanceCount = this.setupShaderProgramForRenderingLayerUndirected(gl, layer, data, mvpFloats);
        boolean renderingUnselectedEdges = layer == RenderingLayer.BACK1;
        int instancesOffset = renderingUnselectedEdges ? 0 : this.undirectedInstanceCounter.unselectedCountToDraw;
        FloatBuffer batchUpdateBuffer = this.attributesDrawBufferBatchOneCopyPerVertexManagedDirectBuffer.floatBuffer();
        int maxIndex = instancesOffset + instanceCount;
        for (int edgeBase = instancesOffset; edgeBase < maxIndex; edgeBase += 32768) {
            int drawBatchCount = Math.min(maxIndex - edgeBase, 32768);
            for (int edgeIndex = 0; edgeIndex < drawBatchCount; ++edgeIndex) {
                System.arraycopy(this.attributesBuffer, (edgeBase + edgeIndex) * ATTRIBS_STRIDE, this.attributesDrawBufferBatchOneCopyPerVertex, edgeIndex * ATTRIBS_STRIDE * 6, ATTRIBS_STRIDE);
                ArrayUtils.repeat(this.attributesDrawBufferBatchOneCopyPerVertex, edgeIndex * ATTRIBS_STRIDE * 6, ATTRIBS_STRIDE, 6);
            }
            batchUpdateBuffer.clear();
            batchUpdateBuffer.put(this.attributesDrawBufferBatchOneCopyPerVertex, 0, drawBatchCount * ATTRIBS_STRIDE * 6);
            batchUpdateBuffer.flip();
            this.attributesGLBufferUndirected.bind((GL)gl);
            this.attributesGLBufferUndirected.updateWithOrphaning((GL)gl, batchUpdateBuffer);
            this.attributesGLBufferUndirected.unbind((GL)gl);
            GLFunctions.drawArraysSingleInstance(gl, 0, 6 * drawBatchCount);
        }
        GLFunctions.stopUsingProgram(gl);
        this.unsetupUndirectedVertexArrayAttributes(gl);
    }

    private void drawDirected(GL2ES2 gl, EdgeWorldData data, RenderingLayer layer, float[] mvpFloats) {
        int instanceCount = this.setupShaderProgramForRenderingLayerDirected(gl, layer, data, mvpFloats);
        boolean renderingUnselectedEdges = layer == RenderingLayer.BACK1;
        int instancesOffset = renderingUnselectedEdges ? this.undirectedInstanceCounter.totalToDraw() : this.undirectedInstanceCounter.totalToDraw() + this.directedInstanceCounter.unselectedCountToDraw;
        FloatBuffer batchUpdateBuffer = this.attributesDrawBufferBatchOneCopyPerVertexManagedDirectBuffer.floatBuffer();
        int maxIndex = instancesOffset + instanceCount;
        for (int edgeBase = instancesOffset; edgeBase < maxIndex; edgeBase += 32768) {
            int drawBatchCount = Math.min(maxIndex - edgeBase, 32768);
            for (int edgeIndex = 0; edgeIndex < drawBatchCount; ++edgeIndex) {
                System.arraycopy(this.attributesBuffer, (edgeBase + edgeIndex) * ATTRIBS_STRIDE, this.attributesDrawBufferBatchOneCopyPerVertex, edgeIndex * ATTRIBS_STRIDE * 9, ATTRIBS_STRIDE);
                ArrayUtils.repeat(this.attributesDrawBufferBatchOneCopyPerVertex, edgeIndex * ATTRIBS_STRIDE * 9, ATTRIBS_STRIDE, 9);
            }
            batchUpdateBuffer.clear();
            batchUpdateBuffer.put(this.attributesDrawBufferBatchOneCopyPerVertex, 0, drawBatchCount * ATTRIBS_STRIDE * 9);
            batchUpdateBuffer.flip();
            this.attributesGLBufferDirected.bind((GL)gl);
            this.attributesGLBufferDirected.updateWithOrphaning((GL)gl, batchUpdateBuffer);
            this.attributesGLBufferDirected.unbind((GL)gl);
            GLFunctions.drawArraysSingleInstance(gl, 0, 9 * drawBatchCount);
        }
        GLFunctions.stopUsingProgram(gl);
        this.unsetupDirectedVertexArrayAttributes(gl);
    }

    @Override
    protected void initBuffers(GL gl) {
        super.initBuffers(gl);
        int regularEdgeBufferSize = ATTRIBS_STRIDE * VERTEX_COUNT_MAX * 32768;
        int selfLoopBufferSize = 5 * this.selfLoopMesh.vertexCount * 8192;
        int maxBufferSize = Math.max(regularEdgeBufferSize, selfLoopBufferSize);
        this.attributesDrawBufferBatchOneCopyPerVertex = new float[maxBufferSize];
        this.attributesDrawBufferBatchOneCopyPerVertexManagedDirectBuffer = new ManagedDirectBuffer(5126, maxBufferSize);
        gl.glGenBuffers(this.bufferName.length, this.bufferName, 0);
        float[] undirectedVertexDataArray = new float[this.undirectedEdgeMesh.vertexData.length * 32768];
        System.arraycopy(this.undirectedEdgeMesh.vertexData, 0, undirectedVertexDataArray, 0, this.undirectedEdgeMesh.vertexData.length);
        ArrayUtils.repeat(undirectedVertexDataArray, 0, this.undirectedEdgeMesh.vertexData.length, 32768);
        FloatBuffer undirectedVertexData = GLBuffers.newDirectFloatBuffer((float[])undirectedVertexDataArray);
        this.vertexGLBufferUndirected = new GLBufferMutable(this.bufferName[0], 34962);
        this.vertexGLBufferUndirected.bind(gl);
        this.vertexGLBufferUndirected.init(gl, undirectedVertexData, 35044);
        this.vertexGLBufferUndirected.unbind(gl);
        float[] directedVertexDataArray = new float[this.directedEdgeMesh.vertexData.length * 32768];
        System.arraycopy(this.directedEdgeMesh.vertexData, 0, directedVertexDataArray, 0, this.directedEdgeMesh.vertexData.length);
        ArrayUtils.repeat(directedVertexDataArray, 0, this.directedEdgeMesh.vertexData.length, 32768);
        FloatBuffer directedVertexData = GLBuffers.newDirectFloatBuffer((float[])directedVertexDataArray);
        this.vertexGLBufferDirected = new GLBufferMutable(this.bufferName[1], 34962);
        this.vertexGLBufferDirected.bind(gl);
        this.vertexGLBufferDirected.init(gl, directedVertexData, 35044);
        this.vertexGLBufferDirected.unbind(gl);
        float[] selfLoopVertexDataArray = new float[this.selfLoopMesh.vertexData.length * 8192];
        System.arraycopy(this.selfLoopMesh.vertexData, 0, selfLoopVertexDataArray, 0, this.selfLoopMesh.vertexData.length);
        ArrayUtils.repeat(selfLoopVertexDataArray, 0, this.selfLoopMesh.vertexData.length, 8192);
        FloatBuffer selfLoopVertexData = GLBuffers.newDirectFloatBuffer((float[])selfLoopVertexDataArray);
        this.vertexGLBufferSelfLoop = new GLBufferMutable(this.bufferName[4], 34962);
        this.vertexGLBufferSelfLoop.bind(gl);
        this.vertexGLBufferSelfLoop.init(gl, selfLoopVertexData, 35044);
        this.vertexGLBufferSelfLoop.unbind(gl);
        this.attributesGLBufferDirected = new GLBufferMutable(this.bufferName[2], 34962);
        this.attributesGLBufferDirected.bind(gl);
        this.attributesGLBufferDirected.init(gl, (long)VERTEX_COUNT_MAX * (long)ATTRIBS_STRIDE * 4L * 32768L, 35048);
        this.attributesGLBufferDirected.unbind(gl);
        this.attributesGLBufferUndirected = new GLBufferMutable(this.bufferName[3], 34962);
        this.attributesGLBufferUndirected.bind(gl);
        this.attributesGLBufferUndirected.init(gl, (long)VERTEX_COUNT_MAX * (long)ATTRIBS_STRIDE * 4L * 32768L, 35048);
        this.attributesGLBufferUndirected.unbind(gl);
        this.attributesGLBufferSelfLoop = new GLBufferMutable(this.bufferName[5], 34962);
        this.attributesGLBufferSelfLoop.bind(gl);
        this.attributesGLBufferSelfLoop.init(gl, (long)this.selfLoopMesh.vertexData.length * 5L * 4L * 8192L, 35048);
        this.attributesGLBufferSelfLoop.unbind(gl);
        this.attributesBuffer = new float[ATTRIBS_STRIDE * 32768];
        this.selfLoopAttributesBuffer = new float[40960];
    }

    public void updateBuffers() {
        this.undirectedInstanceCounter.promoteCountToDraw();
        this.directedInstanceCounter.promoteCountToDraw();
        this.selfLoopCounter.promoteCountToDraw();
    }

    @Override
    protected void updateData(GraphSelection selection) {
        int totalEdges = this.edgesCallback.getCount();
        this.attributesBuffer = ArrayUtils.ensureCapacityNoCopy(this.attributesBuffer, totalEdges * ATTRIBS_STRIDE);
        float[] attribs = this.attributesBuffer;
        Edge[] visibleEdgesArray = this.edgesCallback.getEdgesArray();
        float[] edgeWeightsArray = this.edgesCallback.getEdgeWeightsArray();
        int maxIndex = this.edgesCallback.getMaxIndex();
        boolean directed = this.edgesCallback.isDirected();
        boolean undirected = this.edgesCallback.isUndirected();
        boolean hasSelfLoop = this.edgesCallback.hasSelfLoop();
        if (hasSelfLoop) {
            this.selfLoopAttributesBuffer = ArrayUtils.ensureCapacityNoCopy(this.selfLoopAttributesBuffer, totalEdges * 5);
            this.updateSelfLoop(maxIndex, visibleEdgesArray, edgeWeightsArray, this.selfLoopAttributesBuffer, 0, null);
        } else {
            this.selfLoopCounter.clearCount();
        }
        int attribsIndex = 0;
        attribsIndex = this.updateUndirectedData(directed, maxIndex, visibleEdgesArray, edgeWeightsArray, attribs, attribsIndex);
        this.updateDirectedData(undirected, maxIndex, visibleEdgesArray, edgeWeightsArray, attribs, attribsIndex);
    }

    @Override
    public void dispose(GL gl) {
        super.dispose(gl);
        this.attributesDrawBufferBatchOneCopyPerVertex = null;
        this.attributesDrawBufferBatchOneCopyPerVertexManagedDirectBuffer.destroy();
        this.attributesBuffer = null;
        this.selfLoopAttributesBuffer = null;
    }
}

