/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.pipeline;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.NEWTEvent;
import java.util.ArrayList;
import java.util.List;
import org.gephi.graph.api.Rect2D;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.spi.InputListener;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.util.actions.InputActionsProcessor;
import org.joml.Vector2f;

public class DefaultJOGLEventListener
implements InputListener<JOGLRenderingTarget, NEWTEvent> {
    private final VizEngine<JOGLRenderingTarget, NEWTEvent> engine;
    private final InputActionsProcessor inputActionsProcessor;
    private static final short MOUSE_LEFT_BUTTON = 1;
    private static final short MOUSE_WHEEL_BUTTON = 2;
    private static final short MOUSE_RIGHT_BUTTON = 3;
    private boolean mouseRightButtonPressed = false;
    private boolean mouseLeftButtonPressed = false;
    private MouseEvent lastMovedPosition = null;
    private VizEngineModel model;
    private int lastX;
    private int lastY;

    public DefaultJOGLEventListener(VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        this.engine = engine;
        this.inputActionsProcessor = new InputActionsProcessor(engine);
    }

    @Override
    public void frameStart(VizEngineModel model) {
        this.lastMovedPosition = null;
        this.model = model;
    }

    @Override
    public void frameEnd(VizEngineModel model) {
        if (this.lastMovedPosition != null) {
            Vector2f worldCoords = this.engine.screenCoordinatesToWorldCoordinates(this.lastMovedPosition.getX(), this.lastMovedPosition.getY());
            if (model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.SINGLE_NODE_SELECTION) {
                this.inputActionsProcessor.selectNodesAndEdgesUnderPosition(model, worldCoords);
            } else if (model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.SIMPLE_MOUSE_SELECTION || model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.MULTI_NODE_SELECTION) {
                float diameter = model.getGraphSelection().getMouseSelectionEffectiveDiameter();
                if (diameter <= 1.0f) {
                    this.inputActionsProcessor.selectNodesAndEdgesUnderPosition(model, worldCoords);
                } else {
                    this.inputActionsProcessor.selectNodesWithinRadius(model, worldCoords.x, worldCoords.y, diameter);
                }
            }
        }
        this.model = null;
    }

    @Override
    public List<NEWTEvent> processEvents(List<NEWTEvent> events) {
        List<NEWTEvent> compressed = this.compressMouseMoveEvents(events);
        ArrayList<NEWTEvent> remaining = new ArrayList<NEWTEvent>();
        for (NEWTEvent event : compressed) {
            boolean consumed = this.processEvent(event);
            if (consumed) continue;
            remaining.add(event);
        }
        return remaining;
    }

    private List<NEWTEvent> compressMouseMoveEvents(List<NEWTEvent> events) {
        if (events.isEmpty()) {
            return events;
        }
        ArrayList<NEWTEvent> compressed = new ArrayList<NEWTEvent>();
        NEWTEvent lastMouseMove = null;
        for (NEWTEvent event : events) {
            if (event instanceof MouseEvent && event.getEventType() == 205) {
                lastMouseMove = event;
                continue;
            }
            if (lastMouseMove != null) {
                compressed.add(lastMouseMove);
                lastMouseMove = null;
            }
            compressed.add(event);
        }
        if (lastMouseMove != null) {
            compressed.add(lastMouseMove);
        }
        return compressed;
    }

    private boolean processEvent(NEWTEvent event) {
        if (event instanceof KeyEvent) {
            return false;
        }
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            switch (event.getEventType()) {
                case 200: {
                    return this.mouseClicked(mouseEvent);
                }
                case 206: {
                    return this.mouseDragged(mouseEvent);
                }
                case 205: {
                    return this.mouseMoved(mouseEvent);
                }
                case 203: {
                    return this.mousePressed(mouseEvent);
                }
                case 204: {
                    return this.mouseReleased(mouseEvent);
                }
                case 207: {
                    return this.mouseWheelMoved(mouseEvent);
                }
            }
            return false;
        }
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        boolean leftClick = e.getClickCount() == 1 && e.getButton() == 1;
        boolean doubleLeftClick = e.getClickCount() == 2 && e.getButton() == 1;
        boolean doubleRightClick = e.getClickCount() == 2 && e.getButton() == 3;
        boolean wheelClick = e.getButton() == 2;
        int x = e.getX();
        int y = e.getY();
        if (wheelClick) {
            this.inputActionsProcessor.processCenterOnGraphEvent();
            return true;
        }
        if (doubleLeftClick) {
            this.inputActionsProcessor.processZoomEvent(10.0, x, y);
            return true;
        }
        if (doubleRightClick) {
            this.inputActionsProcessor.processZoomEvent(-10.0, x, y);
            return true;
        }
        if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.SIMPLE_MOUSE_SELECTION && leftClick) {
            return true;
        }
        if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.SINGLE_NODE_SELECTION && leftClick) {
            return true;
        }
        if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.MULTI_NODE_SELECTION && leftClick) {
            return true;
        }
        if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION) {
            this.inputActionsProcessor.clearSelection(this.model);
            return true;
        }
        return false;
    }

    public boolean mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mouseLeftButtonPressed = true;
            if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION) {
                this.inputActionsProcessor.clearSelection(this.model);
                this.model.getGraphSelection().startRectangleSelection(this.engine.screenCoordinatesToWorldCoordinates(e.getX(), e.getY()));
                return true;
            }
        }
        if (e.getButton() == 3) {
            this.mouseRightButtonPressed = true;
        }
        this.lastX = e.getX();
        this.lastY = e.getY();
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.mouseLeftButtonPressed = false;
        }
        if (e.getButton() == 3) {
            this.mouseRightButtonPressed = false;
        }
        if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION) {
            this.model.getGraphSelection().stopRectangleSelection(this.engine.screenCoordinatesToWorldCoordinates(e.getX(), e.getY()));
        }
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        this.lastMovedPosition = e;
        if ((this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.SIMPLE_MOUSE_SELECTION || this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.MULTI_NODE_SELECTION) && this.model.getGraphSelection().getMouseSelectionDiameter() > 1.0f) {
            this.model.getGraphSelection().updateMousePosition(this.engine.screenCoordinatesToWorldCoordinates(e.getX(), e.getY()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseDragged(MouseEvent e) {
        try {
            if (this.mouseLeftButtonPressed && this.mouseRightButtonPressed) {
                double zoomQuantity = (float)(this.lastY - e.getY()) / 7.0f;
                this.inputActionsProcessor.processZoomEvent(zoomQuantity, this.engine.getWidth() / 2, this.engine.getHeight() / 2);
                boolean bl = true;
                return bl;
            }
            if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.MULTI_NODE_SELECTION && this.model.getGraphSelection().getMouseSelectionDiameter() > 1.0f) {
                this.model.getGraphSelection().updateMousePosition(this.engine.screenCoordinatesToWorldCoordinates(e.getX(), e.getY()));
            } else {
                if (this.model.getGraphSelection().getMode() != GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION && (this.mouseLeftButtonPressed || this.mouseRightButtonPressed)) {
                    this.inputActionsProcessor.processCameraMoveEvent(e.getX() - this.lastX, e.getY() - this.lastY);
                    boolean zoomQuantity = true;
                    return zoomQuantity;
                }
                if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION && this.mouseLeftButtonPressed) {
                    this.model.getGraphSelection().updateRectangleSelection(this.engine.screenCoordinatesToWorldCoordinates(e.getX(), e.getY()));
                    Vector2f initialPosition = this.model.getGraphSelection().getRectangleInitialPosition();
                    Vector2f currentPosition = this.model.getGraphSelection().getRectangleCurrentPosition();
                    if (initialPosition != null && currentPosition != null) {
                        Rect2D rectangle = new Rect2D(Math.min(initialPosition.x, currentPosition.x), Math.min(initialPosition.y, currentPosition.y), Math.max(initialPosition.x, currentPosition.x), Math.max(initialPosition.y, currentPosition.y));
                        this.inputActionsProcessor.selectNodesAndEdgesOnRectangle(this.model, rectangle);
                    }
                    boolean bl = true;
                    return bl;
                }
                if (this.model.getGraphSelection().getMode() == GraphSelection.GraphSelectionMode.RECTANGLE_SELECTION && this.mouseRightButtonPressed) {
                    this.inputActionsProcessor.processCameraMoveEvent(e.getX() - this.lastX, e.getY() - this.lastY);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.lastX = e.getX();
            this.lastY = e.getY();
        }
        return false;
    }

    public boolean mouseWheelMoved(MouseEvent e) {
        float[] rotation = e.getRotation();
        float verticalRotation = rotation[1] * e.getRotationScale();
        this.inputActionsProcessor.processZoomEvent(verticalRotation, e.getX(), e.getY());
        return true;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public String getCategory() {
        return "default";
    }

    @Override
    public int getPreferenceInCategory() {
        return 0;
    }

    @Override
    public String getName() {
        return "Default";
    }

    @Override
    public boolean isAvailable(JOGLRenderingTarget target) {
        return true;
    }

    @Override
    public void init(JOGLRenderingTarget target) {
    }
}

