/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.models.mesh;

import org.gephi.viz.engine.jogl.util.Mesh;

public class NodeDiskVertexMeshGenerator {
    public static Mesh generateFilledCircle(int triangleAmount) {
        double twicePi = Math.PI * 2;
        Mesh mesh = new Mesh();
        mesh.vertexCount = triangleAmount * 3;
        mesh.vertexComponentSize = 2;
        int circleFloatsCount = mesh.vertexCount * mesh.vertexComponentSize;
        mesh.vertexData = new float[circleFloatsCount];
        int triangleComponentSize = 3 * mesh.vertexComponentSize;
        for (int i = 0; i < triangleAmount; ++i) {
            double current_radian = (double)i * (Math.PI * 2) / (double)triangleAmount;
            double next_radian = (double)(i + 1) * (Math.PI * 2) / (double)triangleAmount;
            int index_offset = triangleComponentSize * i;
            mesh.vertexData[index_offset] = 0.0f;
            mesh.vertexData[index_offset + 1] = 0.0f;
            mesh.vertexData[index_offset + 2] = (float)Math.cos(current_radian);
            mesh.vertexData[index_offset + 3] = (float)Math.sin(current_radian);
            if (i == triangleAmount - 1) {
                mesh.vertexData[index_offset + 4] = 1.0f;
                mesh.vertexData[index_offset + 5] = 0.0f;
                continue;
            }
            mesh.vertexData[index_offset + 4] = (float)Math.cos(next_radian);
            mesh.vertexData[index_offset + 5] = (float)Math.sin(next_radian);
        }
        return mesh;
    }
}

