/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.models;

import com.jogamp.opengl.GL2ES2;
import org.gephi.viz.engine.jogl.util.gl.GLShaderProgram;
import org.gephi.viz.engine.util.gl.Constants;

public class NodeDiskModel {
    public static final int VERTEX_FLOATS = 2;
    public static final int POSITION_FLOATS = 2;
    public static final int COLOR_FLOATS = 1;
    public static final int SIZE_FLOATS = 1;
    public static final int TOTAL_ATTRIBUTES_FLOATS = 4;
    private GLShaderProgram program;
    private GLShaderProgram programWithSelectionSelected;
    private GLShaderProgram programWithSelectionUnselected;
    private static final String SHADERS_ROOT = "/org/gephi/viz-engine/shaders/node";
    private static final String SHADERS_NODE_CIRCLE_SOURCE = "node";
    private static final String SHADERS_NODE_CIRCLE_SOURCE_WITH_SELECTION_SELECTED = "node_with_selection_selected";
    private static final String SHADERS_NODE_CIRCLE_SOURCE_WITH_SELECTION_UNSELECTED = "node_with_selection_unselected";

    public void initGLPrograms(GL2ES2 gl) {
        this.program = new GLShaderProgram(SHADERS_ROOT, SHADERS_NODE_CIRCLE_SOURCE, SHADERS_NODE_CIRCLE_SOURCE).addUniformName("mvp").addUniformName("borderSize").addUniformName("nodeBorderDarkenFactor").addAttribLocation("vert", 0).addAttribLocation("position", 1).addAttribLocation("elementColor", 2).addAttribLocation("size", 3).init(gl);
        this.programWithSelectionSelected = new GLShaderProgram(SHADERS_ROOT, SHADERS_NODE_CIRCLE_SOURCE_WITH_SELECTION_SELECTED, SHADERS_NODE_CIRCLE_SOURCE).addUniformName("mvp").addUniformName("globalTime").addUniformName("selectionTime").addUniformName("borderSize").addUniformName("nodeBorderDarkenFactor").addAttribLocation("vert", 0).addAttribLocation("position", 1).addAttribLocation("elementColor", 2).addAttribLocation("size", 3).init(gl);
        this.programWithSelectionUnselected = new GLShaderProgram(SHADERS_ROOT, SHADERS_NODE_CIRCLE_SOURCE_WITH_SELECTION_UNSELECTED, SHADERS_NODE_CIRCLE_SOURCE_WITH_SELECTION_UNSELECTED).addUniformName("mvp").addUniformName("backgroundColor").addUniformName("colorLightenFactor").addUniformName("globalTime").addUniformName("selectionTime").addUniformName("borderSize").addUniformName("nodeBorderDarkenFactor").addAttribLocation("vert", 0).addAttribLocation("position", 1).addAttribLocation("elementColor", 2).addAttribLocation("size", 3).init(gl);
    }

    public void useProgramWithSelectionSelected(GL2ES2 gl, float[] mvpFloats, float globalTime, float selectedTime, float nodeBorderColorFactor) {
        this.programWithSelectionSelected.use(gl);
        gl.glUniformMatrix4fv(this.programWithSelectionSelected.getUniformLocation("mvp"), 1, false, mvpFloats, 0);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("globalTime"), globalTime);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("selectionTime"), selectedTime);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("borderSize"), Constants.getNodeBorderSize());
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("nodeBorderDarkenFactor"), nodeBorderColorFactor);
    }

    public void useProgramWithSelectionUnselected(GL2ES2 gl, float[] mvpFloats, float[] backgroundColorFloats, float colorLightenFactor, float globalTime, float selectedTime, float nodeBorderColorFactor) {
        this.programWithSelectionUnselected.use(gl);
        gl.glUniformMatrix4fv(this.programWithSelectionUnselected.getUniformLocation("mvp"), 1, false, mvpFloats, 0);
        gl.glUniform4fv(this.programWithSelectionUnselected.getUniformLocation("backgroundColor"), 1, backgroundColorFloats, 0);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("colorLightenFactor"), colorLightenFactor);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("globalTime"), globalTime);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("selectionTime"), selectedTime);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("borderSize"), Constants.getNodeBorderSize());
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("nodeBorderDarkenFactor"), nodeBorderColorFactor);
    }

    public void useProgram(GL2ES2 gl, float[] mvpFloats, float nodeBorderColorFactor) {
        this.program.use(gl);
        gl.glUniformMatrix4fv(this.program.getUniformLocation("mvp"), 1, false, mvpFloats, 0);
        gl.glUniform1f(this.program.getUniformLocation("borderSize"), Constants.getNodeBorderSize());
        gl.glUniform1f(this.program.getUniformLocation("nodeBorderDarkenFactor"), nodeBorderColorFactor);
    }

    public void destroy(GL2ES2 gl) {
        if (this.program != null) {
            this.program.destroy(gl);
            this.program = null;
        }
        if (this.programWithSelectionSelected != null) {
            this.programWithSelectionSelected.destroy(gl);
            this.programWithSelectionSelected = null;
        }
        if (this.programWithSelectionUnselected != null) {
            this.programWithSelectionUnselected.destroy(gl);
            this.programWithSelectionUnselected = null;
        }
    }
}

