/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.models;

import com.jogamp.opengl.GL2ES2;
import org.gephi.viz.engine.jogl.util.gl.GLShaderProgram;
import org.gephi.viz.engine.util.NumberUtils;

public class EdgeLineModelDirected {
    public static final int VERTEX_FLOATS = 3;
    public static final int POSITION_SOURCE_FLOATS = 2;
    public static final int POSITION_TARGET_FLOATS = 2;
    public static final int COLOR_FLOATS = 1;
    public static final int SOURCE_SIZE_FLOATS = 1;
    public static final int TARGET_SIZE_FLOATS = 1;
    public static final int SIZE_FLOATS = 1;
    public static final int TOTAL_ATTRIBUTES_FLOATS = 8;
    private static final int VERTEX_PER_TRIANGLE = 3;
    public static final int TRIANGLE_COUNT = 3;
    public static final int VERTEX_COUNT = 9;
    private GLShaderProgram program;
    private GLShaderProgram programWithSelectionSelected;
    private GLShaderProgram programWithSelectionUnselected;
    private static final String SHADERS_ROOT = "/org/gephi/viz-engine/shaders/edge";
    private static final String SHADERS_EDGE_LINE_SOURCE = "edge-line-directed";
    private static final String SHADERS_EDGE_LINE_SOURCE_WITH_SELECTION_SELECTED = "edge-line-directed_with_selection_selected";
    private static final String SHADERS_EDGE_LINE_SOURCE_WITH_SELECTION_UNSELECTED = "edge-line-directed_with_selection_unselected";

    public int getVertexCount() {
        return 9;
    }

    public void initGLPrograms(GL2ES2 gl) {
        this.initProgram(gl);
    }

    private void initProgram(GL2ES2 gl) {
        this.program = new GLShaderProgram(SHADERS_ROOT, SHADERS_EDGE_LINE_SOURCE, SHADERS_EDGE_LINE_SOURCE).addUniformName("mvp").addUniformName("edgeScaleMin").addUniformName("edgeScaleMax").addUniformName("minWeight").addUniformName("nodeScale").addUniformName("weightDifferenceDivisor").addAttribLocation("vert", 0).addAttribLocation("position", 1).addAttribLocation("targetPosition", 8).addAttribLocation("size", 3).addAttribLocation("elementColor", 2).addAttribLocation("sourceSize", 6).addAttribLocation("targetSize", 7).init(gl);
        this.programWithSelectionSelected = new GLShaderProgram(SHADERS_ROOT, SHADERS_EDGE_LINE_SOURCE_WITH_SELECTION_SELECTED, SHADERS_EDGE_LINE_SOURCE).addUniformName("mvp").addUniformName("edgeScaleMin").addUniformName("edgeScaleMax").addUniformName("minWeight").addUniformName("nodeScale").addUniformName("weightDifferenceDivisor").addUniformName("globalTime").addUniformName("selectionTime").addAttribLocation("vert", 0).addAttribLocation("position", 1).addAttribLocation("targetPosition", 8).addAttribLocation("size", 3).addAttribLocation("elementColor", 2).addAttribLocation("sourceSize", 6).addAttribLocation("targetSize", 7).init(gl);
        this.programWithSelectionUnselected = new GLShaderProgram(SHADERS_ROOT, SHADERS_EDGE_LINE_SOURCE_WITH_SELECTION_UNSELECTED, SHADERS_EDGE_LINE_SOURCE).addUniformName("mvp").addUniformName("backgroundColor").addUniformName("colorLightenFactor").addUniformName("edgeScaleMin").addUniformName("edgeScaleMax").addUniformName("minWeight").addUniformName("nodeScale").addUniformName("weightDifferenceDivisor").addUniformName("globalTime").addUniformName("selectionTime").addAttribLocation("vert", 0).addAttribLocation("position", 1).addAttribLocation("targetPosition", 8).addAttribLocation("size", 3).addAttribLocation("elementColor", 2).addAttribLocation("sourceSize", 6).addAttribLocation("targetSize", 7).init(gl);
    }

    public void drawArraysMultipleInstance(GL2ES2 gl, int drawBatchCount) {
        if (drawBatchCount <= 0) {
            return;
        }
        gl.glDrawArrays(4, 0, 9 * drawBatchCount);
    }

    public void useProgram(GL2ES2 gl, float[] mvpFloats, float edgeScale, float minWeight, float maxWeight, float edgeRescaleMin, float edgeRescaleMax, float nodeScale) {
        this.program.use(gl);
        this.prepareProgramData(gl, mvpFloats, edgeScale, minWeight, maxWeight, nodeScale, edgeRescaleMin, edgeRescaleMax);
    }

    public void useProgramWithSelectionSelected(GL2ES2 gl, float[] mvpFloats, float edgeScale, float minWeight, float maxWeight, float edgeResclaleMin, float edgeRescaleMax, float nodeScale, float globalTime, float selectionTime) {
        this.programWithSelectionSelected.use(gl);
        this.prepareProgramDataWithSelectionSelected(gl, mvpFloats, edgeScale, minWeight, maxWeight, nodeScale, edgeResclaleMin, edgeRescaleMax, globalTime, selectionTime);
    }

    public void useProgramWithSelectionUnselected(GL2ES2 gl, float[] mvpFloats, float edgeScale, float minWeight, float maxWeight, float edgeRescaleMin, float edgeRescaleMax, float[] backgroundColorFloats, float colorLightenFactor, float nodeScale, float globalTime, float selectionTime) {
        this.programWithSelectionUnselected.use(gl);
        this.prepareProgramDataWithSelectionUnselected(gl, mvpFloats, edgeScale, minWeight, maxWeight, edgeRescaleMin, edgeRescaleMax, backgroundColorFloats, colorLightenFactor, nodeScale, globalTime, selectionTime);
    }

    private void prepareProgramData(GL2ES2 gl, float[] mvpFloats, float scale, float minWeight, float maxWeight, float nodeScale, float edgeRescaleMin, float edgeRescaleMax) {
        gl.glUniformMatrix4fv(this.program.getUniformLocation("mvp"), 1, false, mvpFloats, 0);
        gl.glUniform1f(this.program.getUniformLocation("edgeScaleMin"), edgeRescaleMin * scale);
        gl.glUniform1f(this.program.getUniformLocation("edgeScaleMax"), edgeRescaleMax * scale);
        gl.glUniform1f(this.program.getUniformLocation("minWeight"), minWeight);
        gl.glUniform1f(this.program.getUniformLocation("nodeScale"), nodeScale);
        if (NumberUtils.equalsEpsilon(minWeight, maxWeight, 0.001f)) {
            gl.glUniform1f(this.program.getUniformLocation("weightDifferenceDivisor"), 1.0f);
        } else {
            gl.glUniform1f(this.program.getUniformLocation("weightDifferenceDivisor"), maxWeight - minWeight);
        }
    }

    private void prepareProgramDataWithSelectionSelected(GL2ES2 gl, float[] mvpFloats, float scale, float minWeight, float maxWeight, float nodeScale, float edgeRescaleMin, float edgeRescaleMax, float globalTime, float selectionTime) {
        gl.glUniformMatrix4fv(this.programWithSelectionSelected.getUniformLocation("mvp"), 1, false, mvpFloats, 0);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("edgeScaleMin"), edgeRescaleMin * scale);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("edgeScaleMax"), edgeRescaleMax * scale);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("minWeight"), minWeight);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("nodeScale"), nodeScale);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("globalTime"), globalTime);
        gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("selectionTime"), selectionTime);
        if (NumberUtils.equalsEpsilon(minWeight, maxWeight, 0.001f)) {
            gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("weightDifferenceDivisor"), 1.0f);
        } else {
            gl.glUniform1f(this.programWithSelectionSelected.getUniformLocation("weightDifferenceDivisor"), maxWeight - minWeight);
        }
    }

    private void prepareProgramDataWithSelectionUnselected(GL2ES2 gl, float[] mvpFloats, float scale, float minWeight, float maxWeight, float edgeRescaleMin, float edgeRescaleMax, float[] backgroundColorFloats, float colorLightenFactor, float nodeScale, float globalTime, float selectionTime) {
        gl.glUniformMatrix4fv(this.programWithSelectionUnselected.getUniformLocation("mvp"), 1, false, mvpFloats, 0);
        gl.glUniform4fv(this.programWithSelectionUnselected.getUniformLocation("backgroundColor"), 1, backgroundColorFloats, 0);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("colorLightenFactor"), colorLightenFactor);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("edgeScaleMin"), edgeRescaleMin * scale);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("edgeScaleMax"), edgeRescaleMax * scale);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("minWeight"), minWeight);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("nodeScale"), nodeScale);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("globalTime"), globalTime);
        gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("selectionTime"), selectionTime);
        if (NumberUtils.equalsEpsilon(minWeight, maxWeight, 0.001f)) {
            gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("weightDifferenceDivisor"), 1.0f);
        } else {
            gl.glUniform1f(this.programWithSelectionUnselected.getUniformLocation("weightDifferenceDivisor"), maxWeight - minWeight);
        }
    }

    public void destroy(GL2ES2 gl) {
        if (this.program != null) {
            this.program.destroy(gl);
            this.program = null;
        }
        if (this.programWithSelectionSelected != null) {
            this.programWithSelectionSelected.destroy(gl);
            this.programWithSelectionSelected = null;
        }
        if (this.programWithSelectionUnselected != null) {
            this.programWithSelectionUnselected.destroy(gl);
            this.programWithSelectionUnselected = null;
        }
    }
}

