/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl.models;

import com.jogamp.opengl.GL2ES2;
import org.gephi.viz.engine.jogl.util.gl.GLShaderProgram;
import org.gephi.viz.engine.util.NumberUtils;

public class EdgeCircleSelfLoopNoSelection {
    public static final int VERTEX_FLOATS = 2;
    public static final int POSITION_FLOATS = 2;
    public static final int COLOR_FLOATS = 1;
    public static final int SIZE_FLOATS = 1;
    public static final int NODE_SIZE_FLOATS = 1;
    public static final int TOTAL_ATTRIBUTES_FLOATS = 5;
    private GLShaderProgram program;
    private static final String SHADERS_ROOT = "/org/gephi/viz-engine/shaders/edge";
    private static final String SHADERS_NODE_CIRCLE_SOURCE = "selfloop";

    public void initGLPrograms(GL2ES2 gl) {
        this.program = new GLShaderProgram(SHADERS_ROOT, SHADERS_NODE_CIRCLE_SOURCE, SHADERS_NODE_CIRCLE_SOURCE).addUniformName("mvp").addUniformName("edgeScaleMin").addUniformName("edgeScaleMax").addUniformName("minWeight").addUniformName("weightDifferenceDivisor").addUniformName("nodeScale").addAttribLocation("vert", 0).addAttribLocation("position", 1).addAttribLocation("elementColor", 2).addAttribLocation("size", 3).addAttribLocation("nodeSize", 9).init(gl);
    }

    public void useProgram(GL2ES2 gl, float[] mvpFloats, float edgeScale, float minWeight, float maxWeight, float edgeRescaleMin, float edgeRescaleMax, float nodeScale) {
        this.program.use(gl);
        gl.glUniformMatrix4fv(this.program.getUniformLocation("mvp"), 1, false, mvpFloats, 0);
        gl.glUniform1f(this.program.getUniformLocation("edgeScaleMin"), edgeRescaleMin * edgeScale);
        gl.glUniform1f(this.program.getUniformLocation("edgeScaleMax"), edgeRescaleMax * edgeScale);
        gl.glUniform1f(this.program.getUniformLocation("minWeight"), minWeight);
        gl.glUniform1f(this.program.getUniformLocation("nodeScale"), nodeScale);
        if (NumberUtils.equalsEpsilon(minWeight, maxWeight, 0.001f)) {
            gl.glUniform1f(this.program.getUniformLocation("weightDifferenceDivisor"), 1.0f);
        } else {
            gl.glUniform1f(this.program.getUniformLocation("weightDifferenceDivisor"), maxWeight - minWeight);
        }
    }

    public void destroy(GL2ES2 gl) {
        if (this.program != null) {
            this.program.destroy(gl);
            this.program = null;
        }
    }
}

