/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl;

import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.jogl.JOGLRenderingTarget;
import org.gephi.viz.engine.jogl.pipeline.DefaultJOGLEventListener;
import org.gephi.viz.engine.jogl.pipeline.arrays.ArrayDrawEdgeData;
import org.gephi.viz.engine.jogl.pipeline.arrays.ArrayDrawNodeData;
import org.gephi.viz.engine.jogl.pipeline.arrays.renderers.EdgeRendererArrayDraw;
import org.gephi.viz.engine.jogl.pipeline.arrays.renderers.NodeRendererArrayDraw;
import org.gephi.viz.engine.jogl.pipeline.arrays.renderers.RectangleSelectionArrayDraw;
import org.gephi.viz.engine.jogl.pipeline.arrays.renderers.SimpleMouseSelectionArrayDraw;
import org.gephi.viz.engine.jogl.pipeline.arrays.updaters.EdgesUpdaterArrayDrawRendering;
import org.gephi.viz.engine.jogl.pipeline.arrays.updaters.NodesUpdaterArrayDrawRendering;
import org.gephi.viz.engine.jogl.pipeline.indirect.IndirectNodeData;
import org.gephi.viz.engine.jogl.pipeline.indirect.renderers.NodeRendererIndirect;
import org.gephi.viz.engine.jogl.pipeline.indirect.updaters.NodesUpdaterIndirectRendering;
import org.gephi.viz.engine.jogl.pipeline.instanced.InstancedEdgeData;
import org.gephi.viz.engine.jogl.pipeline.instanced.InstancedNodeData;
import org.gephi.viz.engine.jogl.pipeline.instanced.renderers.EdgeRendererInstanced;
import org.gephi.viz.engine.jogl.pipeline.instanced.renderers.NodeRendererInstanced;
import org.gephi.viz.engine.jogl.pipeline.instanced.updaters.EdgesUpdaterInstancedRendering;
import org.gephi.viz.engine.jogl.pipeline.instanced.updaters.NodesUpdaterInstancedRendering;
import org.gephi.viz.engine.jogl.pipeline.text.EdgeLabelData;
import org.gephi.viz.engine.jogl.pipeline.text.EdgeLabelRenderer;
import org.gephi.viz.engine.jogl.pipeline.text.EdgeLabelUpdater;
import org.gephi.viz.engine.jogl.pipeline.text.NodeLabelData;
import org.gephi.viz.engine.jogl.pipeline.text.NodeLabelRenderer;
import org.gephi.viz.engine.jogl.pipeline.text.NodeLabelUpdater;
import org.gephi.viz.engine.spi.VizEngineConfigurator;
import org.gephi.viz.engine.util.structure.EdgesCallback;
import org.gephi.viz.engine.util.structure.NodesCallback;

public class VizEngineJOGLConfigurator
implements VizEngineConfigurator<JOGLRenderingTarget, NEWTEvent> {
    public static final String[] GL_PROFILE_LIST_MAX_PROGSHADER_CORE_OR_GL2 = new String[]{"GL4", "GL3", "GLES3", "GL2", "GLES2"};

    public static GLCapabilities createCapabilities(int antialiasing) {
        GLProfile.getDefaultDevice();
        GLProfile glProfile = GLProfile.get((String[])GL_PROFILE_LIST_MAX_PROGSHADER_CORE_OR_GL2, (boolean)true);
        GLCapabilities caps = new GLCapabilities(glProfile);
        Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.INFO, "Chosen GL Profile: {0}", glProfile);
        caps.setAlphaBits(8);
        caps.setDoubleBuffered(true);
        caps.setHardwareAccelerated(true);
        caps.setSampleBuffers(antialiasing > 0);
        if (antialiasing > 0) {
            caps.setNumSamples(antialiasing);
        }
        return caps;
    }

    @Override
    public void configure(VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        NodesCallback nodesCallback = new NodesCallback();
        EdgesCallback edgesCallback = new EdgesCallback();
        this.setupIndirectRendering(nodesCallback, edgesCallback, engine);
        this.setupInstancedRendering(nodesCallback, edgesCallback, engine);
        this.setupVertexArrayRendering(nodesCallback, edgesCallback, engine);
        this.setupInputListeners(engine);
    }

    private void setupIndirectRendering(NodesCallback nodesCallback, EdgesCallback edgesCallback, VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        IndirectNodeData nodeData = new IndirectNodeData(nodesCallback);
        engine.addRenderer(new NodeRendererIndirect(engine, nodeData));
        engine.addWorldUpdater(new NodesUpdaterIndirectRendering(engine, nodeData));
    }

    private void setupInstancedRendering(NodesCallback nodesCallback, EdgesCallback edgesCallback, VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        InstancedNodeData nodeData = new InstancedNodeData(nodesCallback);
        engine.addRenderer(new NodeRendererInstanced(engine, nodeData));
        engine.addWorldUpdater(new NodesUpdaterInstancedRendering(engine, nodeData));
        InstancedEdgeData indirectEdgeData = new InstancedEdgeData(edgesCallback, nodesCallback);
        engine.addRenderer(new EdgeRendererInstanced(engine, indirectEdgeData));
        engine.addWorldUpdater(new EdgesUpdaterInstancedRendering(engine, indirectEdgeData));
    }

    private void setupVertexArrayRendering(NodesCallback nodesCallback, EdgesCallback edgesCallback, VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        ArrayDrawNodeData nodeData = new ArrayDrawNodeData(nodesCallback);
        engine.addRenderer(new NodeRendererArrayDraw(engine, nodeData));
        engine.addWorldUpdater(new NodesUpdaterArrayDrawRendering(engine, nodeData));
        ArrayDrawEdgeData edgeData = new ArrayDrawEdgeData(edgesCallback, nodesCallback);
        engine.addRenderer(new EdgeRendererArrayDraw(engine, edgeData));
        engine.addWorldUpdater(new EdgesUpdaterArrayDrawRendering(engine, edgeData));
        NodeLabelData nodeLabelData = new NodeLabelData(nodesCallback);
        engine.addRenderer(new NodeLabelRenderer(engine, nodeLabelData));
        engine.addWorldUpdater(new NodeLabelUpdater((VizEngine)engine, nodeLabelData));
        EdgeLabelData edgeLabelData = new EdgeLabelData(edgesCallback);
        engine.addRenderer(new EdgeLabelRenderer(engine, edgeLabelData));
        engine.addWorldUpdater(new EdgeLabelUpdater(engine, edgeLabelData));
        engine.addRenderer(new RectangleSelectionArrayDraw(engine));
        engine.addRenderer(new SimpleMouseSelectionArrayDraw(engine));
    }

    private void setupInputListeners(VizEngine<JOGLRenderingTarget, NEWTEvent> engine) {
        engine.addInputListener(new DefaultJOGLEventListener(engine));
    }
}

