/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine.jogl;

import com.jogamp.nativewindow.NativeSurfaceHolder;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.awt.AWTKeyAdapter;
import com.jogamp.newt.event.awt.AWTMouseAdapter;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.AnimatorBase;
import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.TileRendererBase;
import java.awt.Component;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.jogl.util.ScreenshotTaker;
import org.gephi.viz.engine.jogl.util.gl.capabilities.GLCapabilitiesSummary;
import org.gephi.viz.engine.jogl.util.gl.capabilities.Profile;
import org.gephi.viz.engine.spi.RenderingTarget;
import org.gephi.viz.engine.util.TimeUtils;

public class JOGLRenderingTarget
implements RenderingTarget,
GLEventListener,
KeyListener,
MouseListener,
TileRendererBase.TileRendererListener {
    private final GLAutoDrawable drawable;
    private final AnimatorBase animator;
    private VizEngine<JOGLRenderingTarget, NEWTEvent> engine;
    private String windowTitleFormat = null;
    private Frame frame;
    private boolean listenersSetup = false;
    private final float[] backgroundColor = new float[4];
    private long lastFpsTime = 0L;
    private volatile ScreenshotRequest screenshotRequest;

    public JOGLRenderingTarget(GLAutoDrawable drawable) {
        this.drawable = drawable;
        this.animator = new FPSAnimator(drawable, 60, true);
        this.animator.setExclusiveContext(false);
        this.animator.setUpdateFPSFrames(60, null);
    }

    @Override
    public void setup(VizEngine engine) {
        this.engine = engine;
        this.setupEventListeners();
    }

    private synchronized void setupEventListeners() {
        if (this.listenersSetup) {
            return;
        }
        this.drawable.addGLEventListener((GLEventListener)this);
        if (this.drawable instanceof GLWindow) {
            this.setup((GLWindow)this.drawable);
        } else if (this.drawable instanceof GLJPanel) {
            this.setup((GLJPanel)this.drawable);
        } else if (this.drawable instanceof GLCanvas) {
            this.setup((GLCanvas)this.drawable);
        } else {
            throw new RuntimeException("Drawable of type " + String.valueOf(this.drawable.getClass()) + " not supported");
        }
        this.listenersSetup = true;
    }

    private void setup(GLWindow gLWindow) {
        gLWindow.addKeyListener((KeyListener)this);
        gLWindow.addMouseListener((MouseListener)this);
    }

    private void setup(GLJPanel glJpanel) {
        new AWTKeyAdapter((KeyListener)this, (NativeSurfaceHolder)glJpanel).addTo((Component)glJpanel);
        new AWTMouseAdapter((MouseListener)this, (NativeSurfaceHolder)glJpanel).addTo((Component)glJpanel);
    }

    private void setup(GLCanvas glCanvas) {
        new AWTKeyAdapter((KeyListener)this, (NativeSurfaceHolder)glCanvas).addTo((Component)glCanvas);
        new AWTMouseAdapter((MouseListener)this, (NativeSurfaceHolder)glCanvas).addTo((Component)glCanvas);
    }

    public GLAutoDrawable getDrawable() {
        return this.drawable;
    }

    public synchronized void init(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        this.engine.getOpenGLOptions().setGlCapabilitiesSummary(new GLCapabilitiesSummary(gl, Profile.CORE));
        gl.setSwapInterval(0);
        gl.glDisable(2929);
        gl.glDisable(3042);
        this.engine.initPipeline();
        this.lastFpsTime = TimeUtils.getTimeMillis();
        this.animator.start();
    }

    public synchronized void dispose(GLAutoDrawable drawable) {
        this.animator.stop();
        this.engine.disposePipeline();
        this.screenshotRequest = null;
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL().getGL();
        this.engine.getBackgroundColor(this.backgroundColor);
        gl.glClearColor(this.backgroundColor[0], this.backgroundColor[1], this.backgroundColor[2], this.backgroundColor[3]);
        gl.glClear(16384);
        this.updateFPS();
        this.engine.display();
        ScreenshotRequest request = this.screenshotRequest;
        if (request != null && request.scaleFactor == 1) {
            CompletableFuture<BufferedImage> future = request.future;
            future.complete(ScreenshotTaker.takeSimpleScreenshot(drawable.getGL(), this.engine.getWidth(), this.engine.getHeight(), request.transparentBackground));
            if (request.transparentBackground) {
                float[] bgColor = this.engine.getBackgroundColor();
                bgColor[3] = 1.0f;
                this.engine.setBackgroundColor(bgColor);
            }
            this.screenshotRequest = null;
        }
    }

    public synchronized void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.engine.reshape(width, height);
    }

    public void keyPressed(KeyEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void keyReleased(KeyEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void mouseExited(MouseEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void mousePressed(MouseEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public void mouseWheelMoved(MouseEvent e) {
        if (this.screenshotRequest != null) {
            return;
        }
        this.engine.queueEvent((NEWTEvent)e);
    }

    public String getWindowTitleFormat() {
        return this.windowTitleFormat;
    }

    public void setWindowTitleFormat(String windowTitleFormat) {
        this.windowTitleFormat = windowTitleFormat;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    private void updateFPS() {
        if (this.animator != null && TimeUtils.getTimeMillis() - this.lastFpsTime > 1000L) {
            if (this.frame != null && this.windowTitleFormat != null && this.windowTitleFormat.contains("$FPS")) {
                int measuredFps = (int)this.animator.getLastFPS();
                this.frame.setTitle(this.windowTitleFormat.replace("$FPS", String.valueOf(measuredFps)));
            }
            this.lastFpsTime += 1000L;
        }
    }

    @Override
    public int getFps() {
        return this.animator != null ? (int)this.animator.getLastFPS() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<BufferedImage> requestScreenshot(int scaleFactor, boolean transparentBackground, BooleanSupplier isCancelled) {
        if (scaleFactor < 1) {
            throw new IllegalArgumentException("Scale factor must be 1 or greater");
        }
        CompletableFuture<BufferedImage> future = new CompletableFuture<BufferedImage>();
        if (scaleFactor > 1) {
            boolean wasAnimating = this.animator.isAnimating();
            try {
                if (wasAnimating) {
                    this.animator.pause();
                }
                this.engine.pauseUpdating();
                this.screenshotRequest = new ScreenshotRequest(scaleFactor, transparentBackground, future);
                future.complete(ScreenshotTaker.takeTiledScreenshot(this.engine, scaleFactor, transparentBackground, isCancelled));
            }
            finally {
                this.engine.resumeUpdating();
                if (wasAnimating) {
                    this.animator.resume();
                }
                this.screenshotRequest = null;
            }
            return future;
        }
        if (transparentBackground) {
            float[] bgColor = this.engine.getBackgroundColor();
            bgColor[3] = 0.0f;
            this.engine.setBackgroundColor(bgColor);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.screenshotRequest = new ScreenshotRequest(scaleFactor, transparentBackground, future);
        return future;
    }

    public void addTileRendererNotify(TileRendererBase tr) {
    }

    public void removeTileRendererNotify(TileRendererBase tr) {
    }

    public void reshapeTile(TileRendererBase tr, int tileX, int tileY, int tileWidth, int tileHeight, int imageWidth, int imageHeight) {
        this.engine.centerOnTile(tileX, tileY, imageWidth, imageHeight);
    }

    public void startTileRendering(TileRendererBase tr) {
    }

    public void endTileRendering(TileRendererBase tr) {
    }

    private record ScreenshotRequest(int scaleFactor, boolean transparentBackground, CompletableFuture<BufferedImage> future) {
    }
}

