/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine;

import org.gephi.graph.api.GraphModel;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphRenderingOptionsImpl;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.status.GraphSelectionImpl;
import org.gephi.viz.engine.structure.GraphIndexImpl;

public class VizEngineModel {
    private final GraphModel graphModel;
    private final GraphIndexImpl graphIndex;
    private final GraphSelectionImpl graphSelection;
    private final GraphRenderingOptionsImpl renderingOptions;

    protected VizEngineModel(GraphModel graphModel, GraphRenderingOptions renderingOptions, GraphSelection graphSelection) {
        this.graphModel = graphModel;
        this.graphSelection = new GraphSelectionImpl(graphSelection);
        this.graphIndex = new GraphIndexImpl(graphModel, this.graphSelection);
        this.renderingOptions = new GraphRenderingOptionsImpl(renderingOptions);
    }

    public GraphIndexImpl getGraphIndex() {
        return this.graphIndex;
    }

    public GraphModel getGraphModel() {
        return this.graphModel;
    }

    public GraphRenderingOptionsImpl getRenderingOptions() {
        return this.renderingOptions;
    }

    public GraphSelectionImpl getGraphSelection() {
        return this.graphSelection;
    }
}

