/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine;

import java.util.List;
import org.gephi.graph.api.GraphModel;
import org.gephi.viz.engine.VizEngine;
import org.gephi.viz.engine.spi.RenderingTarget;
import org.gephi.viz.engine.spi.VizEngineConfigurator;

public class VizEngineFactory {
    public static <R extends RenderingTarget, I> VizEngine<R, I> newEngine(R renderingTarget, List<? extends VizEngineConfigurator<R, I>> configurators) {
        return VizEngineFactory.newEngine(renderingTarget, null, configurators);
    }

    public static <R extends RenderingTarget, I> VizEngine<R, I> newEngine(R renderingTarget, GraphModel graphModel, List<? extends VizEngineConfigurator<R, I>> configurators) {
        VizEngine engine = new VizEngine(renderingTarget);
        if (graphModel != null) {
            engine.setGraphModel(graphModel, null, null);
        }
        if (configurators != null) {
            for (VizEngineConfigurator configurator : configurators) {
                if (configurator == null) continue;
                configurator.configure(engine);
            }
        }
        return engine;
    }
}

