/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.viz.engine;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Rect2D;
import org.gephi.graph.impl.GraphModelImpl;
import org.gephi.viz.engine.VizEngineModel;
import org.gephi.viz.engine.pipeline.RenderingLayer;
import org.gephi.viz.engine.spi.ElementsCallback;
import org.gephi.viz.engine.spi.InputListener;
import org.gephi.viz.engine.spi.PipelinedExecutor;
import org.gephi.viz.engine.spi.Renderer;
import org.gephi.viz.engine.spi.RenderingTarget;
import org.gephi.viz.engine.spi.WorldData;
import org.gephi.viz.engine.spi.WorldUpdater;
import org.gephi.viz.engine.spi.WorldUpdaterExecutionMode;
import org.gephi.viz.engine.status.GraphRenderingOptions;
import org.gephi.viz.engine.status.GraphRenderingOptionsImpl;
import org.gephi.viz.engine.status.GraphSelection;
import org.gephi.viz.engine.structure.GraphIndex;
import org.gephi.viz.engine.util.TimeUtils;
import org.gephi.viz.engine.util.gl.OpenGLOptions;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class VizEngine<R extends RenderingTarget, I> {
    public static final int DEFAULT_MAX_WORLD_UPDATES_PER_SECOND = 60;
    public static final int DEFAULT_FPS = 60;
    public static final boolean DEFAULT_DARK_LAF = false;
    private static final RenderingLayer[] ALL_LAYERS = RenderingLayer.values();
    private final R renderingTarget;
    private boolean isSetUp = false;
    private boolean isDestroyed = false;
    private boolean updating = true;
    private int width = 0;
    private int height = 0;
    private Rect2D viewBoundaries = new Rect2D(0.0f, 0.0f, 0.0f, 0.0f);
    private final Matrix4f modelMatrix = new Matrix4f().identity();
    private final Matrix4f viewMatrix = new Matrix4f();
    private final Matrix4f projectionMatrix = new Matrix4f();
    private final Matrix4f modelViewProjectionMatrix = new Matrix4f();
    private final Matrix4f modelViewProjectionMatrixInverted = new Matrix4f();
    private final float[] modelViewProjectionMatrixFloats = new float[16];
    private final Vector2f translate = new Vector2f();
    private final OpenGLOptions openGLOptions;
    private final Set<Renderer<R, ? extends WorldData>> allRenderers = new LinkedHashSet<Renderer<R, ? extends WorldData>>();
    private final List<Renderer<R, ? extends WorldData>> renderersPipeline = new ArrayList<Renderer<R, ? extends WorldData>>();
    private final Set<WorldUpdater<R, ?>> allUpdaters = new LinkedHashSet();
    private final List<WorldUpdater<R, ?>> updatersPipeline = new ArrayList();
    private final List<ElementsCallback<?>> updatersElementsCallbacks = new ArrayList();
    private final ExecutorService worldUpdaterManagerThread;
    private ExecutorService updatersThreadPool;
    private final WorldUpdaterExecutionMode worldUpdatersExecutionMode = WorldUpdaterExecutionMode.CONCURRENT_ASYNCHRONOUS;
    private Future<VizEngineModel> allUpdatersCompletableFuture = null;
    private final Queue<I> eventsQueue = new ConcurrentLinkedQueue<I>();
    private final Set<InputListener<R, I>> allInputListeners = new LinkedHashSet<InputListener<R, I>>();
    private final List<InputListener<R, I>> inputListenersPipeline = new ArrayList<InputListener<R, I>>();
    private volatile VizEngineModel engineModel;
    private List<? extends WorldData> currentWorldData = Collections.emptyList();
    private boolean darkLaf = false;
    private int maxWorldUpdatesPerSecond = 60;
    private long lastWorldUpdateMillis = 0L;

    public VizEngine(R renderingTarget) {
        this.engineModel = this.createEmptyModel();
        this.openGLOptions = new OpenGLOptions();
        this.renderingTarget = (RenderingTarget)Objects.requireNonNull(renderingTarget, "renderingTarget mandatory");
        this.worldUpdaterManagerThread = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, "World Updater Manager"));
        this.loadModelViewProjection();
    }

    private void setup() {
        if (this.isSetUp) {
            return;
        }
        this.renderingTarget.setup(this);
        this.isSetUp = true;
        Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "World updaters execution mode: {0}", (Object)this.worldUpdatersExecutionMode);
    }

    public R getRenderingTarget() {
        return this.renderingTarget;
    }

    public OpenGLOptions getOpenGLOptions() {
        return this.openGLOptions;
    }

    private <T extends PipelinedExecutor> void setupPipelineOfElements(Set<T> allAvailable, List<T> dest, String elementType) {
        ArrayList elements = new ArrayList();
        HashSet<String> categories = new HashSet<String>();
        for (PipelinedExecutor t : allAvailable) {
            categories.add(t.getCategory());
        }
        categories.forEach(category -> {
            PipelinedExecutor bestElement = null;
            for (PipelinedExecutor r : allAvailable) {
                if (!r.isAvailable(this.renderingTarget) || !category.equals(r.getCategory()) || bestElement != null && bestElement.getPreferenceInCategory() >= r.getPreferenceInCategory()) continue;
                bestElement = r;
            }
            if (bestElement != null) {
                elements.add(bestElement);
                Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "Using best available {0} ''{1}'' for category {2}", new Object[]{elementType, bestElement.getName(), category});
            } else {
                Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.WARNING, "No available {0} for category {1}", new Object[]{elementType, category});
            }
        });
        dest.clear();
        dest.addAll(elements);
        dest.sort(new PipelinedExecutor.Comparator());
    }

    private void setupRenderersPipeline() {
        this.setupPipelineOfElements(this.allRenderers, this.renderersPipeline, "Renderer");
    }

    private void setupWorldUpdatersPipeline() {
        this.setupPipelineOfElements(this.allUpdaters, this.updatersPipeline, "WorldUpdater");
    }

    private void setupInputListenersPipeline() {
        this.setupPipelineOfElements(this.allInputListeners, this.inputListenersPipeline, "InputListener");
    }

    private void setupElementsCallbackPipeline() {
        this.updatersElementsCallbacks.clear();
        for (WorldUpdater<R, ?> updater : this.updatersPipeline) {
            ElementsCallback<?> callback = updater.getElementsCallback();
            if (callback == null || this.updatersElementsCallbacks.contains(callback)) continue;
            this.updatersElementsCallbacks.add(callback);
        }
    }

    public void addInputListener(InputListener<R, I> listener) {
        this.allInputListeners.add(listener);
    }

    public void addRenderer(Renderer<R, ? extends WorldData> renderer) {
        if (renderer != null) {
            this.allRenderers.add(renderer);
        }
    }

    public void addWorldUpdater(WorldUpdater<R, ?> updater) {
        if (updater != null) {
            this.allUpdaters.add(updater);
        }
    }

    public WorldUpdaterExecutionMode getWorldUpdatersExecutionMode() {
        return this.worldUpdatersExecutionMode;
    }

    public boolean isWorldUpdaterInPipeline(WorldUpdater<R, ?> renderer) {
        return this.updatersPipeline.contains(renderer);
    }

    public Vector2fc getTranslate() {
        return this.translate;
    }

    public Vector2f getTranslate(Vector2f dest) {
        return dest.set(this.translate);
    }

    public void setTranslate(float x, float y) {
        this.translate.set(x, y);
        this.engineModel.getRenderingOptions().setPan(this.translate);
        this.loadModelViewProjection();
    }

    public void setTranslate(Vector2fc value) {
        this.translate.set(value);
        this.engineModel.getRenderingOptions().setPan(this.translate);
        this.loadModelViewProjection();
    }

    public void translate(float x, float y) {
        this.translate.add(x, y);
        this.engineModel.getRenderingOptions().setPan(this.translate);
        this.loadModelViewProjection();
    }

    public void translate(Vector2fc value) {
        this.translate.add(value);
        this.engineModel.getRenderingOptions().setPan(this.translate);
        this.loadModelViewProjection();
    }

    public float getZoom() {
        return this.engineModel.getRenderingOptions().getZoom();
    }

    public int getFps() {
        return this.renderingTarget.getFps();
    }

    public void setZoom(float zoom) {
        this.engineModel.getRenderingOptions().setZoom(zoom);
        this.loadModelViewProjection();
    }

    public float aspectRatio() {
        return (float)this.width / (float)this.height;
    }

    public void centerOnGraph() {
        Rect2D visibleGraphBoundaries = this.engineModel.getGraphIndex().getGraphBoundaries();
        float[] center = visibleGraphBoundaries.center();
        this.centerOn(new Vector2f(center[0], center[1]), visibleGraphBoundaries.width(), visibleGraphBoundaries.height());
    }

    public void centerOn(Vector2fc center, float width, float height) {
        this.setTranslate(-center.x(), -center.y());
        if (width > 0.0f && height > 0.0f) {
            Rect2D visibleRange = this.getViewBoundaries();
            float zoomFactor = Math.max(width / visibleRange.width(), height / visibleRange.height());
            this.engineModel.getRenderingOptions().setZoom(this.getZoom() / zoomFactor);
        }
        this.loadModelViewProjection();
    }

    public void centerOnTile(float tileX, float tileY, float imageWidth, float imageHeight) {
        float scaleFactor = imageWidth / (float)this.width;
        float tileOffsetX = (tileX + (float)this.width / 2.0f - imageWidth / 2.0f) / (float)this.width;
        float tileOffsetY = (tileY + (float)this.height / 2.0f - imageHeight / 2.0f) / (float)this.height;
        float newZoom = this.getZoom() * scaleFactor;
        this.engineModel.getRenderingOptions().setZoom(newZoom);
        float translateOffsetX = -tileOffsetX * (float)this.width / newZoom;
        float translateOffsetY = -tileOffsetY * (float)this.height / newZoom;
        Vector2fc pan = this.engineModel.getRenderingOptions().getPan();
        this.translate.set(pan.x() + translateOffsetX, pan.y() + translateOffsetY);
        this.loadModelViewProjection();
    }

    private void loadModelViewProjection() {
        this.loadModel();
        this.loadView();
        this.loadProjection();
        this.projectionMatrix.mulAffine(this.viewMatrix, this.modelViewProjectionMatrix);
        this.modelViewProjectionMatrix.mulAffine(this.modelMatrix);
        this.modelViewProjectionMatrix.get(this.modelViewProjectionMatrixFloats);
        this.modelViewProjectionMatrix.invertAffine(this.modelViewProjectionMatrixInverted);
        this.calculateWorldBoundaries();
    }

    private void loadModel() {
    }

    private void loadView() {
        float zoom = this.getZoom();
        this.viewMatrix.scaling(zoom, zoom, 1.0f);
        this.viewMatrix.translate(this.translate.x, this.translate.y, 0.0f);
    }

    private void loadProjection() {
        this.projectionMatrix.setOrtho2D((float)(-this.width) / 2.0f, (float)this.width / 2.0f, (float)(-this.height) / 2.0f, (float)this.height / 2.0f);
    }

    private void calculateWorldBoundaries() {
        Vector3f minCoords = new Vector3f();
        Vector3f maxCoords = new Vector3f();
        this.modelViewProjectionMatrixInverted.transformAab(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, minCoords, maxCoords);
        this.viewBoundaries = new Rect2D(minCoords.x, minCoords.y, maxCoords.x, maxCoords.y);
    }

    public void reshape(int width, int height) {
        this.width = width;
        this.height = height;
        this.loadModelViewProjection();
    }

    public synchronized void start() {
        if (this.isDestroyed) {
            throw new IllegalStateException("VizEngine already destroyed, cannot start again. Use pause instead");
        }
        this.setup();
    }

    public synchronized void setGraphModel(GraphModel graphModel, GraphRenderingOptions renderingOptions, GraphSelection graphSelection) {
        if (this.engineModel.getGraphModel() != graphModel) {
            this.engineModel = new VizEngineModel(graphModel, renderingOptions != null ? renderingOptions : new GraphRenderingOptionsImpl(this.darkLaf), graphSelection);
        }
        this.translate.set(this.engineModel.getRenderingOptions().getPan());
        this.loadModelViewProjection();
    }

    public synchronized void unsetGraphModel(GraphModel graphModel) {
        if (this.engineModel.getGraphModel() == graphModel) {
            this.engineModel = this.createEmptyModel();
            this.translate.set(0.0f, 0.0f);
            this.loadModelViewProjection();
        }
    }

    private VizEngineModel createEmptyModel() {
        Configuration config = Configuration.builder().enableSpatialIndex(true).build();
        GraphModelImpl emptyModel = GraphModel.Factory.newInstance((Configuration)config);
        return new VizEngineModel((GraphModel)emptyModel, new GraphRenderingOptionsImpl(this.darkLaf), null);
    }

    public synchronized void initPipeline() {
        this.setupRenderersPipeline();
        this.setupWorldUpdatersPipeline();
        this.setupInputListenersPipeline();
        this.setupElementsCallbackPipeline();
        this.updatersPipeline.forEach(worldUpdater -> worldUpdater.init(this.renderingTarget));
        this.renderersPipeline.forEach(renderer -> renderer.init(this.renderingTarget));
        if (this.worldUpdatersExecutionMode.isConcurrent()) {
            int numThreads = Math.max(Math.min(this.updatersPipeline.size(), 4), 1);
            this.updatersThreadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactory(){
                private int id = 1;

                @Override
                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, "World Updater " + this.id++);
                }
            });
        } else {
            this.updatersThreadPool = null;
        }
        this.loadModelViewProjection();
    }

    public synchronized void disposePipeline() {
        if (this.allUpdatersCompletableFuture != null) {
            this.allUpdatersCompletableFuture.cancel(false);
            this.allUpdatersCompletableFuture = null;
        }
        if (this.updatersThreadPool != null) {
            this.updatersThreadPool.shutdown();
            try {
                this.updatersThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.WARNING, "Interrupted while disposing VizEngine", ex);
            }
        }
        this.updatersPipeline.forEach(worldUpdater -> worldUpdater.dispose(this.renderingTarget));
        this.updatersElementsCallbacks.forEach(ElementsCallback::reset);
        this.renderersPipeline.forEach(renderer -> renderer.dispose(this.renderingTarget));
        this.renderersPipeline.clear();
        this.updatersPipeline.clear();
        this.updatersElementsCallbacks.clear();
        this.inputListenersPipeline.clear();
        this.currentWorldData = Collections.emptyList();
        this.eventsQueue.clear();
        this.lastWorldUpdateMillis = 0L;
    }

    public synchronized void destroy() {
        this.allInputListeners.clear();
        this.inputListenersPipeline.clear();
        if (this.worldUpdatersExecutionMode.isConcurrent()) {
            try {
                this.updatersThreadPool.shutdown();
                boolean terminated = this.updatersThreadPool.awaitTermination(5L, TimeUnit.SECONDS);
                if (!terminated) {
                    this.updatersThreadPool.shutdownNow();
                }
                this.worldUpdaterManagerThread.shutdown();
                boolean managerTerminated = this.worldUpdaterManagerThread.awaitTermination(1L, TimeUnit.SECONDS);
                if (!managerTerminated) {
                    this.worldUpdaterManagerThread.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.WARNING, "Interrupted while destroying VizEngine", ex);
            }
        }
        Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "Disposing {0} world updaters", this.updatersPipeline.size());
        this.updatersPipeline.forEach(worldUpdater -> worldUpdater.dispose(this.renderingTarget));
        this.updatersElementsCallbacks.forEach(ElementsCallback::reset);
        Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.FINE, "Disposing {0} renderers", this.renderersPipeline.size());
        this.renderersPipeline.forEach(renderer -> renderer.dispose(this.renderingTarget));
        this.isDestroyed = true;
    }

    private CompletableFuture<Void> buildUpdaterFuture(WorldUpdater<R, ?> updater, VizEngineModel engineModel) {
        return CompletableFuture.runAsync(() -> {
            try {
                updater.updateWorld(engineModel);
            }
            catch (Throwable t) {
                Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.SEVERE, null, t);
            }
        }, this.updatersThreadPool);
    }

    private CompletableFuture<Void> buildCallbackFuture(ElementsCallback<?> callback, GraphIndex graphIndex, GraphRenderingOptions renderingOptions, Rect2D boundaries) {
        return CompletableFuture.runAsync(() -> {
            try {
                callback.run(graphIndex, renderingOptions, boundaries);
            }
            catch (Throwable t) {
                Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.SEVERE, null, t);
            }
        }, this.updatersThreadPool);
    }

    public void display() {
        List<WorldData> worldData;
        this.renderingTarget.frameStart();
        List<WorldData> list = worldData = this.worldUpdatersExecutionMode.isConcurrent() ? this.checkConcurrentWorldUpdateIsDone() : this.runWorldUpdatersSynchronous(this.engineModel);
        if (worldData.isEmpty() || !this.updating) {
            worldData = this.currentWorldData;
        }
        if (!worldData.isEmpty()) {
            for (RenderingLayer layer : ALL_LAYERS) {
                int rendererIndex = 0;
                for (Renderer<R, WorldData> renderer : this.renderersPipeline) {
                    if (renderer.getLayers().contains((Object)layer)) {
                        WorldData localWorldData = worldData.get(rendererIndex);
                        renderer.render(localWorldData, this.renderingTarget, layer);
                    }
                    ++rendererIndex;
                }
            }
        }
        if (this.worldUpdatersExecutionMode.isConcurrent() && this.updating) {
            this.scheduleNextConcurrentWorldUpdateIfDone(this.engineModel);
        }
        this.currentWorldData = worldData;
        this.renderingTarget.frameEnd();
    }

    private List<? extends WorldData> runWorldUpdatersSynchronous(VizEngineModel model) {
        if (!this.updating) {
            return Collections.emptyList();
        }
        if (this.maxWorldUpdatesPerSecond >= 1 && TimeUtils.getTimeMillis() < this.lastWorldUpdateMillis + (long)(1000 / this.maxWorldUpdatesPerSecond)) {
            return Collections.emptyList();
        }
        this.processInputEvents(model);
        Rect2D viewBoundaries = this.getViewBoundaries();
        for (ElementsCallback<?> elementsCallback : this.updatersElementsCallbacks) {
            elementsCallback.run(model.getGraphIndex(), model.getRenderingOptions(), viewBoundaries);
        }
        for (WorldUpdater worldUpdater : this.updatersPipeline) {
            worldUpdater.updateWorld(model);
        }
        this.lastWorldUpdateMillis = TimeUtils.getTimeMillis();
        return this.renderersPipeline.stream().map(r -> r.worldUpdated(model, this.renderingTarget)).collect(Collectors.toList());
    }

    private List<? extends WorldData> checkConcurrentWorldUpdateIsDone() {
        if (this.allUpdatersCompletableFuture != null) {
            if (this.worldUpdatersExecutionMode.isSynchronous()) {
                return this.runWorldUpdated();
            }
            boolean worldUpdateDone = this.allUpdatersCompletableFuture.isDone();
            if (worldUpdateDone) {
                return this.runWorldUpdated();
            }
        }
        return Collections.emptyList();
    }

    private List<? extends WorldData> runWorldUpdated() {
        try {
            VizEngineModel modelUsedByUpdaters = this.allUpdatersCompletableFuture.get();
            this.allUpdatersCompletableFuture = null;
            return this.renderersPipeline.stream().map(r -> r.worldUpdated(modelUsedByUpdaters, this.renderingTarget)).toList();
        }
        catch (Throwable t) {
            Logger.getLogger(VizEngine.class.getSimpleName()).log(Level.SEVERE, null, t);
            throw new RuntimeException(t);
        }
    }

    private void scheduleNextConcurrentWorldUpdateIfDone(VizEngineModel model) {
        if (!this.updatersThreadPool.isShutdown() && this.allUpdatersCompletableFuture == null) {
            if (this.maxWorldUpdatesPerSecond >= 1 && TimeUtils.getTimeMillis() < this.lastWorldUpdateMillis + (long)(1000 / this.maxWorldUpdatesPerSecond)) {
                return;
            }
            this.allUpdatersCompletableFuture = CompletableFuture.supplyAsync(() -> {
                this.processInputEvents(model);
                CompletableFuture.allOf((CompletableFuture[])this.updatersElementsCallbacks.stream().map(c -> this.buildCallbackFuture((ElementsCallback<?>)c, model.getGraphIndex(), model.getRenderingOptions(), this.getViewBoundaries())).toArray(CompletableFuture[]::new)).join();
                CompletableFuture.allOf((CompletableFuture[])this.updatersPipeline.stream().map(u -> this.buildUpdaterFuture((WorldUpdater<R, ?>)u, model)).toArray(CompletableFuture[]::new)).join();
                return model;
            }, this.worldUpdaterManagerThread);
            this.lastWorldUpdateMillis = TimeUtils.getTimeMillis();
        }
    }

    public GraphModel getGraphModel() {
        return this.engineModel.getGraphModel();
    }

    public GraphIndex getGraphIndex() {
        return this.engineModel.getGraphIndex();
    }

    public GraphSelection getGraphSelection() {
        return this.engineModel.getGraphSelection();
    }

    public GraphRenderingOptions getRenderingOptions() {
        return this.engineModel.getRenderingOptions();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Matrix4fc getModelMatrix() {
        return this.modelMatrix;
    }

    public Matrix4fc getViewMatrix() {
        return this.viewMatrix;
    }

    public Matrix4fc getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public Matrix4fc getModelViewProjectionMatrix() {
        return this.modelViewProjectionMatrix;
    }

    public Matrix4fc getModelViewProjectionMatrixInverted() {
        return this.modelViewProjectionMatrixInverted;
    }

    public Rect2D getViewBoundaries() {
        return this.viewBoundaries;
    }

    public void getBackgroundColor(float[] backgroundColorFloats) {
        System.arraycopy(this.engineModel.getRenderingOptions().getBackgroundColor(), 0, backgroundColorFloats, 0, 4);
    }

    public float[] getBackgroundColor() {
        float[] backgroundColor = this.engineModel.getRenderingOptions().getBackgroundColor();
        return Arrays.copyOf(backgroundColor, backgroundColor.length);
    }

    public void setBackgroundColor(Color color) {
        float[] backgroundColorComponents = new float[4];
        color.getRGBComponents(backgroundColorComponents);
        this.setBackgroundColor(backgroundColorComponents);
    }

    public void setBackgroundColor(float[] backgroundColor) {
        if (backgroundColor.length != 4) {
            throw new IllegalArgumentException("Expected 4 float RGBA color");
        }
        this.engineModel.getRenderingOptions().setBackgroundColor(Arrays.copyOf(backgroundColor, backgroundColor.length));
    }

    public void setDarkLaf(boolean darkLaf) {
        this.darkLaf = darkLaf;
        if (darkLaf && Arrays.equals(this.engineModel.getRenderingOptions().getBackgroundColor(), GraphRenderingOptions.DEFAULT_BACKGROUND_COLOR)) {
            this.engineModel.getRenderingOptions().setBackgroundColor(GraphRenderingOptions.DEFAULT_DARK_BACKGROUND_COLOR);
        } else if (!darkLaf && Arrays.equals(this.engineModel.getRenderingOptions().getBackgroundColor(), GraphRenderingOptions.DEFAULT_DARK_BACKGROUND_COLOR)) {
            this.engineModel.getRenderingOptions().setBackgroundColor(GraphRenderingOptions.DEFAULT_BACKGROUND_COLOR);
        }
    }

    public int getMaxWorldUpdatesPerSecond() {
        return this.maxWorldUpdatesPerSecond;
    }

    public void setMaxWorldUpdatesPerSecond(int maxWorldUpdatesPerSecond) {
        this.maxWorldUpdatesPerSecond = maxWorldUpdatesPerSecond;
    }

    public void getModelViewProjectionMatrixFloats(float[] mvpFloats) {
        this.modelViewProjectionMatrix.get(mvpFloats);
    }

    public float[] getModelViewProjectionMatrixFloats() {
        return Arrays.copyOf(this.modelViewProjectionMatrixFloats, this.modelViewProjectionMatrixFloats.length);
    }

    public void pauseUpdating() {
        this.updating = false;
    }

    public void resumeUpdating() {
        this.updating = true;
    }

    public Vector2f screenCoordinatesToWorldCoordinates(int x, int y) {
        return this.screenCoordinatesToWorldCoordinates(x, y, new Vector2f());
    }

    public Vector2f screenCoordinatesToWorldCoordinates(int x, int y, Vector2f dest) {
        float halfWidth = (float)this.width / 2.0f;
        float halfHeight = (float)this.height / 2.0f;
        float xScreenNormalized = (-halfWidth + (float)x) / halfWidth;
        float yScreenNormalized = (halfHeight - (float)y) / halfHeight;
        Vector3f worldCoordinates = new Vector3f();
        this.modelViewProjectionMatrixInverted.transformProject(xScreenNormalized, yScreenNormalized, 0.0f, worldCoordinates);
        return dest.set(worldCoordinates.x, worldCoordinates.y);
    }

    public Vector2f worldCoordinatesToScreenCoordinates(float x, float y, Vector3f tempNDC, Vector2f dest) {
        this.modelViewProjectionMatrix.transformProject(x, y, 0.0f, tempNDC);
        float halfW = (float)this.width / 2.0f;
        float halfH = (float)this.height / 2.0f;
        float sx = halfW + tempNDC.x * halfW;
        float sy = halfH + tempNDC.y * halfH;
        return dest.set(sx, sy);
    }

    public float pixelsPerWorldUnitAt(float x, float y, Vector3f tempNDC) {
        float halfW = (float)this.width / 2.0f;
        float halfH = (float)this.height / 2.0f;
        this.modelViewProjectionMatrix.transformProject(x, y, 0.0f, tempNDC);
        float sx0 = halfW + tempNDC.x * halfW;
        float sy0 = halfH + tempNDC.y * halfH;
        this.modelViewProjectionMatrix.transformProject(x + 1.0f, y, 0.0f, tempNDC);
        float sx1 = halfW + tempNDC.x * halfW;
        float sy1 = halfH + tempNDC.y * halfH;
        return (float)Math.hypot(sx1 - sx0, sy1 - sy0);
    }

    private void processInputEvents(VizEngineModel model) {
        InputListener<R, I> inputListener3;
        I event;
        for (InputListener<R, I> inputListener2 : this.inputListenersPipeline) {
            inputListener2.frameStart(model);
        }
        List<Object> events = new ArrayList<I>();
        while ((event = this.eventsQueue.poll()) != null) {
            events.add(event);
        }
        Iterator<InputListener<R, I>> iterator = this.inputListenersPipeline.iterator();
        while (iterator.hasNext() && !(events = (inputListener3 = iterator.next()).processEvents(events)).isEmpty()) {
        }
        for (InputListener<R, I> inputListener3 : this.inputListenersPipeline) {
            inputListener3.frameEnd(model);
        }
    }

    public void queueEvent(I e) {
        this.eventsQueue.offer(e);
    }
}

